/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui.wizards;

import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.projects.IProjectDataProvider;
import com.palmsource.eclipse.palmoscore.ui.PalmOSOptionsPanel;
import com.palmsource.eclipse.palmoscore.ui.wizards.AbstractProjectDataPage;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PalmOSOptionsPage
extends AbstractProjectDataPage {
    private static final String PAGE_NAME = "PalmOSOptionsPage";
    private static final String KEY_TITLE = "WizardPalmOSSettingsPage.title";
    private static final String KEY_DESC = "WizardPalmOSSettingsPage.description";
    private static final String DEFAULT_VERSION = "1";
    private static final String DEFAULT_CREATOR_ID = "STRT";
    private static final String DEFAULT_APP_DB_TYPE = "appl";
    private static final String DEFAULT_BACKUP = "-b";
    private static final String DEFAULT_HIDDEN = "";
    private static final String DEFAULT_BUNDLE = "";
    private static final String DEFAULT_RESET_ON_INSTALL = "";
    private static final String DEFAULT_COPY_PREVENT = "";
    private PalmOSOptionsPanel optionsPanel;
    private Composite composite;
    private boolean initialized = false;
    private Map defaultValues;
    private IProjectDataProvider defaultNameProvider;
    private boolean allowAppSelection = true;
    private boolean allowSLibSelection = true;
    private boolean allowLibSelection = true;
    private boolean allowPDBSelection = false;

    public PalmOSOptionsPage(IProjectDataProvider iProjectDataProvider) {
        this(Messages.getString(KEY_TITLE), Messages.getString(KEY_DESC), iProjectDataProvider);
    }

    public PalmOSOptionsPage(String string, String string2, IProjectDataProvider iProjectDataProvider) {
        super(PAGE_NAME);
        this.setTitle(string);
        this.setDescription(string2);
        this.defaultNameProvider = iProjectDataProvider;
    }

    public void createControl(Composite composite) {
        this.composite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        this.composite.setLayout((Layout)gridLayout);
        this.optionsPanel = new PalmOSOptionsPanel(this.composite, 0, new OptionsDefaultProvider(), true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.optionsPanel.setLayoutData(gridData);
        this.optionsPanel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PalmOSOptionsPage.this.getContainer().updateButtons();
            }
        });
        this.optionsPanel.allowSharedLibProject(this.allowSLibSelection);
        this.optionsPanel.allowStaticLibProject(this.allowLibSelection);
        this.optionsPanel.allowApplicationProject(this.allowAppSelection);
        this.optionsPanel.allowDatabaseProject(this.allowPDBSelection);
        this.setControl((Control)this.composite);
    }

    public boolean isPageComplete() {
        boolean bl = this.optionsPanel.isValid();
        if (!this.initialized) {
            return false;
        }
        String string = this.optionsPanel.getLastError();
        if (string != null) {
            this.setErrorMessage(string);
        }
        if (!bl) {
            return false;
        }
        if (bl && string == null) {
            this.setErrorMessage(null);
        }
        return super.isPageComplete();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && !this.initialized) {
            this.optionsPanel.initialize(true);
            this.initialized = true;
        }
        if (bl) {
            this.optionsPanel.artifactNameChanged();
        }
    }

    public Map getProjectDataValues() {
        return this.optionsPanel.getProjectDataValues();
    }

    public void allowApplicationProject(boolean bl) {
        this.allowAppSelection = bl;
    }

    public void allowSharedLibProject(boolean bl) {
        this.allowSLibSelection = bl;
    }

    public void allowStaticLibProject(boolean bl) {
        this.allowLibSelection = bl;
    }

    public void allowDatabaseProject(boolean bl) {
        this.allowPDBSelection = bl;
    }

    private class OptionsDefaultProvider
    implements IProjectDataProvider {
        OptionsDefaultProvider() {
        }

        public Map getProjectDataValues() {
            PalmOSOptionsPage.this.defaultValues = new Hashtable();
            PalmOSOptionsPage.this.defaultValues.put("ARTIFACT_NAME", PalmOSOptionsPage.this.defaultNameProvider.getProjectDataValues().get("ARTIFACT_NAME"));
            PalmOSOptionsPage.this.defaultValues.put("DATABASE_VERSION", PalmOSOptionsPage.DEFAULT_VERSION);
            PalmOSOptionsPage.this.defaultValues.put("CREATOR_ID", PalmOSOptionsPage.DEFAULT_CREATOR_ID);
            PalmOSOptionsPage.this.defaultValues.put("DB_TYPE", PalmOSOptionsPage.DEFAULT_APP_DB_TYPE);
            PalmOSOptionsPage.this.defaultValues.put("DB_NAME", PalmOSOptionsPage.this.defaultNameProvider.getProjectDataValues().get("ARTIFACT_NAME"));
            PalmOSOptionsPage.this.defaultValues.put("PROJECT_TYPE", PalmOSOptionsPage.DEFAULT_APP_DB_TYPE);
            PalmOSOptionsPage.this.defaultValues.put("DATABASE_BACKUP", PalmOSOptionsPage.DEFAULT_BACKUP);
            PalmOSOptionsPage.this.defaultValues.put("DATABASE_HIDDEN", "");
            PalmOSOptionsPage.this.defaultValues.put("DATABASE_BUNDLE", "");
            PalmOSOptionsPage.this.defaultValues.put("DATABASE_RESET", "");
            PalmOSOptionsPage.this.defaultValues.put("DATABASE_PROTECT", "");
            return PalmOSOptionsPage.this.defaultValues;
        }
    }
}

