/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.StringTokenizer;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CConventions {
    private static final String scopeResolutionOperator = "::";
    private static final char fgDot = '.';

    private static boolean isLegalIdentifier(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf(32) != -1) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static IStatus validateClassName(String string) {
        char[] cArray;
        if (string == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.nullName"), null);
        }
        String string2 = string.trim();
        if (!string.equals(string2) || string.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.nameWithBlanks"), null);
        }
        int n = string.lastIndexOf(scopeResolutionOperator);
        if (n == -1) {
            IStatus iStatus = CConventions.validateIdentifier(string);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            cArray = string.toCharArray();
        } else {
            String string3 = string.substring(0, n).trim();
            IStatus iStatus = CConventions.validateScopeName(string3);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            String string4 = string.substring(n + scopeResolutionOperator.length()).trim();
            iStatus = CConventions.validateIdentifier(string4);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            cArray = string4.toCharArray();
        }
        if (cArray != null) {
            if (CharOperation.contains('$', cArray)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.dollarName"), null);
            }
            if (cArray.length > 0 && Character.isLowerCase(cArray[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.lowercaseName"), null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.invalidName", string), null);
    }

    public static IStatus validateScopeName(String string) {
        if (string == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.nullName"), null);
        }
        int n = string.length();
        if (n == 0) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.emptyName"), null);
        }
        if (string.charAt(0) == '.' || string.charAt(n - 1) == '.') {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.dotName"), null);
        }
        if (CharOperation.isWhitespace(string.charAt(0)) || CharOperation.isWhitespace(string.charAt(string.length() - 1))) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.nameWithBlanks"), null);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, scopeResolutionOperator);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char[] cArray = (string2 = string2.trim()).toCharArray();
            if (cArray == null) {
                return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.illegalIdentifier", string2), null);
            }
            if (bl && cArray.length > 0 && Character.isLowerCase(cArray[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.lowercaseName"), null);
            }
            bl = false;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String string) {
        return CConventions.validateIdentifier(string);
    }

    public static IStatus validateIdentifier(String string) {
        if (!CConventions.isLegalIdentifier(string)) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.illegalIdentifier", string), null);
        }
        if (!CConventions.isValidIdentifier(string)) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.invalid", string), null);
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateMethodName(String string) {
        if (string.startsWith("~")) {
            return CConventions.validateIdentifier(string.substring(1));
        }
        return CConventions.validateIdentifier(string);
    }

    public static boolean isValidIdentifier(String string) {
        IToken iToken = null;
        IScanner iScanner = ParserFactory.createScanner(new CodeReader(string.toCharArray()), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, null, null, null);
        try {
            iToken = iScanner.nextToken();
        }
        catch (Exception exception) {}
        if (iToken != null && iToken.getType() == 1) {
            try {
                iScanner.nextToken();
            }
            catch (EndOfFileException endOfFileException) {
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

