/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.BinaryParserConfig;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorManager;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.core.internal.filetype.ResolverModel;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.ScannerProvider;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.CDTLogWriter;
import org.eclipse.cdt.internal.core.CDescriptorManager;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.DeltaProcessor;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.cdt.internal.core.search.matching.MatchLocator;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.osgi.framework.BundleContext;

public class CCorePlugin
extends Plugin {
    public static final int STATUS_CDTPROJECT_EXISTS = 1;
    public static final int STATUS_CDTPROJECT_MISMATCH = 2;
    public static final int CDT_PROJECT_NATURE_ID_MISMATCH = 3;
    public static final String PLUGIN_ID = "org.eclipse.cdt.core";
    public static final String BUILDER_MODEL_ID = "org.eclipse.cdt.core.CBuildModel";
    public static final String BINARY_PARSER_SIMPLE_ID = "BinaryParser";
    public static final String BINARY_PARSER_UNIQ_ID = "org.eclipse.cdt.core.BinaryParser";
    public static final String PREF_BINARY_PARSER = "binaryparser";
    public static final String DEFAULT_BINARY_PARSER_SIMPLE_ID = "ELF";
    public static final String DEFAULT_BINARY_PARSER_UNIQ_ID = "org.eclipse.cdt.core.ELF";
    public static final String PREF_USE_STRUCTURAL_PARSE_MODE = "useStructualParseMode";
    public static final String ERROR_PARSER_SIMPLE_ID = "ErrorParser";
    public static final String DEFAULT_PATHENTRY_STORE_ID = "org.eclipse.cdt.core.cdtPathEntryStore";
    public static final String BUILD_SCANNER_INFO_SIMPLE_ID = "ScannerInfoProvider";
    public static final String BUILD_SCANNER_INFO_UNIQ_ID = "org.eclipse.cdt.core.ScannerInfoProvider";
    public static final String TRANSLATION_TASK_PRIORITY_NORMAL = "NORMAL";
    public static final String TRANSLATION_TASK_PRIORITY_HIGH = "HIGH";
    public static final String TRANSLATION_TASK_PRIORITY_LOW = "LOW";
    public static final String CORE_ENCODING = "org.eclipse.cdt.core.encoding";
    public CDTLogWriter cdtLog = null;
    private static CCorePlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private CDescriptorManager fDescriptorManager = new CDescriptorManager();
    private CoreModel fCoreModel;
    private ResolverModel fResolverModel;
    private static final String MODEL = "org.eclipse.cdt.core/debug/model";
    private static final String INDEXER = "org.eclipse.cdt.core/debug/indexer";
    private static final String INDEX_MANAGER = "org.eclipse.cdt.core/debug/indexmanager";
    private static final String SEARCH = "org.eclipse.cdt.core/debug/search";
    private static final String MATCH_LOCATOR = "org.eclipse.cdt.core/debug/matchlocator";
    private static final String PARSER = "org.eclipse.cdt.core/debug/parser";
    private static final String SCANNER = "org.eclipse.cdt.core/debug/scanner";
    private static final String DELTA = "org.eclipse.cdt.core/debug/deltaprocessor";
    private static final String RESOLVER = "org.eclipse.cdt.core/debug/typeresolver";

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.core.CCorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public static IWorkingCopy[] getSharedWorkingCopies(IBufferFactory iBufferFactory) {
        Map map;
        Map map2;
        if (iBufferFactory == null) {
            iBufferFactory = BufferManager.getDefaultBufferManager().getDefaultBufferFactory();
        }
        if ((map2 = (Map)(map = CModelManager.getDefault().sharedWorkingCopies).get(iBufferFactory)) == null) {
            return CModelManager.NoWorkingCopy;
        }
        Collection collection = map2.values();
        IWorkingCopy[] iWorkingCopyArray = new IWorkingCopy[collection.size()];
        collection.toArray(iWorkingCopyArray);
        return iWorkingCopyArray;
    }

    public static String getResourceString(String string) {
        try {
            return fgResourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + string + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + string + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String string, String string2) {
        return MessageFormat.format(CCorePlugin.getResourceString(string), string2);
    }

    public static String getFormattedString(String string, String[] stringArray) {
        return MessageFormat.format(CCorePlugin.getResourceString(string), stringArray);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static CCorePlugin getDefault() {
        return fgCPlugin;
    }

    public static void log(Throwable throwable) {
        if (throwable instanceof CoreException) {
            CCorePlugin.log(((CoreException)throwable).getStatus());
        } else {
            CCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", throwable));
        }
    }

    public static void log(IStatus iStatus) {
        CCorePlugin.getDefault().getLog().log(iStatus);
    }

    public CCorePlugin() {
        fgCPlugin = this;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.fDescriptorManager != null) {
                this.fDescriptorManager.shutdown();
            }
            if (this.fCoreModel != null) {
                this.fCoreModel.shutdown();
            }
            if (this.cdtLog != null) {
                this.cdtLog.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(bundleContext);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(bundleContext);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.cdtLog = new CDTLogWriter(CCorePlugin.getDefault().getStateLocation().append(".log").toFile());
        CCorePlugin.getDefault().configurePluginDebugOptions();
        this.fDescriptorManager.startup();
        this.fCoreModel = CoreModel.getDefault();
        this.fCoreModel.startup();
        this.fCoreModel.startIndexing();
        this.getPluginPreferences().setDefault(PREF_USE_STRUCTURAL_PARSE_MODE, false);
        this.fResolverModel = ResolverModel.getDefault();
    }

    public static HashMap getDefaultOptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        HashSet hashSet = CModelManager.OptionNames;
        String[] stringArray = preferences.defaultPropertyNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (hashSet.contains(string)) {
                hashMap.put(string, preferences.getDefaultString(string));
            }
            ++n;
        }
        String[] stringArray2 = preferences.propertyNames();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string = stringArray2[n2];
            if (hashSet.contains(string)) {
                hashMap.put(string, preferences.getDefaultString(string));
            }
            ++n2;
        }
        hashMap.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        return hashMap;
    }

    public static String getOption(String string) {
        if (CORE_ENCODING.equals(string)) {
            return ResourcesPlugin.getEncoding();
        }
        if (CModelManager.OptionNames.contains(string)) {
            Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
            return preferences.getString(string).trim();
        }
        return null;
    }

    public static HashMap getOptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        CCorePlugin cCorePlugin = CCorePlugin.getDefault();
        if (cCorePlugin != null) {
            Preferences preferences = cCorePlugin.getPluginPreferences();
            HashSet hashSet = CModelManager.OptionNames;
            String[] stringArray = preferences.defaultPropertyNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (hashSet.contains(string)) {
                    hashMap.put(string, preferences.getDefaultString(string));
                }
                ++n;
            }
            String[] stringArray2 = preferences.propertyNames();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String string = stringArray2[n2];
                if (hashSet.contains(string)) {
                    hashMap.put(string, preferences.getString(string).trim());
                }
                ++n2;
            }
            hashMap.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        }
        return hashMap;
    }

    public static void setOptions(HashMap hashMap) {
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        if (hashMap == null) {
            hashMap = CCorePlugin.getDefaultOptions();
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!CModelManager.OptionNames.contains(string) || string.equals(CORE_ENCODING)) continue;
            String string2 = (String)hashMap.get(string);
            preferences.setValue(string, string2);
        }
        CCorePlugin.getDefault().savePluginPreferences();
    }

    public IConsole getConsole(String string) {
        try {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "CBuildConsole");
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        String string2 = iConfigurationElementArray[n2].getAttribute("id");
                        if (string == null && string2 == null || string != null && string.equals(string2)) {
                            return (IConsole)iConfigurationElementArray[n2].createExecutableExtension("class");
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            CCorePlugin.log(coreException);
        }
        return new IConsole(){
            private ConsoleOutputStream nullStream = new ConsoleOutputStream(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void write(byte[] byArray) throws IOException {
                }

                public void write(byte[] byArray, int n, int n2) throws IOException {
                }

                public void write(int n) throws IOException {
                }
            };

            public void start(IProject iProject) {
            }

            public ConsoleOutputStream getOutputStream() {
                return this.nullStream;
            }

            public ConsoleOutputStream getInfoStream() {
                return this.nullStream;
            }

            public ConsoleOutputStream getErrorStream() {
                return this.nullStream;
            }
        };
    }

    public IConsole getConsole() {
        return this.getConsole(null);
    }

    public BinaryParserConfig[] getBinaryParserConfigs(IProject iProject) throws CoreException {
        Object object;
        Object object2;
        BinaryParserConfig[] binaryParserConfigArray;
        block8: {
            binaryParserConfigArray = null;
            if (iProject != null) {
                try {
                    object2 = this.getCProjectDescription(iProject);
                    object = object2.get(BINARY_PARSER_UNIQ_ID, true);
                    if (((ICExtensionReference[])object).length <= 0) break block8;
                    ArrayList<BinaryParserConfig> arrayList = new ArrayList<BinaryParserConfig>(((ICExtensionReference[])object).length);
                    int n = 0;
                    while (n < ((ICExtensionReference[])object).length) {
                        IBinaryParser iBinaryParser = null;
                        try {
                            iBinaryParser = (IBinaryParser)((Object)object[n].createExtension());
                            BinaryParserConfig binaryParserConfig = new BinaryParserConfig(iBinaryParser, object[n].getID());
                            arrayList.add(binaryParserConfig);
                        }
                        catch (CoreException coreException) {
                            Status status = new Status(2, PLUGIN_ID, -1, "Binary Parser failure", (Throwable)coreException);
                            CCorePlugin.log((IStatus)status);
                        }
                        catch (ClassCastException classCastException) {
                            CCorePlugin.log(classCastException);
                        }
                        ++n;
                    }
                    binaryParserConfigArray = new BinaryParserConfig[arrayList.size()];
                    arrayList.toArray(binaryParserConfigArray);
                }
                catch (CoreException coreException) {}
            }
        }
        if (binaryParserConfigArray == null && (object2 = this.getDefaultBinaryParser()) != null) {
            object = new BinaryParserConfig((IBinaryParser)object2, DEFAULT_BINARY_PARSER_UNIQ_ID);
            binaryParserConfigArray = new BinaryParserConfig[]{object};
        }
        return binaryParserConfigArray;
    }

    public String[] getBinaryParserIds(IProject iProject) throws CoreException {
        String[] stringArray = null;
        if (iProject != null) {
            try {
                ICDescriptor iCDescriptor = this.getCProjectDescription(iProject);
                ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get(BINARY_PARSER_UNIQ_ID, true);
                if (iCExtensionReferenceArray.length > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>(iCExtensionReferenceArray.length);
                    int n = 0;
                    while (n < iCExtensionReferenceArray.length) {
                        arrayList.add(iCExtensionReferenceArray[n].getID());
                        ++n;
                    }
                    stringArray = new String[arrayList.size()];
                    arrayList.toArray(stringArray);
                }
            }
            catch (CoreException coreException) {
                CCorePlugin.log(coreException);
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{DEFAULT_BINARY_PARSER_UNIQ_ID};
        }
        return stringArray;
    }

    public IBinaryParser[] getBinaryParser(IProject iProject) throws CoreException {
        Object object;
        IBinaryParser[] iBinaryParserArray;
        block8: {
            iBinaryParserArray = null;
            if (iProject != null) {
                try {
                    object = this.getCProjectDescription(iProject);
                    ICExtensionReference[] iCExtensionReferenceArray = object.get(BINARY_PARSER_UNIQ_ID, true);
                    if (iCExtensionReferenceArray.length <= 0) break block8;
                    ArrayList<IBinaryParser> arrayList = new ArrayList<IBinaryParser>(iCExtensionReferenceArray.length);
                    int n = 0;
                    while (n < iCExtensionReferenceArray.length) {
                        IBinaryParser iBinaryParser = null;
                        try {
                            iBinaryParser = (IBinaryParser)((Object)iCExtensionReferenceArray[n].createExtension());
                        }
                        catch (ClassCastException classCastException) {}
                        if (iBinaryParser != null) {
                            arrayList.add(iBinaryParser);
                        }
                        ++n;
                    }
                    iBinaryParserArray = new IBinaryParser[arrayList.size()];
                    arrayList.toArray(iBinaryParserArray);
                }
                catch (CoreException coreException) {}
            }
        }
        if (iBinaryParserArray == null && (object = this.getDefaultBinaryParser()) != null) {
            iBinaryParserArray = new IBinaryParser[]{object};
        }
        return iBinaryParserArray;
    }

    public IBinaryParser getDefaultBinaryParser() throws CoreException {
        IExtensionPoint iExtensionPoint;
        IExtension iExtension;
        IBinaryParser iBinaryParser = null;
        String string = this.getPluginPreferences().getDefaultString(PREF_BINARY_PARSER);
        if (string == null || string.length() == 0) {
            string = DEFAULT_BINARY_PARSER_UNIQ_ID;
        }
        if ((iExtension = (iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, BINARY_PARSER_SIMPLE_ID)).getExtension(string)) != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n].getName().equalsIgnoreCase("cextension")) {
                    iBinaryParser = (IBinaryParser)iConfigurationElementArray[n].createExecutableExtension("run");
                    break;
                }
                ++n;
            }
        } else {
            Status status = new Status(4, PLUGIN_ID, -1, CCorePlugin.getResourceString("CCorePlugin.exception.noBinaryFormat"), null);
            throw new CoreException((IStatus)status);
        }
        return iBinaryParser;
    }

    public ICFileType getFileType(IProject iProject, String string) {
        return this.getFileTypeResolver(iProject).getFileType(string);
    }

    public ICFileTypeResolver getFileTypeResolver(IProject iProject) {
        if (iProject == null) {
            return this.getResolverModel().getResolver();
        }
        return this.getResolverModel().getResolver(iProject);
    }

    public IResolverModel getResolverModel() {
        return this.fResolverModel;
    }

    public CoreModel getCoreModel() {
        return this.fCoreModel;
    }

    public ICDescriptor getCProjectDescription(IProject iProject) throws CoreException {
        return this.fDescriptorManager.getDescriptor(iProject);
    }

    public ICDescriptor getCProjectDescription(IProject iProject, boolean bl) throws CoreException {
        return this.fDescriptorManager.getDescriptor(iProject, bl);
    }

    public void mapCProjectOwner(IProject iProject, String string, boolean bl) throws CoreException {
        if (!bl) {
            this.fDescriptorManager.configure(iProject, string);
        } else {
            this.fDescriptorManager.convert(iProject, string);
        }
    }

    public ICDescriptorManager getCDescriptorManager() {
        return this.fDescriptorManager;
    }

    public IProject createCProject(final IProjectDescription iProjectDescription, final IProject iProject, IProgressMonitor iProgressMonitor, final String string) throws CoreException, OperationCanceledException {
        CCorePlugin.getWorkspace().run(new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    if (iProgressMonitor == null) {
                        iProgressMonitor = new NullProgressMonitor();
                    }
                    iProgressMonitor.beginTask("Creating C Project...", 3);
                    if (!iProject.exists()) {
                        iProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    iProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    CCorePlugin.this.mapCProjectOwner(iProject, string, false);
                    CProjectNature.addCNature(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                iProgressMonitor.done();
            }
        }, (ISchedulingRule)CCorePlugin.getWorkspace().getRoot(), 0, iProgressMonitor);
        return iProject;
    }

    public void convertProjectFromCtoCC(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProject != null && iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
            CCProjectNature.addCCNature(iProject, iProgressMonitor);
        }
    }

    public void convertProjectToC(IProject iProject, IProgressMonitor iProgressMonitor, String string) throws CoreException {
        if (iProject == null || iProgressMonitor == null || string == null) {
            return;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        iProjectDescription.setLocation(iProject.getFullPath());
        this.createCProject(iProjectDescription, iProject, iProgressMonitor, string);
    }

    public void convertProjectToCC(IProject iProject, IProgressMonitor iProgressMonitor, String string) throws CoreException {
        if (iProject == null || iProgressMonitor == null || string == null) {
            return;
        }
        this.createCProject(iProject.getDescription(), iProject, iProgressMonitor, string);
        this.convertProjectFromCtoCC(iProject, iProgressMonitor);
    }

    public IProcessList getProcessList() throws CoreException {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "ProcessList");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            IConfigurationElement iConfigurationElement = null;
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if (iConfigurationElementArray[n2].getName().equals("processList")) {
                        String string = iConfigurationElementArray[n2].getAttribute("platform");
                        if (string == null) {
                            if (iConfigurationElement == null) {
                                iConfigurationElement = iConfigurationElementArray[n2];
                            }
                        } else if (string.equals(Platform.getOS())) {
                            return (IProcessList)iConfigurationElementArray[0].createExecutableExtension("class");
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            if (iConfigurationElement != null) {
                return (IProcessList)iConfigurationElement.createExecutableExtension("class");
            }
        }
        return null;
    }

    public String[] getAllErrorParsersIDs() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, ERROR_PARSER_SIMPLE_ID);
        String[] stringArray = new String[]{};
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            ArrayList<String> arrayList = new ArrayList<String>(iExtensionArray.length);
            int n = 0;
            while (n < iExtensionArray.length) {
                arrayList.add(iExtensionArray[n].getUniqueIdentifier());
                ++n;
            }
            return arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public IErrorParser[] getErrorParser(String string) {
        IErrorParser[] iErrorParserArray = new IErrorParser[]{};
        try {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, ERROR_PARSER_SIMPLE_ID);
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                ArrayList<IErrorParser> arrayList = new ArrayList<IErrorParser>(iExtensionArray.length);
                int n = 0;
                while (n < iExtensionArray.length) {
                    String string2 = iExtensionArray[n].getUniqueIdentifier();
                    if (string == null && string2 == null || string != null && string2.equals(string)) {
                        IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                        int n2 = 0;
                        while (n2 < iConfigurationElementArray.length) {
                            IErrorParser iErrorParser = (IErrorParser)iConfigurationElementArray[n2].createExecutableExtension("class");
                            arrayList.add(iErrorParser);
                            ++n2;
                        }
                    }
                    ++n;
                }
                return arrayList.toArray(iErrorParserArray);
            }
        }
        catch (CoreException coreException) {
            CCorePlugin.log(coreException);
        }
        return iErrorParserArray;
    }

    public IScannerInfoProvider getScannerInfoProvider(IProject iProject) {
        IScannerInfoProvider iScannerInfoProvider = null;
        if (iProject != null) {
            try {
                ICDescriptor iCDescriptor = this.getCProjectDescription(iProject);
                ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get(BUILD_SCANNER_INFO_UNIQ_ID, true);
                if (iCExtensionReferenceArray.length > 0) {
                    iScannerInfoProvider = (IScannerInfoProvider)((Object)iCExtensionReferenceArray[0].createExtension());
                }
            }
            catch (CoreException coreException) {}
            if (iScannerInfoProvider == null) {
                return ScannerProvider.getInstance();
            }
        }
        return iScannerInfoProvider;
    }

    public void configurePluginDebugOptions() {
        if (CCorePlugin.getDefault().isDebugging()) {
            String string = Platform.getDebugOption((String)PARSER);
            if (string != null) {
                Util.VERBOSE_PARSER = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)SCANNER)) != null) {
                Util.VERBOSE_SCANNER = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)MODEL)) != null) {
                Util.VERBOSE_MODEL = string.equalsIgnoreCase("true");
            }
            boolean bl = false;
            string = Platform.getDebugOption((String)INDEX_MANAGER);
            if (string != null) {
                IndexManager.VERBOSE = bl = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)INDEXER)) != null) {
                SourceIndexer.VERBOSE = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)SEARCH)) != null) {
                SearchEngine.VERBOSE = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)DELTA)) != null) {
                DeltaProcessor.VERBOSE = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)MATCH_LOCATOR)) != null) {
                MatchLocator.VERBOSE = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)RESOLVER)) != null) {
                ResolverModel.VERBOSE = string.equalsIgnoreCase("true");
            }
            if (bl) {
                JobManager.VERBOSE = true;
            }
        }
    }

    public void setStructuralParseMode(boolean bl) {
        this.getPluginPreferences().setValue(PREF_USE_STRUCTURAL_PARSE_MODE, bl);
        this.savePluginPreferences();
    }

    public boolean useStructuralParseMode() {
        return this.getPluginPreferences().getBoolean(PREF_USE_STRUCTURAL_PARSE_MODE);
    }
}

