/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.ProcessClosure;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CommandLauncher {
    public static final int COMMAND_CANCELED = 1;
    public static final int ILLEGAL_COMMAND = -1;
    public static final int OK = 0;
    protected Process fProcess = null;
    protected boolean fShowCommand = false;
    protected String[] fCommandArgs;
    protected String fErrorMessage = "";
    private String lineSeparator = System.getProperty("line.separator", "\n");
    protected static final long DELAY = 50L;

    public void showCommand(boolean bl) {
        this.fShowCommand = bl;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void setErrorMessage(String string) {
        this.fErrorMessage = string;
    }

    public String[] getCommandArgs() {
        return this.fCommandArgs;
    }

    public Properties getEnvironment() {
        return EnvironmentReader.getEnvVars();
    }

    public String getCommandLine() {
        return this.getCommandLine(this.getCommandArgs());
    }

    protected String[] constructCommandArray(String string, String[] stringArray) {
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public Process execute(IPath iPath, String[] stringArray, String[] stringArray2, IPath iPath2) {
        try {
            this.fCommandArgs = this.constructCommandArray(iPath.toOSString(), stringArray);
            this.fProcess = ProcessFactory.getFactory().exec(this.fCommandArgs, stringArray2, iPath2.toFile());
            this.fErrorMessage = "";
        }
        catch (IOException iOException) {
            this.setErrorMessage(iOException.getMessage());
            this.fProcess = null;
        }
        return this.fProcess;
    }

    public int waitAndRead(OutputStream outputStream, OutputStream outputStream2) {
        if (this.fShowCommand) {
            this.printCommandLine(outputStream);
        }
        if (this.fProcess == null) {
            return -1;
        }
        ProcessClosure processClosure = new ProcessClosure(this.fProcess, outputStream, outputStream2);
        processClosure.runBlocking();
        return 0;
    }

    public int waitAndRead(OutputStream outputStream, OutputStream outputStream2, IProgressMonitor iProgressMonitor) {
        int n;
        PipedInputStream pipedInputStream;
        PipedInputStream pipedInputStream2;
        if (this.fShowCommand) {
            this.printCommandLine(outputStream);
        }
        if (this.fProcess == null) {
            return -1;
        }
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedOutputStream pipedOutputStream2 = new PipedOutputStream();
        try {
            pipedInputStream2 = new PipedInputStream(pipedOutputStream);
            pipedInputStream = new PipedInputStream(pipedOutputStream2);
        }
        catch (IOException iOException) {
            this.setErrorMessage(CCorePlugin.getResourceString("CommandLauncher.error.commandCanceled"));
            return 1;
        }
        ProcessClosure processClosure = new ProcessClosure(this.fProcess, pipedOutputStream2, pipedOutputStream);
        processClosure.runNonBlocking();
        byte[] byArray = new byte[1024];
        int n2 = 0;
        boolean bl = false;
        while (!iProgressMonitor.isCanceled() && processClosure.isAlive()) {
            n = 0;
            try {
                if (pipedInputStream2.available() > 0) {
                    n = pipedInputStream2.read(byArray);
                    outputStream2.write(byArray, 0, n);
                }
                if (pipedInputStream.available() > 0) {
                    n = pipedInputStream.read(byArray);
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {}
            iProgressMonitor.worked(0);
            if (n == 0) {
                if (!bl && (long)n2 > 500L) {
                    try {
                        outputStream2.flush();
                        outputStream.flush();
                        bl = true;
                    }
                    catch (IOException iOException) {}
                    n2 = 0;
                }
                try {
                    n2 += 50;
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            bl = false;
        }
        int n3 = 0;
        if (iProgressMonitor.isCanceled()) {
            processClosure.terminate();
            n3 = 1;
            this.setErrorMessage(CCorePlugin.getResourceString("CommandLauncher.error.commandCanceled"));
        }
        try {
            this.fProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        try {
            while (pipedInputStream2.available() > 0 || pipedInputStream.available() > 0) {
                if (pipedInputStream2.available() > 0) {
                    n = pipedInputStream2.read(byArray);
                    outputStream2.write(byArray, 0, n);
                    outputStream2.flush();
                }
                if (pipedInputStream.available() <= 0) continue;
                n = pipedInputStream.read(byArray);
                outputStream.write(byArray, 0, n);
                outputStream.flush();
            }
            pipedInputStream2.close();
            pipedInputStream.close();
        }
        catch (IOException iOException) {}
        return n3;
    }

    protected void printCommandLine(OutputStream outputStream) {
        if (outputStream != null) {
            String string = this.getCommandLine(this.getCommandArgs());
            try {
                outputStream.write(string.getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {}
        }
    }

    protected String getCommandLine(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fCommandArgs != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(' ');
                ++n;
            }
            stringBuffer.append(this.lineSeparator);
        }
        return stringBuffer.toString();
    }
}

