/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ErrorParserManager
extends OutputStream {
    private int nOpens;
    private static final String OLD_PREF_ERROR_PARSER = "errorOutputParser";
    public static final String PREF_ERROR_PARSER = "org.eclipse.cdt.core.errorOutputParser";
    private IProject fProject;
    private IMarkerGenerator fMarkerGenerator;
    private Map fFilesInProject;
    private List fNameConflicts;
    private Map fErrorParsers;
    private ArrayList fErrors;
    private Vector fDirectoryStack;
    private IPath fBaseDirectory;
    private String previousLine;
    private OutputStream outputStream;
    private StringBuffer currentLine = new StringBuffer();
    private StringBuffer scratchBuffer = new StringBuffer();

    public ErrorParserManager(ACBuilder aCBuilder) {
        this(aCBuilder.getProject(), aCBuilder);
    }

    public ErrorParserManager(IProject iProject, IMarkerGenerator iMarkerGenerator) {
        this(iProject, iMarkerGenerator, null);
    }

    public ErrorParserManager(IProject iProject, IMarkerGenerator iMarkerGenerator, String[] stringArray) {
        this(iProject, iProject.getLocation(), iMarkerGenerator, stringArray);
    }

    public ErrorParserManager(IProject iProject, IPath iPath, IMarkerGenerator iMarkerGenerator, String[] stringArray) {
        this.fProject = iProject;
        if (stringArray == null) {
            this.enableAllParsers();
        } else {
            this.fErrorParsers = new HashMap(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                IErrorParser[] iErrorParserArray = CCorePlugin.getDefault().getErrorParser(stringArray[n]);
                this.fErrorParsers.put(stringArray[n], iErrorParserArray);
                ++n;
            }
        }
        this.fMarkerGenerator = iMarkerGenerator;
        this.initErrorParserManager(iPath);
    }

    private void initErrorParserManager(IPath iPath) {
        this.fFilesInProject = new HashMap();
        this.fNameConflicts = new ArrayList();
        this.fDirectoryStack = new Vector();
        this.fErrors = new ArrayList();
        this.fFilesInProject.clear();
        this.fNameConflicts.clear();
        ArrayList arrayList = new ArrayList();
        this.fBaseDirectory = iPath == null || iPath.isEmpty() ? this.fProject.getLocation() : iPath;
        this.collectFiles((IContainer)this.fProject, arrayList);
        int n = 0;
        while (n < arrayList.size()) {
            IFile iFile = (IFile)arrayList.get(n);
            IFile iFile2 = this.fFilesInProject.put(iFile.getName(), iFile);
            if (iFile2 != null) {
                this.fNameConflicts.add(iFile.getName());
            }
            ++n;
        }
    }

    public IPath getWorkingDirectory() {
        if (this.fDirectoryStack.size() != 0) {
            return (IPath)this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectory;
    }

    public void pushDirectory(IPath iPath) {
        if (iPath != null) {
            IPath iPath2 = null;
            if (this.fBaseDirectory.isPrefixOf(iPath)) {
                int n = this.fBaseDirectory.matchingFirstSegments(iPath);
                iPath2 = iPath.removeFirstSegments(n);
            } else {
                iPath2 = iPath;
            }
            this.fDirectoryStack.addElement(iPath2);
        }
    }

    public IPath popDirectory() {
        int n = this.fDirectoryStack.size();
        if (n != 0) {
            IPath iPath = (IPath)this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(n - 1);
            return iPath;
        }
        return new Path("");
    }

    public int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    private void enableAllParsers() {
        this.fErrorParsers = new HashMap();
        String[] stringArray = CCorePlugin.getDefault().getAllErrorParsersIDs();
        int n = 0;
        while (n < stringArray.length) {
            IErrorParser[] iErrorParserArray = CCorePlugin.getDefault().getErrorParser(stringArray[n]);
            this.fErrorParsers.put(stringArray[n], iErrorParserArray);
            ++n;
        }
        if (this.fErrorParsers.size() == 0) {
            this.initErrorParsersMap();
            CCorePlugin.getDefault().getPluginPreferences().setValue(OLD_PREF_ERROR_PARSER, "");
        }
    }

    private void initErrorParsersMap() {
        String[] stringArray = CCorePlugin.getDefault().getAllErrorParsersIDs();
        int n = 0;
        while (n < stringArray.length) {
            IErrorParser[] iErrorParserArray = CCorePlugin.getDefault().getErrorParser(stringArray[n]);
            this.fErrorParsers.put(stringArray[n], iErrorParserArray);
            ++n;
        }
    }

    protected void collectFiles(IContainer iContainer, List list) {
        try {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IResource iResource = iResourceArray[n];
                if (iResource instanceof IFile) {
                    list.add(iResource);
                } else if (iResource instanceof IContainer) {
                    this.collectFiles((IContainer)iResource, list);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            CCorePlugin.log(coreException.getStatus());
        }
    }

    private void processLine(String string) {
        if (this.fErrorParsers.size() == 0) {
            return;
        }
        String[] stringArray = new String[this.fErrorParsers.size()];
        Iterator iterator = this.fErrorParsers.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        int n2 = n = stringArray.length - 1;
        do {
            IErrorParser[] iErrorParserArray = (IErrorParser[])this.fErrorParsers.get(stringArray[n2]);
            int n3 = 0;
            while (n3 < iErrorParserArray.length) {
                IErrorParser iErrorParser = iErrorParserArray[n3];
                if (iErrorParser.processLine(string, this)) {
                    if (n2 != n) {
                        Object v = this.fErrorParsers.remove(stringArray[n2]);
                        this.fErrorParsers.put(stringArray[n2], v);
                    }
                    return;
                }
                ++n3;
            }
        } while (--n2 >= 0);
    }

    public IFile findFileName(String string) {
        Path path = new Path(string);
        return (IFile)this.fFilesInProject.get(path.lastSegment());
    }

    protected IFile findFileInWorkspace(IPath iPath) {
        IFile iFile = null;
        if (iPath.isAbsolute()) {
            IWorkspaceRoot iWorkspaceRoot = this.fProject.getWorkspace().getRoot();
            iFile = iWorkspaceRoot.getFileForLocation(iPath);
            if (iFile == null) {
                IFile[] iFileArray = iWorkspaceRoot.findFilesForLocation(iPath);
                int n = 0;
                while (n < iFileArray.length) {
                    if (iFileArray[n].getProject().equals((Object)this.fProject)) {
                        iFile = iFileArray[n];
                        break;
                    }
                    ++n;
                }
            }
        } else {
            iFile = this.fProject.getFile(iPath);
        }
        return iFile;
    }

    public boolean isConflictingName(String string) {
        Path path = new Path(string);
        return this.fNameConflicts.contains(path.lastSegment());
    }

    public IFile findFilePath(String string) {
        IPath iPath = null;
        Path path = new Path(string);
        if (path.isAbsolute()) {
            if (this.fBaseDirectory.isPrefixOf((IPath)path)) {
                int n = this.fBaseDirectory.matchingFirstSegments((IPath)path);
                iPath = path.removeFirstSegments(n);
            } else {
                iPath = path;
            }
        } else {
            iPath = this.getWorkingDirectory().append(string);
        }
        IFile iFile = null;
        try {
            iFile = this.findFileInWorkspace(iPath);
        }
        catch (Exception exception) {}
        if (iFile == null || !iFile.exists()) {
            File file = iPath.toFile();
            try {
                String string2 = file.getCanonicalPath();
                iPath = new Path(string2);
                iFile = this.findFileInWorkspace(iPath);
            }
            catch (IOException iOException) {}
        }
        return iFile != null && iFile.exists() ? iFile : null;
    }

    public void generateMarker(IResource iResource, int n, String string, int n2, String string2) {
        Problem problem = new Problem(iResource, n, string, n2, string2);
        this.fErrors.add(problem);
    }

    public String getPreviousLine() {
        return new String(this.previousLine == null ? "" : this.previousLine);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        ++this.nOpens;
        return this;
    }

    public void close() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.checkLine(true);
            this.fDirectoryStack.removeAllElements();
            this.fBaseDirectory = null;
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }

    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public synchronized void write(int n) throws IOException {
        this.currentLine.append((char)n);
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(n);
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n != 0 || n2 < 0 || n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.currentLine.append(new String(byArray, 0, n2));
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(byArray, n, n2);
        }
    }

    private void checkLine(boolean bl) {
        String string = this.currentLine.toString();
        int n = 0;
        while ((n = string.indexOf(10)) != -1) {
            String string2 = string.substring(0, n).trim();
            this.processLine(string2);
            this.previousLine = string2;
            string = string.substring(n + 1);
        }
        this.currentLine.setLength(0);
        if (bl) {
            if (string.length() > 0) {
                this.processLine(string);
                this.previousLine = string;
            }
        } else {
            this.currentLine.append(string);
        }
    }

    public boolean reportProblems() {
        boolean bl = false;
        if (this.nOpens == 0) {
            Iterator iterator = this.fErrors.iterator();
            while (iterator.hasNext()) {
                Problem problem = (Problem)iterator.next();
                if (problem.severity == 3) {
                    bl = true;
                }
                if (problem.file == null) {
                    this.fMarkerGenerator.addMarker((IResource)this.fProject, problem.lineNumber, problem.description, problem.severity, problem.variableName);
                    continue;
                }
                this.fMarkerGenerator.addMarker(problem.file, problem.lineNumber, problem.description, problem.severity, problem.variableName);
            }
            this.fErrors.clear();
        }
        return bl;
    }

    public String getScratchBuffer() {
        return this.scratchBuffer.toString();
    }

    public void appendToScratchBuffer(String string) {
        this.scratchBuffer.append(string);
    }

    public void clearScratchBuffer() {
        this.scratchBuffer.setLength(0);
    }

    protected class Problem {
        protected IResource file;
        protected int lineNumber;
        protected String description;
        protected int severity;
        protected String variableName;

        public Problem(IResource iResource, int n, String string, int n2, String string2) {
            this.file = iResource;
            this.lineNumber = n;
            this.description = string;
            this.severity = n2;
            this.variableName = string2;
        }
    }
}

