/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeInfoVisitor;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheManager;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.browser.util.ArrayUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;

public class AllTypesCache {
    private static final int INITIAL_DELAY = 5000;
    private static IWorkingCopyProvider fgWorkingCopyProvider;
    private static TypeCacheManager fgTypeCacheManager;
    private static IElementChangedListener fgElementChangedListener;
    private static Preferences.IPropertyChangeListener fgPropertyChangeListener;
    private static boolean fgEnableIndexing;
    public static final String ENABLE_BACKGROUND_TYPE_CACHE = "enableBackgroundTypeCache";

    static {
        fgEnableIndexing = true;
    }

    public static void initialize(IWorkingCopyProvider iWorkingCopyProvider) {
        fgWorkingCopyProvider = iWorkingCopyProvider;
        fgTypeCacheManager = new TypeCacheManager(fgWorkingCopyProvider);
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        if (preferences.contains(ENABLE_BACKGROUND_TYPE_CACHE)) {
            fgEnableIndexing = preferences.getBoolean(ENABLE_BACKGROUND_TYPE_CACHE);
        } else {
            preferences.setDefault(ENABLE_BACKGROUND_TYPE_CACHE, true);
            preferences.setValue(ENABLE_BACKGROUND_TYPE_CACHE, true);
            CCorePlugin.getDefault().savePluginPreferences();
            fgEnableIndexing = true;
        }
        fgTypeCacheManager.reconcile(fgEnableIndexing, 40, 5000);
        fgElementChangedListener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent elementChangedEvent) {
                fgTypeCacheManager.processDelta(elementChangedEvent.getDelta());
                fgTypeCacheManager.reconcile(fgEnableIndexing, 40, 0);
            }
        };
        CoreModel.getDefault().addElementChangedListener(fgElementChangedListener);
        fgPropertyChangeListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (string.equals(AllTypesCache.ENABLE_BACKGROUND_TYPE_CACHE)) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    fgEnableIndexing = Boolean.valueOf(string2);
                    if (!fgEnableIndexing) {
                        fgTypeCacheManager.cancelJobs();
                    } else {
                        fgTypeCacheManager.reconcile(fgEnableIndexing, 40, 0);
                    }
                }
            }
        };
        preferences.addPropertyChangeListener(fgPropertyChangeListener);
    }

    public static void terminate() {
        if (fgElementChangedListener != null) {
            CoreModel.getDefault().removeElementChangedListener(fgElementChangedListener);
        }
        if (fgPropertyChangeListener != null) {
            CCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener(fgPropertyChangeListener);
        }
        if (fgTypeCacheManager != null) {
            fgTypeCacheManager.cancelJobs();
        }
    }

    public static ITypeInfo[] getAllTypes() {
        final ArrayList arrayList = new ArrayList();
        TypeSearchScope typeSearchScope = new TypeSearchScope(true);
        IProject[] iProjectArray = typeSearchScope.getEnclosingProjects();
        ITypeInfoVisitor iTypeInfoVisitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo) {
                arrayList.add(iTypeInfo);
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int n = 0;
        while (n < iProjectArray.length) {
            fgTypeCacheManager.getCache(iProjectArray[n]).accept(iTypeInfoVisitor);
            ++n;
        }
        return arrayList.toArray(new ITypeInfo[arrayList.size()]);
    }

    public static ITypeInfo[] getTypes(ITypeSearchScope iTypeSearchScope, int[] nArray) {
        final ArrayList arrayList = new ArrayList();
        final ITypeSearchScope iTypeSearchScope2 = iTypeSearchScope;
        final int[] nArray2 = nArray;
        IProject[] iProjectArray = iTypeSearchScope.getEnclosingProjects();
        ITypeInfoVisitor iTypeInfoVisitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo) {
                if (ArrayUtil.contains(nArray2, iTypeInfo.getCElementType()) && iTypeSearchScope2 != null && iTypeInfo.isEnclosed(iTypeSearchScope2)) {
                    arrayList.add(iTypeInfo);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int n = 0;
        while (n < iProjectArray.length) {
            fgTypeCacheManager.getCache(iProjectArray[n]).accept(iTypeInfoVisitor);
            ++n;
        }
        return arrayList.toArray(new ITypeInfo[arrayList.size()]);
    }

    public static ITypeInfo[] getTypes(ITypeSearchScope iTypeSearchScope, IQualifiedTypeName iQualifiedTypeName, int[] nArray) {
        final ArrayList arrayList = new ArrayList();
        final ITypeSearchScope iTypeSearchScope2 = iTypeSearchScope;
        final int[] nArray2 = nArray;
        final IQualifiedTypeName iQualifiedTypeName2 = iQualifiedTypeName;
        IProject[] iProjectArray = iTypeSearchScope.getEnclosingProjects();
        ITypeInfoVisitor iTypeInfoVisitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo) {
                if (ArrayUtil.contains(nArray2, iTypeInfo.getCElementType()) && iQualifiedTypeName2.equals(iTypeInfo.getQualifiedTypeName()) && iTypeSearchScope2 != null && iTypeInfo.isEnclosed(iTypeSearchScope2)) {
                    arrayList.add(iTypeInfo);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int n = 0;
        while (n < iProjectArray.length) {
            fgTypeCacheManager.getCache(iProjectArray[n]).accept(iTypeInfoVisitor);
            ++n;
        }
        return arrayList.toArray(new ITypeInfo[arrayList.size()]);
    }

    public static ITypeInfo[] getNamespaces(ITypeSearchScope iTypeSearchScope, boolean bl) {
        final ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        final ITypeSearchScope iTypeSearchScope2 = iTypeSearchScope;
        IProject[] iProjectArray = iTypeSearchScope.getEnclosingProjects();
        ITypeInfoVisitor iTypeInfoVisitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo) {
                if (iTypeInfo.getCElementType() == 61 && iTypeSearchScope2 != null && iTypeInfo.isEnclosed(iTypeSearchScope2)) {
                    arrayList.add(iTypeInfo);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int n = 0;
        while (n < iProjectArray.length) {
            ITypeCache iTypeCache = fgTypeCacheManager.getCache(iProjectArray[n]);
            iTypeCache.accept(iTypeInfoVisitor);
            if (bl) {
                arrayList.add(iTypeCache.getGlobalNamespace());
            }
            ++n;
        }
        return arrayList.toArray(new ITypeInfo[arrayList.size()]);
    }

    public static boolean isCacheUpToDate(ITypeSearchScope iTypeSearchScope) {
        AllTypesCache.forceDeltaComplete();
        IProject[] iProjectArray = iTypeSearchScope.getEnclosingProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (iProject.exists() && iProject.isOpen() && !fgTypeCacheManager.getCache(iProject).isUpToDate()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static void forceDeltaComplete() {
        if (fgWorkingCopyProvider != null) {
            IWorkingCopy[] iWorkingCopyArray = fgWorkingCopyProvider.getWorkingCopies();
            int n = 0;
            while (n < iWorkingCopyArray.length) {
                IWorkingCopy iWorkingCopy = iWorkingCopyArray[n];
                try {
                    IWorkingCopy iWorkingCopy2 = iWorkingCopy;
                    synchronized (iWorkingCopy2) {
                        iWorkingCopy.reconcile();
                    }
                }
                catch (CModelException cModelException) {}
                ++n;
            }
        }
    }

    public static void updateCache(ITypeSearchScope iTypeSearchScope, IProgressMonitor iProgressMonitor) {
        IProject[] iProjectArray = iTypeSearchScope.getEnclosingProjects();
        iProgressMonitor.beginTask(TypeCacheMessages.getString("AllTypesCache.updateCache.taskName"), iProjectArray.length);
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            fgTypeCacheManager.getCache(iProject).reconcileAndWait(true, 20, iProgressMonitor);
            ++n;
        }
        iProgressMonitor.done();
    }

    public static ITypeReference resolveTypeLocation(ITypeInfo iTypeInfo, IProgressMonitor iProgressMonitor) {
        ITypeReference iTypeReference = iTypeInfo.getResolvedReference();
        if (iTypeReference == null) {
            IProject iProject = iTypeInfo.getEnclosingProject();
            fgTypeCacheManager.getCache(iProject).cancelJobs();
            fgTypeCacheManager.getCache(iProject).locateTypeAndWait(iTypeInfo, 20, iProgressMonitor);
            iTypeReference = iTypeInfo.getResolvedReference();
            fgTypeCacheManager.reconcile(fgEnableIndexing, 40, 0);
        }
        return iTypeReference;
    }
}

