/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.ArrayList;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.core.runtime.IStatus;

public class QualifiedTypeName
implements IQualifiedTypeName {
    private String[] fSegments;
    private int fHashCode;

    public QualifiedTypeName(IQualifiedTypeName iQualifiedTypeName) {
        this(iQualifiedTypeName.segments());
    }

    public QualifiedTypeName(String[] stringArray) {
        this.fSegments = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.fSegments, 0, stringArray.length);
    }

    public QualifiedTypeName(String string, String[] stringArray) {
        if (stringArray != null) {
            this.fSegments = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, this.fSegments, 0, stringArray.length);
            this.fSegments[this.fSegments.length - 1] = string;
        } else {
            this.fSegments = new String[]{string};
        }
    }

    public QualifiedTypeName(String string) {
        int n = string.indexOf("::", 0);
        if (n == -1) {
            this.fSegments = new String[]{string};
        } else {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>(5);
            int n2 = 0;
            while (n >= 0) {
                string2 = string.substring(n2, n);
                n2 = n + "::".length();
                arrayList.add(string2);
                n = string.indexOf("::", n2);
            }
            string2 = string.substring(n2);
            arrayList.add(string2);
            this.fSegments = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    public String getName() {
        if (this.fSegments.length > 0) {
            return this.fSegments[this.fSegments.length - 1];
        }
        return null;
    }

    public String[] getEnclosingNames() {
        if (this.fSegments.length > 1) {
            String[] stringArray = new String[this.fSegments.length - 1];
            System.arraycopy(this.fSegments, 0, stringArray, 0, this.fSegments.length - 1);
            return stringArray;
        }
        return null;
    }

    public String getFullyQualifiedName() {
        if (this.fSegments.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.fSegments.length) {
                if (n > 0) {
                    stringBuffer.append("::");
                }
                stringBuffer.append(this.fSegments[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public IQualifiedTypeName getEnclosingTypeName() {
        String[] stringArray = this.getEnclosingNames();
        if (stringArray != null) {
            return new QualifiedTypeName(stringArray);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.fSegments.length == 0;
    }

    public boolean isGlobal() {
        if (this.fSegments.length <= 1) {
            return true;
        }
        return this.fSegments[0] == null || this.fSegments[0].length() == 0;
    }

    public int segmentCount() {
        return this.fSegments.length;
    }

    public String[] segments() {
        return this.fSegments;
    }

    public String segment(int n) {
        if (n >= this.fSegments.length) {
            return null;
        }
        return this.fSegments[n];
    }

    public String lastSegment() {
        if (this.fSegments.length > 0) {
            return this.fSegments[this.fSegments.length - 1];
        }
        return null;
    }

    public int matchingFirstSegments(IQualifiedTypeName iQualifiedTypeName) {
        int n = Math.min(this.fSegments.length, iQualifiedTypeName.segmentCount());
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (!this.fSegments[n3].equals(iQualifiedTypeName.segment(n3))) {
                return n2;
            }
            ++n2;
            ++n3;
        }
        return n2;
    }

    public boolean isPrefixOf(IQualifiedTypeName iQualifiedTypeName) {
        if (this.isEmpty()) {
            return true;
        }
        if (this.fSegments.length > iQualifiedTypeName.segmentCount()) {
            return false;
        }
        int n = 0;
        while (n < this.fSegments.length) {
            if (!this.fSegments[n].equals(iQualifiedTypeName.segment(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public IQualifiedTypeName append(String[] stringArray) {
        String[] stringArray2 = new String[this.fSegments.length + stringArray.length];
        System.arraycopy(this.fSegments, 0, stringArray2, 0, this.fSegments.length);
        System.arraycopy(stringArray, 0, stringArray2, this.fSegments.length, stringArray.length);
        return new QualifiedTypeName(stringArray2);
    }

    public IQualifiedTypeName append(IQualifiedTypeName iQualifiedTypeName) {
        return this.append(iQualifiedTypeName.segments());
    }

    public IQualifiedTypeName append(String string) {
        return this.append(new QualifiedTypeName(string));
    }

    public IQualifiedTypeName removeFirstSegments(int n) {
        if (n == 0) {
            return this;
        }
        if (n >= this.fSegments.length || n < 0) {
            return new QualifiedTypeName(new String[0]);
        }
        int n2 = this.fSegments.length - n;
        String[] stringArray = new String[n2];
        System.arraycopy(this.fSegments, n, stringArray, 0, n2);
        return new QualifiedTypeName(stringArray);
    }

    public IQualifiedTypeName removeLastSegments(int n) {
        if (n == 0) {
            return this;
        }
        if (n >= this.fSegments.length || n < 0) {
            return new QualifiedTypeName(new String[0]);
        }
        int n2 = this.fSegments.length - n;
        String[] stringArray = new String[n2];
        System.arraycopy(this.fSegments, 0, stringArray, 0, n2);
        return new QualifiedTypeName(stringArray);
    }

    public boolean isLowLevel() {
        int n = 0;
        while (n < this.fSegments.length) {
            if (this.fSegments[n].startsWith("_")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean validate() {
        int n = 0;
        while (n < this.fSegments.length) {
            if (!QualifiedTypeName.isValidSegment(this.fSegments[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean isValidSegment(String string) {
        IStatus iStatus = CConventions.validateIdentifier(string);
        return iStatus.getSeverity() != 4;
    }

    public int hashCode() {
        String string;
        if (this.fHashCode == 0 && (string = this.getFullyQualifiedName()) != null) {
            this.fHashCode = string.hashCode();
        }
        return this.fHashCode;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (!(object instanceof IQualifiedTypeName)) {
            throw new ClassCastException();
        }
        IQualifiedTypeName iQualifiedTypeName = (IQualifiedTypeName)object;
        return this.getFullyQualifiedName().compareTo(iQualifiedTypeName.getFullyQualifiedName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IQualifiedTypeName)) {
            return false;
        }
        IQualifiedTypeName iQualifiedTypeName = (IQualifiedTypeName)object;
        return QualifiedTypeName.matchSegments(this.fSegments, iQualifiedTypeName.segments());
    }

    private static boolean matchSegments(String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

