/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.util.ArrayUtil;
import org.eclipse.core.resources.IProject;

public class TypeInfo
implements ITypeInfo {
    protected ITypeCache fTypeCache;
    protected int fElementType;
    protected IQualifiedTypeName fQualifiedName;
    protected ITypeReference[] fSourceRefs = null;
    protected int fSourceRefsCount = 0;
    protected static final int INITIAL_REFS_SIZE = 1;
    protected static final int REFS_GROW_BY = 2;
    protected static final ITypeInfo[] EMPTY_TYPES = new ITypeInfo[0];

    public TypeInfo(int n, IQualifiedTypeName iQualifiedTypeName) {
        this.fElementType = n;
        this.fQualifiedName = iQualifiedTypeName;
    }

    public void addReference(ITypeReference iTypeReference) {
        if (this.fSourceRefs == null) {
            this.fSourceRefs = new ITypeReference[1];
            this.fSourceRefsCount = 0;
        } else if (this.fSourceRefsCount == this.fSourceRefs.length) {
            ITypeReference[] iTypeReferenceArray = new ITypeReference[this.fSourceRefs.length + 2];
            System.arraycopy(this.fSourceRefs, 0, iTypeReferenceArray, 0, this.fSourceRefsCount);
            this.fSourceRefs = iTypeReferenceArray;
        }
        this.fSourceRefs[this.fSourceRefsCount] = iTypeReference;
        ++this.fSourceRefsCount;
    }

    public ITypeReference[] getReferences() {
        if (this.fSourceRefs != null) {
            ITypeReference[] iTypeReferenceArray = new ITypeReference[this.fSourceRefsCount];
            System.arraycopy(this.fSourceRefs, 0, iTypeReferenceArray, 0, this.fSourceRefsCount);
            return iTypeReferenceArray;
        }
        return null;
    }

    public ICElement getCElement() {
        ICElement[] iCElementArray;
        ITypeReference iTypeReference = this.getResolvedReference();
        if (iTypeReference != null && (iCElementArray = iTypeReference.getCElements()) != null && iCElementArray.length > 0) {
            if (iCElementArray.length == 1) {
                return iCElementArray[0];
            }
            int n = 0;
            while (n < iCElementArray.length) {
                ICElement iCElement = iCElementArray[n];
                if (iCElement.getElementType() == this.fElementType && iCElement.getElementName().equals(this.getName())) {
                    return iCElement;
                }
                ++n;
            }
        }
        return null;
    }

    public ITypeReference getResolvedReference() {
        int n = 0;
        while (n < this.fSourceRefsCount) {
            ITypeReference iTypeReference = this.fSourceRefs[n];
            if (iTypeReference.getLength() != 0) {
                return iTypeReference;
            }
            ++n;
        }
        return null;
    }

    public boolean isReferenced() {
        return this.fSourceRefs != null;
    }

    public boolean isUndefinedType() {
        return this.fElementType == 0;
    }

    public boolean canSubstituteFor(ITypeInfo iTypeInfo) {
        return this.isExactMatch(iTypeInfo);
    }

    protected boolean isExactMatch(ITypeInfo iTypeInfo) {
        if (this.hashCode() != iTypeInfo.hashCode()) {
            return false;
        }
        if (this.fElementType == iTypeInfo.getCElementType() && this.fQualifiedName.equals(iTypeInfo.getQualifiedTypeName())) {
            IProject iProject = this.getEnclosingProject();
            IProject iProject2 = iTypeInfo.getEnclosingProject();
            if (iProject == null && iProject2 == null) {
                return true;
            }
            if (iProject == null || iProject2 == null) {
                return false;
            }
            return iProject.equals((Object)iProject2);
        }
        return false;
    }

    public boolean exists() {
        return this.fTypeCache != null;
    }

    public int getCElementType() {
        return this.fElementType;
    }

    public void setCElementType(int n) {
        this.fElementType = n;
    }

    public IQualifiedTypeName getQualifiedTypeName() {
        return this.fQualifiedName;
    }

    public String getName() {
        return this.fQualifiedName.getName();
    }

    public boolean isEnclosedType() {
        return this.fQualifiedName.getEnclosingNames() != null;
    }

    public ITypeInfo getEnclosingType(int[] nArray) {
        if (this.fTypeCache != null) {
            return this.fTypeCache.getEnclosingType(this, nArray);
        }
        return null;
    }

    public ITypeInfo getEnclosingType() {
        return this.getEnclosingType(ITypeInfo.KNOWN_TYPES);
    }

    public ITypeInfo getRootNamespace(boolean bl) {
        if (this.fTypeCache != null) {
            return this.fTypeCache.getRootNamespace(this, true);
        }
        return null;
    }

    public boolean isEnclosingType() {
        return this.fElementType == 61 || this.fElementType == 64 || this.fElementType == 65;
    }

    public boolean encloses(ITypeInfo iTypeInfo) {
        if (this.isEnclosingType() && this.fTypeCache == iTypeInfo.getCache()) {
            return this.fQualifiedName.isPrefixOf(iTypeInfo.getQualifiedTypeName());
        }
        return false;
    }

    public boolean isEnclosed(ITypeInfo iTypeInfo) {
        return iTypeInfo.encloses(this);
    }

    public boolean hasEnclosedTypes() {
        if (this.isEnclosingType() && this.fTypeCache != null) {
            return this.fTypeCache.hasEnclosedTypes(this);
        }
        return false;
    }

    public ITypeInfo[] getEnclosedTypes() {
        return this.getEnclosedTypes(ITypeInfo.KNOWN_TYPES);
    }

    public ITypeInfo[] getEnclosedTypes(int[] nArray) {
        if (this.fTypeCache != null) {
            return this.fTypeCache.getEnclosedTypes(this, nArray);
        }
        return EMPTY_TYPES;
    }

    public IProject getEnclosingProject() {
        if (this.fTypeCache != null) {
            return this.fTypeCache.getProject();
        }
        return null;
    }

    public String toString() {
        return this.fQualifiedName.toString();
    }

    public boolean isEnclosed(ITypeSearchScope iTypeSearchScope) {
        if (iTypeSearchScope == null || iTypeSearchScope.isWorkspaceScope()) {
            return true;
        }
        int n = 0;
        while (n < this.fSourceRefsCount) {
            ITypeReference iTypeReference = this.fSourceRefs[n];
            if (iTypeSearchScope.encloses(iTypeReference.getPath())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int hashCode() {
        int n = this.fQualifiedName.hashCode() + this.fElementType;
        IProject iProject = this.getEnclosingProject();
        if (iProject != null) {
            n += iProject.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TypeInfo)) {
            return false;
        }
        return this.isExactMatch((TypeInfo)object);
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (!(object instanceof TypeInfo)) {
            throw new ClassCastException();
        }
        TypeInfo typeInfo = (TypeInfo)object;
        if (this.fElementType != typeInfo.fElementType) {
            return this.fElementType < typeInfo.fElementType ? -1 : 1;
        }
        return this.fQualifiedName.compareTo(typeInfo.getQualifiedTypeName());
    }

    public static boolean isValidType(int n) {
        return ArrayUtil.contains(ITypeInfo.KNOWN_TYPES, n);
    }

    public ITypeCache getCache() {
        return this.fTypeCache;
    }

    public void setCache(ITypeCache iTypeCache) {
        this.fTypeCache = iTypeCache;
    }
}

