/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TypeReference
implements ITypeReference {
    private IPath fPath;
    private IProject fProject;
    private IResource fResource;
    private IWorkingCopy fWorkingCopy;
    private int fOffset;
    private int fLength;

    public TypeReference(IPath iPath, IProject iProject, int n, int n2) {
        this.fPath = iPath;
        this.fProject = iProject;
        this.fWorkingCopy = null;
        this.fResource = null;
        this.fOffset = n;
        this.fLength = n2;
    }

    public TypeReference(IResource iResource, IProject iProject, int n, int n2) {
        this.fPath = null;
        this.fProject = iProject;
        this.fWorkingCopy = null;
        this.fResource = iResource;
        this.fOffset = n;
        this.fLength = n2;
    }

    public TypeReference(IWorkingCopy iWorkingCopy, IProject iProject, int n, int n2) {
        this.fPath = null;
        this.fProject = iProject;
        this.fWorkingCopy = iWorkingCopy;
        this.fResource = null;
        this.fOffset = n;
        this.fLength = n2;
    }

    public TypeReference(IPath iPath, IProject iProject) {
        this(iPath, iProject, 0, 0);
    }

    public TypeReference(IResource iResource, IProject iProject) {
        this(iResource, iProject, 0, 0);
    }

    public TypeReference(IWorkingCopy iWorkingCopy, IProject iProject) {
        this(iWorkingCopy, iProject, 0, 0);
    }

    public IPath getPath() {
        if (this.fWorkingCopy != null) {
            return this.fWorkingCopy.getPath();
        }
        if (this.fResource != null) {
            return this.fResource.getFullPath();
        }
        return this.fPath;
    }

    public IPath getLocation() {
        if (this.fWorkingCopy != null) {
            IResource iResource = this.fWorkingCopy.getUnderlyingResource();
            if (iResource != null) {
                return iResource.getLocation();
            }
            return null;
        }
        if (this.fResource != null) {
            return this.fResource.getLocation();
        }
        if (this.fPath != null) {
            return this.fPath;
        }
        if (this.fProject != null) {
            return this.fProject.getLocation();
        }
        return null;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public IWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public IProject getProject() {
        if (this.fProject != null) {
            return this.fProject;
        }
        if (this.fWorkingCopy != null) {
            ICProject iCProject = this.fWorkingCopy.getCProject();
            if (iCProject != null) {
                return iCProject.getProject();
            }
            return null;
        }
        if (this.fResource != null) {
            return this.fResource.getProject();
        }
        return null;
    }

    public ITranslationUnit getTranslationUnit() {
        ICElement iCElement;
        Object object;
        ITranslationUnit iTranslationUnit = null;
        if (this.fWorkingCopy != null) {
            iTranslationUnit = this.fWorkingCopy.getTranslationUnit();
        } else if (this.fResource != null) {
            object = CoreModel.getDefault().create(this.fResource);
            if (object instanceof ITranslationUnit) {
                iTranslationUnit = (ITranslationUnit)object;
            }
        } else {
            object = this.getLocation();
            iCElement = CoreModel.getDefault().create((IPath)object);
            if (iCElement instanceof ITranslationUnit) {
                iTranslationUnit = (ITranslationUnit)iCElement;
            }
        }
        if (iTranslationUnit == null && (object = this.getProject()) != null && (iCElement = this.findCProject((IProject)object)) != null) {
            IPath iPath = this.getLocation();
            ITranslationUnit iTranslationUnit2 = CoreModel.getDefault().createTranslationUnitFrom((ICProject)iCElement, iPath);
            if (iTranslationUnit2 instanceof ITranslationUnit) {
                iTranslationUnit = iTranslationUnit2;
            }
        }
        return iTranslationUnit;
    }

    private ICProject findCProject(IProject iProject) {
        try {
            ICProject[] iCProjectArray = CoreModel.getDefault().getCModel().getCProjects();
            if (iCProjectArray != null) {
                int n = 0;
                while (n < iCProjectArray.length) {
                    ICProject iCProject = iCProjectArray[n];
                    if (iProject.equals((Object)iCProjectArray[n].getProject())) {
                        return iCProject;
                    }
                    ++n;
                }
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public ICElement[] getCElements() {
        ITranslationUnit iTranslationUnit = this.getTranslationUnit();
        if (iTranslationUnit != null) {
            try {
                return iTranslationUnit.getElementsAtOffset(this.fOffset);
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public IPath getRelativeIncludePath(IProject iProject) {
        IScannerInfo iScannerInfo;
        IScannerInfoProvider iScannerInfoProvider;
        IPath iPath = this.getLocation();
        if (iPath != null && (iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject)) != null && (iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject)) != null) {
            String[] stringArray = iScannerInfo.getIncludePaths();
            IPath iPath2 = null;
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3;
                Path path = new Path(stringArray[n2]);
                if (path.isPrefixOf(iPath) && (n3 = path.matchingFirstSegments(iPath)) > n) {
                    iPath2 = iPath.removeFirstSegments(n3).setDevice(null);
                    n = n3;
                }
                ++n2;
            }
            if (iPath2 != null) {
                iPath = iPath2;
            }
        }
        return iPath;
    }

    public IPath getRelativePath(IPath iPath) {
        int n;
        IPath iPath2 = this.getPath();
        if (iPath2 != null && (n = iPath.matchingFirstSegments(iPath2)) > 0) {
            IPath iPath3 = iPath.removeFirstSegments(n).removeLastSegments(1);
            IPath iPath4 = iPath2.removeFirstSegments(n);
            Path path = new Path("");
            int n2 = 0;
            while (n2 < iPath3.segmentCount()) {
                path = path.append("../");
                ++n2;
            }
            return path.append(iPath4);
        }
        return iPath2;
    }

    public String toString() {
        IPath iPath = this.getLocation();
        if (iPath != null) {
            if (this.fLength == 0 && this.fOffset == 0) {
                return iPath.toString();
            }
            return String.valueOf(iPath.toString()) + ":" + this.fOffset + "-" + (this.fOffset + this.fLength);
        }
        return "";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ITypeReference)) {
            return false;
        }
        ITypeReference iTypeReference = (ITypeReference)object;
        return this.toString().equals(iTypeReference.toString());
    }
}

