/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TypeSearchScope
implements ITypeSearchScope {
    private Set fPathSet = new HashSet();
    private Set fContainerSet = new HashSet();
    private Set fProjectSet = new HashSet();
    private Set fEnclosingProjectSet = new HashSet();
    private boolean fWorkspaceScope = false;
    private IProject[] fAllProjects = null;
    private IProject[] fProjects = null;
    private IPath[] fContainerPaths = null;

    public TypeSearchScope() {
    }

    public TypeSearchScope(boolean bl) {
        this.fWorkspaceScope = bl;
    }

    public TypeSearchScope(ITypeSearchScope iTypeSearchScope) {
        this.add(iTypeSearchScope);
    }

    public Collection pathSet() {
        return this.fPathSet;
    }

    public Collection containerSet() {
        return this.fContainerSet;
    }

    public Collection projectSet() {
        return this.fProjectSet;
    }

    public Collection enclosingProjectSet() {
        return this.fEnclosingProjectSet;
    }

    public boolean encloses(ITypeSearchScope iTypeSearchScope) {
        IPath iPath;
        Iterator iterator;
        if (this.isWorkspaceScope()) {
            return true;
        }
        if (!iTypeSearchScope.pathSet().isEmpty()) {
            iterator = iTypeSearchScope.pathSet().iterator();
            while (iterator.hasNext()) {
                iPath = (IPath)iterator.next();
                if (this.encloses(iPath)) continue;
                return false;
            }
        }
        if (!iTypeSearchScope.containerSet().isEmpty()) {
            iterator = iTypeSearchScope.containerSet().iterator();
            while (iterator.hasNext()) {
                iPath = (IPath)iterator.next();
                if (this.encloses(iPath)) continue;
                return false;
            }
        }
        if (!iTypeSearchScope.projectSet().isEmpty()) {
            iterator = iTypeSearchScope.projectSet().iterator();
            while (iterator.hasNext()) {
                iPath = (IProject)iterator.next();
                if (this.encloses((IProject)iPath)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean encloses(IProject iProject) {
        if (this.isWorkspaceScope()) {
            return true;
        }
        return this.fProjectSet.contains(iProject);
    }

    public boolean encloses(IPath iPath) {
        if (this.isWorkspaceScope()) {
            return true;
        }
        if (this.fPathSet.contains(iPath)) {
            return true;
        }
        if (this.fContainerSet.contains(iPath)) {
            return true;
        }
        if (this.fContainerPaths == null) {
            this.fContainerPaths = this.fContainerSet.toArray(new IPath[this.fContainerSet.size()]);
        }
        int n = 0;
        while (n < this.fContainerPaths.length) {
            if (this.fContainerPaths[n].isPrefixOf(iPath)) {
                return true;
            }
            ++n;
        }
        if (this.fProjectSet.contains(iPath)) {
            return true;
        }
        if (this.fProjects == null) {
            this.fProjects = this.fProjectSet.toArray(new IProject[this.fProjectSet.size()]);
        }
        n = 0;
        while (n < this.fProjects.length) {
            if (TypeSearchScope.projectContainsPath(this.fProjects[n], iPath, false)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean encloses(String string) {
        return this.encloses((IPath)new Path(string));
    }

    public boolean encloses(ICElement iCElement) {
        return this.encloses(iCElement.getPath());
    }

    public boolean encloses(IWorkingCopy iWorkingCopy) {
        return this.encloses(iWorkingCopy.getOriginalElement().getPath());
    }

    public IProject[] getEnclosingProjects() {
        if (this.isWorkspaceScope()) {
            return TypeSearchScope.getAllProjects();
        }
        return this.fEnclosingProjectSet.toArray(new IProject[this.fEnclosingProjectSet.size()]);
    }

    private static boolean projectContainsPath(IProject iProject, IPath iPath, boolean bl) {
        IPath[] iPathArray;
        IPath iPath2 = iProject.getFullPath();
        if (iPath2.isPrefixOf(iPath)) {
            return true;
        }
        if (bl && (iPathArray = TypeSearchScope.getIncludePaths(iProject)) != null) {
            int n = 0;
            while (n < iPathArray.length) {
                IPath iPath3 = iPathArray[n];
                if (iPath3.isPrefixOf(iPath) || iPath3.equals((Object)iPath)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private static IPath[] getIncludePaths(IProject iProject) {
        String[] stringArray;
        IScannerInfo iScannerInfo;
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        if (iScannerInfoProvider != null && (iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject)) != null && (stringArray = iScannerInfo.getIncludePaths()) != null && stringArray.length > 0) {
            IPath[] iPathArray = new IPath[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                iPathArray[n] = new Path(stringArray[n]);
                ++n;
            }
            return iPathArray;
        }
        return null;
    }

    private static IProject[] getAllProjects() {
        IProject[] iProjectArray = TypeSearchScope.getCProjects();
        if (iProjectArray == null) {
            iProjectArray = new IProject[]{};
        }
        return iProjectArray;
    }

    private static IProject[] getCProjects() {
        IProject[] iProjectArray = CCorePlugin.getWorkspace().getRoot().getProjects();
        if (iProjectArray != null) {
            IProject[] iProjectArray2 = new IProject[iProjectArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < iProjectArray.length) {
                IProject iProject = iProjectArray[n2];
                if (TypeSearchScope.isCProject(iProject)) {
                    iProjectArray2[n++] = iProject;
                }
                ++n2;
            }
            if (n > 0) {
                if (n == iProjectArray.length) {
                    return iProjectArray2;
                }
                IProject[] iProjectArray3 = new IProject[n];
                System.arraycopy(iProjectArray2, 0, iProjectArray3, 0, n);
                return iProjectArray3;
            }
        }
        return null;
    }

    private static boolean isCProject(IProject iProject) {
        IProjectDescription iProjectDescription = null;
        try {
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription == null) {
                return false;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        String[] stringArray = iProjectDescription.getNatureIds();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("org.eclipse.cdt.core.cnature")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isPathScope() {
        return !this.fPathSet.isEmpty();
    }

    public boolean isProjectScope() {
        return !this.fProjectSet.isEmpty();
    }

    public boolean isWorkspaceScope() {
        return this.fWorkspaceScope;
    }

    public boolean isEmpty() {
        return !this.isWorkspaceScope() && this.fPathSet.isEmpty() && this.fContainerSet.isEmpty() && this.fProjectSet.isEmpty();
    }

    public void add(IWorkingCopy iWorkingCopy) {
        IPath iPath = iWorkingCopy.getOriginalElement().getPath();
        IProject iProject = null;
        ICProject iCProject = iWorkingCopy.getCProject();
        if (iCProject != null) {
            iProject = iCProject.getProject();
        }
        this.fPathSet.add(iPath);
        if (iProject != null) {
            this.addEnclosingProject(iProject);
        }
    }

    public void add(IPath iPath, boolean bl, IProject iProject) {
        if (bl) {
            this.fContainerSet.add(iPath);
            this.fContainerPaths = null;
        } else {
            this.fPathSet.add(iPath);
        }
        if (iProject != null) {
            this.addEnclosingProject(iProject);
        } else {
            if (this.fAllProjects == null) {
                this.fAllProjects = TypeSearchScope.getAllProjects();
            }
            int n = 0;
            while (n < this.fAllProjects.length) {
                if (TypeSearchScope.projectContainsPath(this.fAllProjects[n], iPath, false)) {
                    this.addEnclosingProject(this.fAllProjects[n]);
                    break;
                }
                ++n;
            }
        }
    }

    public void add(IProject iProject) {
        this.fProjectSet.add(iProject);
        this.fProjects = null;
        this.fAllProjects = null;
        this.addEnclosingProject(iProject);
    }

    private void addEnclosingProject(IProject iProject) {
        this.fEnclosingProjectSet.add(iProject);
    }

    public void addWorkspace() {
        this.fWorkspaceScope = true;
        this.fProjects = null;
        this.fAllProjects = null;
    }

    public void add(ICElement iCElement) {
        if (iCElement == null) {
            return;
        }
        switch (iCElement.getElementType()) {
            case 10: {
                this.addWorkspace();
                break;
            }
            case 11: {
                IProject iProject = ((ICProject)iCElement).getProject();
                this.add(iProject);
                break;
            }
            case 12: {
                IProject iProject = null;
                ICProject iCProject = iCElement.getCProject();
                if (iCProject != null) {
                    iProject = iCProject.getProject();
                }
                this.add(iCElement.getPath(), true, iProject);
                break;
            }
            case 60: {
                IProject iProject = null;
                ICProject iCProject = iCElement.getCProject();
                if (iCProject != null) {
                    iProject = iCProject.getProject();
                }
                this.add(iCElement.getPath(), false, iProject);
                break;
            }
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 72: 
            case 73: 
            case 78: {
                IProject iProject = null;
                ICProject iCProject = iCElement.getCProject();
                if (iCProject != null) {
                    iProject = iCProject.getProject();
                }
                this.add(iCElement.getPath(), false, iProject);
            }
        }
    }

    public void add(ITypeSearchScope iTypeSearchScope) {
        this.fPathSet.addAll(iTypeSearchScope.pathSet());
        this.fContainerSet.addAll(iTypeSearchScope.containerSet());
        this.fProjectSet.addAll(iTypeSearchScope.projectSet());
        this.fEnclosingProjectSet.addAll(iTypeSearchScope.enclosingProjectSet());
        this.fProjects = null;
        this.fAllProjects = null;
        this.fContainerPaths = null;
        this.fWorkspaceScope |= iTypeSearchScope.isWorkspaceScope();
    }

    public void clear() {
        this.fPathSet.clear();
        this.fContainerSet.clear();
        this.fProjectSet.clear();
        this.fEnclosingProjectSet.clear();
        this.fWorkspaceScope = false;
        this.fProjects = null;
        this.fAllProjects = null;
        this.fContainerPaths = null;
    }
}

