/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.filetype;

import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICLanguage;
import org.eclipse.core.resources.IProject;

public class ResolverDelta {
    public static final int EVENT_ADD = 16;
    public static final int EVENT_REMOVE = 32;
    public static final int EVENT_SET = 64;
    public static final int EVENT_MASK = 240;
    public static final int ELEMENT_LANGUAGE = 1;
    public static final int ELEMENT_FILETYPE = 2;
    public static final int ELEMENT_ASSOCIATION = 4;
    public static final int ELEMENT_PROJECT = 8;
    public static final int ELEMENT_WORKSPACE = 15;
    public static final int ELEMENT_MASK = 15;
    private Object fElement;
    private int fEvent;

    public ResolverDelta(int n, int n2, Object object) {
        this.fElement = object;
        this.fEvent = n | n2;
    }

    public ResolverDelta(ICLanguage iCLanguage, int n) {
        this(n, 1, iCLanguage);
    }

    public ResolverDelta(ICFileType iCFileType, int n) {
        this(n, 2, iCFileType);
    }

    public ResolverDelta(ICFileTypeAssociation iCFileTypeAssociation, int n) {
        this(n, 4, iCFileTypeAssociation);
    }

    public Object getElement() {
        return this.fElement;
    }

    public int getElementType() {
        return this.fEvent & 0xF;
    }

    public int getEventType() {
        return this.fEvent & 0xF0;
    }

    public ICLanguage getLanguage() {
        return this.fElement instanceof ICLanguage ? (ICLanguage)this.fElement : null;
    }

    public ICFileType getFileType() {
        return this.fElement instanceof ICFileType ? (ICFileType)this.fElement : null;
    }

    public ICFileTypeAssociation getAssociation() {
        return this.fElement instanceof ICFileTypeAssociation ? (ICFileTypeAssociation)this.fElement : null;
    }

    public IProject getProject() {
        return this.fElement instanceof IProject ? (IProject)this.fElement : null;
    }

    public int getEvent() {
        return this.fEvent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getEventType()) {
            case 16: {
                stringBuffer.append("add");
                break;
            }
            case 32: {
                stringBuffer.append("remove");
                break;
            }
            case 64: {
                stringBuffer.append("set");
                break;
            }
            default: {
                stringBuffer.append("?unknown event?");
            }
        }
        stringBuffer.append(" ");
        switch (this.getElementType()) {
            case 1: {
                stringBuffer.append("language ");
                stringBuffer.append(this.getLanguage() != null ? this.getLanguage().getName() : "?");
                break;
            }
            case 2: {
                stringBuffer.append("filetype ");
                stringBuffer.append(this.getFileType() != null ? this.getFileType().getName() : "?");
                break;
            }
            case 4: {
                stringBuffer.append("assoc ");
                stringBuffer.append(this.getAssociation() != null ? this.getAssociation().getPattern() : "?");
                break;
            }
            case 8: {
                stringBuffer.append("resolver for project ");
                stringBuffer.append(this.getProject() != null ? this.getProject().getName() : "?");
                break;
            }
            case 15: {
                stringBuffer.append("resolver for workspace");
                break;
            }
            default: {
                stringBuffer.append("?unknown source?");
            }
        }
        return stringBuffer.toString();
    }
}

