/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class Indexer {
    private static Indexer indexer = null;
    private static IndexManager manager = CCorePlugin.getDefault().getCoreModel().getIndexManager();

    public static boolean indexEnabledOnAllProjects() {
        IProject[] iProjectArray = CCorePlugin.getWorkspace().getRoot().getProjects();
        boolean bl = true;
        int n = 0;
        while (n < iProjectArray.length) {
            if (!Indexer.indexEnabledOnProject(iProjectArray[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static boolean indexEnabledOnAnyProjects() {
        IProject[] iProjectArray = CCorePlugin.getWorkspace().getRoot().getProjects();
        boolean bl = false;
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].isOpen() && Indexer.indexEnabledOnProject(iProjectArray[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static boolean indexEnabledOnProject(IProject iProject) {
        boolean bl = true;
        try {
            Boolean bl2 = (Boolean)iProject.getSessionProperty(IndexManager.activationKey);
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    bl = false;
                }
            } else if (!manager.isIndexEnabled(iProject)) {
                bl = false;
            }
        }
        catch (CoreException coreException) {}
        return bl;
    }
}

