/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICLanguage;
import org.eclipse.cdt.core.internal.filetype.Argument;

public class CFileType
implements ICFileType {
    private ICLanguage fLang;
    private String fId;
    private String fName;
    private int fType;

    public CFileType(String string, ICLanguage iCLanguage, String string2, int n) {
        Argument.check(string);
        Argument.check(iCLanguage);
        Argument.check(string2);
        Argument.check(n, 0, 2);
        this.fId = string;
        this.fLang = iCLanguage;
        this.fName = string2;
        this.fType = n;
    }

    public String getId() {
        return this.fId;
    }

    public ICLanguage getLanguage() {
        return this.fLang;
    }

    public String getName() {
        return this.fName;
    }

    public int getType() {
        return this.fType;
    }

    public boolean isSource() {
        return 1 == this.fType;
    }

    public boolean isHeader() {
        return 2 == this.fType;
    }

    public boolean isTranslationUnit() {
        return this.isSource() || this.isHeader();
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof ICFileType)) {
            return false;
        }
        ICFileType iCFileType = (ICFileType)object;
        boolean bl2 = bl = this.fType == iCFileType.getType();
        if (bl) {
            bl = this.fId.equals(iCFileType.getId());
        }
        if (bl) {
            bl = this.fLang.equals(iCFileType.getLanguage());
        }
        if (bl) {
            bl = this.fName.equals(iCFileType.getName());
        }
        return bl;
    }
}

