/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.internal.filetype.Argument;
import org.eclipse.cdt.internal.core.index.StringMatcher;

public class CFileTypeAssociation
implements ICFileTypeAssociation {
    private String fPattern;
    private ICFileType fType;
    private StringMatcher fMatcher;

    public CFileTypeAssociation(String string, ICFileType iCFileType) {
        Argument.check(string);
        Argument.check(iCFileType);
        this.fPattern = string;
        this.fType = iCFileType;
        this.fMatcher = new StringMatcher(string, false, false);
    }

    public String getPattern() {
        return this.fPattern;
    }

    public ICFileType getType() {
        return this.fType;
    }

    public boolean matches(String string) {
        if (string == null) {
            return this.fPattern == null;
        }
        return this.fMatcher.match(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ICFileTypeAssociation)) {
            return false;
        }
        ICFileTypeAssociation iCFileTypeAssociation = (ICFileTypeAssociation)object;
        boolean bl = this.fPattern.equals(iCFileTypeAssociation.getPattern());
        if (bl) {
            bl = this.fType.equals(iCFileTypeAssociation.getType());
        }
        return bl;
    }
}

