/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.internal.filetype.ResolverModel;

public class CFileTypeResolver
implements ICFileTypeResolver {
    protected List fAssocList = new ArrayList();

    public ICFileTypeAssociation[] getFileTypeAssociations() {
        return this.fAssocList.toArray(new ICFileTypeAssociation[this.fAssocList.size()]);
    }

    public ICFileType getFileType(String string) {
        Iterator iterator = this.fAssocList.iterator();
        while (iterator.hasNext()) {
            ICFileTypeAssociation iCFileTypeAssociation = (ICFileTypeAssociation)iterator.next();
            if (!iCFileTypeAssociation.matches(string)) continue;
            return iCFileTypeAssociation.getType();
        }
        return ResolverModel.DEFAULT_FILE_TYPE;
    }

    public boolean addAssociation(ICFileTypeAssociation iCFileTypeAssociation) {
        return this.addAssociations(new ICFileTypeAssociation[]{iCFileTypeAssociation});
    }

    public boolean addAssociations(ICFileTypeAssociation[] iCFileTypeAssociationArray) {
        return this.doAddAssociations(iCFileTypeAssociationArray);
    }

    public boolean removeAssociation(ICFileTypeAssociation iCFileTypeAssociation) {
        return this.removeAssociations(new ICFileTypeAssociation[]{iCFileTypeAssociation});
    }

    public boolean removeAssociations(ICFileTypeAssociation[] iCFileTypeAssociationArray) {
        return this.doRemoveAssociations(iCFileTypeAssociationArray);
    }

    public boolean adjustAssociations(ICFileTypeAssociation[] iCFileTypeAssociationArray, ICFileTypeAssociation[] iCFileTypeAssociationArray2) {
        boolean bl = this.doAddAssociations(iCFileTypeAssociationArray);
        boolean bl2 = this.doRemoveAssociations(iCFileTypeAssociationArray2);
        return bl || bl2;
    }

    public ICFileTypeResolver createWorkingCopy() {
        CFileTypeResolver cFileTypeResolver = new CFileTypeResolver();
        cFileTypeResolver.fAssocList.addAll(this.fAssocList);
        return cFileTypeResolver;
    }

    protected boolean doAddAssociations(ICFileTypeAssociation[] iCFileTypeAssociationArray) {
        boolean bl = false;
        if (iCFileTypeAssociationArray != null) {
            int n = 0;
            while (n < iCFileTypeAssociationArray.length) {
                if (!this.fAssocList.contains(iCFileTypeAssociationArray[n]) && this.fAssocList.add(iCFileTypeAssociationArray[n])) {
                    bl = true;
                }
                ++n;
            }
        }
        if (bl) {
            Collections.sort(this.fAssocList, ICFileTypeAssociation.Comparator);
        }
        return bl;
    }

    public boolean doRemoveAssociations(ICFileTypeAssociation[] iCFileTypeAssociationArray) {
        boolean bl = false;
        if (iCFileTypeAssociationArray != null) {
            int n = 0;
            while (n < iCFileTypeAssociationArray.length) {
                if (this.fAssocList.remove(iCFileTypeAssociationArray[n])) {
                    bl = true;
                }
                ++n;
            }
        }
        if (bl) {
            Collections.sort(this.fAssocList, ICFileTypeAssociation.Comparator);
        }
        return bl;
    }

    private static boolean isDebugging() {
        return ResolverModel.VERBOSE;
    }

    private static void debugLog(String string) {
        System.out.println("CDT Resolver: " + string);
    }
}

