/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.ICLanguage;
import org.eclipse.cdt.core.filetype.IResolverChangeListener;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.core.filetype.ResolverChangeEvent;
import org.eclipse.cdt.core.filetype.ResolverDelta;
import org.eclipse.cdt.core.internal.filetype.CFileType;
import org.eclipse.cdt.core.internal.filetype.CFileTypeAssociation;
import org.eclipse.cdt.core.internal.filetype.CFileTypeResolver;
import org.eclipse.cdt.core.internal.filetype.CLanguage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResolverModel
implements IResolverModel {
    public static final String NAME_UNKNOWN = "Unknown";
    public static final ICLanguage DEFAULT_LANG_TYPE = new CLanguage("org.eclipse.cdt.core.language.unknown", "Unknown");
    public static final ICFileType DEFAULT_FILE_TYPE = new CFileType("org.eclipse.cdt.core.fileType.unknown", DEFAULT_LANG_TYPE, "Unknown", 0);
    private Map fLangMap = new HashMap();
    private Map fTypeMap = new HashMap();
    private ICFileTypeResolver fDefaultResolver = null;
    private ICFileTypeResolver fWkspResolver = null;
    private static final String EXTENSION_LANG = "CLanguage";
    private static final String EXTENSION_TYPE = "CFileType";
    private static final String EXTENSION_ASSOC = "CFileTypeAssociation";
    private static final String TAG_CUSTOM = "custom";
    private static final String TAG_ASSOC = "associations";
    private static final String TAG_ENTRY = "entry";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_FILE = "file";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VAL_SOURCE = "source";
    private static final String ATTR_VAL_HEADER = "header";
    private static final String ATTR_VALUE = "value";
    private static final String WKSP_STATE_FILE = "resolver.properties";
    private static final String CDT_RESOLVER = "cdt_resolver";
    public static boolean VERBOSE = false;
    private static ResolverModel fInstance = null;
    private static final String RESOLVER_MODEL_ID = "org.eclipse.cdt.core.resolver";
    private static final QualifiedName QN_CUSTOM_RESOLVER = new QualifiedName("org.eclipse.cdt.core.resolver", "custom");
    private List fListeners = Collections.synchronizedList(new Vector());

    private ResolverModel() {
        try {
            this.loadDeclaredLanguages();
            this.loadDeclaredTypes();
            this.fDefaultResolver = this.loadDefaultResolver();
            this.fWkspResolver = this.loadWorkspaceResolver();
            this.initRegistryChangeListener();
        }
        catch (Exception exception) {
            CCorePlugin.log(exception);
        }
    }

    public static synchronized ResolverModel getDefault() {
        if (fInstance == null) {
            fInstance = new ResolverModel();
        }
        return fInstance;
    }

    public ICLanguage[] getLanguages() {
        Collection collection = this.fLangMap.values();
        return collection.toArray(new ICLanguage[collection.size()]);
    }

    public ICFileType[] getFileTypes() {
        Collection collection = this.fTypeMap.values();
        return collection.toArray(new ICFileType[collection.size()]);
    }

    public ICLanguage getLanguageById(String string) {
        ICLanguage iCLanguage = (ICLanguage)this.fLangMap.get(string);
        return iCLanguage != null ? iCLanguage : DEFAULT_LANG_TYPE;
    }

    public ICFileType getFileTypeById(String string) {
        ICFileType iCFileType = (ICFileType)this.fTypeMap.get(string);
        return iCFileType != null ? iCFileType : DEFAULT_FILE_TYPE;
    }

    public void setResolver(ICFileTypeResolver iCFileTypeResolver) {
        ICFileTypeResolver iCFileTypeResolver2 = this.getResolver();
        this.fWkspResolver = iCFileTypeResolver;
        this.saveWorkspaceResolver(iCFileTypeResolver);
        this.fireResolverChangeEvent(null, iCFileTypeResolver2);
    }

    public ICFileTypeResolver getResolver() {
        return this.fWkspResolver != null ? this.fWkspResolver : this.fDefaultResolver;
    }

    public void setResolver(IProject iProject, ICFileTypeResolver iCFileTypeResolver) {
        ICFileTypeResolver iCFileTypeResolver2 = this.getResolver(iProject);
        try {
            iProject.setSessionProperty(QN_CUSTOM_RESOLVER, (Object)iCFileTypeResolver);
        }
        catch (CoreException coreException) {}
        this.saveProjectResolver(iProject, iCFileTypeResolver);
        this.fireResolverChangeEvent(iProject, iCFileTypeResolver2);
    }

    public ICFileTypeResolver getResolver(IProject iProject) {
        ICFileTypeResolver iCFileTypeResolver = null;
        if (iProject != null) {
            try {
                Object object = iProject.getSessionProperty(QN_CUSTOM_RESOLVER);
                if (object instanceof ICFileTypeResolver) {
                    iCFileTypeResolver = (ICFileTypeResolver)object;
                }
            }
            catch (CoreException coreException) {}
            if (iCFileTypeResolver == null && this.customProjectResolverExists(iProject)) {
                iCFileTypeResolver = this.loadProjectResolver(iProject);
            }
        }
        if (iCFileTypeResolver == null) {
            iCFileTypeResolver = this.getResolver();
        }
        return iCFileTypeResolver;
    }

    public ICFileTypeAssociation createAssocation(String string, ICFileType iCFileType) {
        return new CFileTypeAssociation(string, iCFileType);
    }

    public boolean addLanguage(ICLanguage iCLanguage) {
        ResolverChangeEvent resolverChangeEvent = new ResolverChangeEvent(null);
        boolean bl = this.addLanguage(iCLanguage, resolverChangeEvent);
        if (bl) {
            this.fireEvent(resolverChangeEvent);
        }
        return bl;
    }

    public boolean addFileType(ICFileType iCFileType) {
        ResolverChangeEvent resolverChangeEvent = new ResolverChangeEvent(null);
        boolean bl = this.addFileType(iCFileType, resolverChangeEvent);
        if (bl) {
            this.fireEvent(resolverChangeEvent);
        }
        return bl;
    }

    public boolean removeLanguage(ICLanguage iCLanguage) {
        ResolverChangeEvent resolverChangeEvent = new ResolverChangeEvent(null);
        boolean bl = this.removeLanguage(iCLanguage, resolverChangeEvent);
        if (bl) {
            this.fireEvent(resolverChangeEvent);
        }
        return bl;
    }

    public boolean removeFileType(ICFileType iCFileType) {
        ResolverChangeEvent resolverChangeEvent = new ResolverChangeEvent(null);
        boolean bl = this.removeFileType(iCFileType, resolverChangeEvent);
        if (bl) {
            this.fireEvent(resolverChangeEvent);
        }
        return bl;
    }

    public void addResolverChangeListener(IResolverChangeListener iResolverChangeListener) {
        this.fListeners.add(iResolverChangeListener);
    }

    public void removeResolverChangeListener(IResolverChangeListener iResolverChangeListener) {
        this.fListeners.remove(iResolverChangeListener);
    }

    private IExtensionPoint getExtensionPoint(String string) {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", string);
    }

    private static boolean isDebugging() {
        return VERBOSE;
    }

    private static void debugLog(String string) {
        System.out.println("CDT Resolver: " + string);
    }

    private boolean addLanguage(ICLanguage iCLanguage, ResolverChangeEvent resolverChangeEvent) {
        boolean bl = false;
        if (!this.fLangMap.containsValue(iCLanguage)) {
            this.fLangMap.put(iCLanguage.getId(), iCLanguage);
            if (resolverChangeEvent != null) {
                resolverChangeEvent.addDelta(new ResolverDelta(iCLanguage, 16));
            }
            bl = true;
        }
        return bl;
    }

    private boolean addFileType(ICFileType iCFileType, ResolverChangeEvent resolverChangeEvent) {
        boolean bl = false;
        if (!this.fTypeMap.containsValue(iCFileType)) {
            this.fTypeMap.put(iCFileType.getId(), iCFileType);
            if (resolverChangeEvent != null) {
                resolverChangeEvent.addDelta(new ResolverDelta(iCFileType, 16));
            }
            bl = true;
        }
        return bl;
    }

    private boolean removeLanguage(ICLanguage iCLanguage, ResolverChangeEvent resolverChangeEvent) {
        boolean bl;
        boolean bl2 = bl = this.fLangMap.remove(iCLanguage.getId()) != null;
        if (bl) {
            if (resolverChangeEvent != null) {
                resolverChangeEvent.addDelta(new ResolverDelta(iCLanguage, 32));
            }
            ArrayList<ICFileType> arrayList = new ArrayList<ICFileType>();
            Iterator<Object> iterator = this.fTypeMap.values().iterator();
            while (iterator.hasNext()) {
                ICFileType iCFileType = (ICFileType)iterator.next();
                if (!iCLanguage.equals(iCFileType.getLanguage())) continue;
                arrayList.add(iCFileType);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.removeFileType((ICFileType)iterator.next(), resolverChangeEvent);
            }
        }
        return bl;
    }

    private boolean removeFileType(ICFileType iCFileType, ResolverChangeEvent resolverChangeEvent) {
        boolean bl;
        boolean bl2 = bl = this.fTypeMap.remove(iCFileType.getId()) != null;
        if (bl && resolverChangeEvent != null) {
            resolverChangeEvent.addDelta(new ResolverDelta(iCFileType, 32));
        }
        return bl;
    }

    private void fireEvent(final ResolverChangeEvent resolverChangeEvent) {
        IResolverChangeListener[] iResolverChangeListenerArray;
        List list = this.fListeners;
        synchronized (list) {
            if (ResolverModel.isDebugging()) {
                ResolverModel.debugLog(resolverChangeEvent.toString());
            }
            if (this.fListeners.isEmpty()) {
                return;
            }
            iResolverChangeListenerArray = this.fListeners.toArray(new IResolverChangeListener[this.fListeners.size()]);
        }
        int n = 0;
        while (n < iResolverChangeListenerArray.length) {
            final int n2 = n++;
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("ResolverModel.exception.listenerError"), throwable);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    iResolverChangeListenerArray[n2].resolverChanged(resolverChangeEvent);
                }
            });
        }
    }

    private void fireResolverChangeEvent(IProject iProject, ICFileTypeResolver iCFileTypeResolver) {
        ICFileTypeResolver iCFileTypeResolver2 = this.getResolver(iProject);
        ResolverChangeEvent resolverChangeEvent = new ResolverChangeEvent(iCFileTypeResolver2);
        int n = 15;
        if (iProject != null) {
            n = 8;
        }
        resolverChangeEvent.addDelta(new ResolverDelta(64, n, iProject));
        if (iCFileTypeResolver != null && iCFileTypeResolver2 != null) {
            ICFileTypeAssociation[] iCFileTypeAssociationArray = iCFileTypeResolver.getFileTypeAssociations();
            ICFileTypeAssociation[] iCFileTypeAssociationArray2 = iCFileTypeResolver2.getFileTypeAssociations();
            int n2 = 0;
            while (n2 < iCFileTypeAssociationArray.length) {
                if (Arrays.binarySearch(iCFileTypeAssociationArray2, iCFileTypeAssociationArray[n2], ICFileTypeAssociation.Comparator) < 0) {
                    resolverChangeEvent.addDelta(new ResolverDelta(iCFileTypeAssociationArray[n2], 32));
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < iCFileTypeAssociationArray2.length) {
                if (Arrays.binarySearch(iCFileTypeAssociationArray, iCFileTypeAssociationArray2[n2], ICFileTypeAssociation.Comparator) < 0) {
                    resolverChangeEvent.addDelta(new ResolverDelta(iCFileTypeAssociationArray2[n2], 16));
                }
                ++n2;
            }
        }
        this.fireEvent(resolverChangeEvent);
    }

    private void initRegistryChangeListener() {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
                ResolverModel.this.handleRegistryChanged(iRegistryChangeEvent);
            }
        }, "org.eclipse.cdt.core");
    }

    private void handleRegistryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = null;
        ResolverChangeEvent resolverChangeEvent = new ResolverChangeEvent(null);
        iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_LANG);
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            this.processLanguageExtension(resolverChangeEvent, iExtensionDeltaArray[n].getExtension(), 1 == iExtensionDeltaArray[n].getKind());
            ++n;
        }
        iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_TYPE);
        n = 0;
        while (n < iExtensionDeltaArray.length) {
            this.processTypeExtension(resolverChangeEvent, iExtensionDeltaArray[n].getExtension(), 1 == iExtensionDeltaArray[n].getKind());
            ++n;
        }
        iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_ASSOC);
        if (iExtensionDeltaArray.length != 0) {
            this.fDefaultResolver = this.loadDefaultResolver();
            this.fWkspResolver = this.loadWorkspaceResolver();
        }
        this.fireEvent(resolverChangeEvent);
    }

    private void loadDeclaredLanguages() {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(EXTENSION_LANG);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        ResolverChangeEvent resolverChangeEvent = new ResolverChangeEvent(null);
        int n = 0;
        while (n < iExtensionArray.length) {
            this.processLanguageExtension(resolverChangeEvent, iExtensionArray[n], true);
            ++n;
        }
        this.fireEvent(resolverChangeEvent);
    }

    private void loadDeclaredTypes() {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(EXTENSION_TYPE);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        ResolverChangeEvent resolverChangeEvent = new ResolverChangeEvent(null);
        int n = 0;
        while (n < iExtensionArray.length) {
            this.processTypeExtension(resolverChangeEvent, iExtensionArray[n], true);
            ++n;
        }
        this.fireEvent(resolverChangeEvent);
    }

    private void processLanguageExtension(ResolverChangeEvent resolverChangeEvent, IExtension iExtension, boolean bl) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute(ATTR_ID);
            String string2 = iConfigurationElementArray[n].getAttribute(ATTR_NAME);
            try {
                CLanguage cLanguage = new CLanguage(string, string2);
                if (bl) {
                    this.addLanguage(cLanguage, resolverChangeEvent);
                } else {
                    this.removeLanguage(cLanguage, resolverChangeEvent);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                CCorePlugin.log(illegalArgumentException);
            }
            ++n;
        }
    }

    private void processTypeExtension(ResolverChangeEvent resolverChangeEvent, IExtension iExtension, boolean bl) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute(ATTR_ID);
            String string2 = iConfigurationElementArray[n].getAttribute(ATTR_LANGUAGE);
            String string3 = iConfigurationElementArray[n].getAttribute(ATTR_NAME);
            String string4 = iConfigurationElementArray[n].getAttribute(ATTR_TYPE);
            try {
                CFileType cFileType = new CFileType(string, this.getLanguageById(string2), string3, this.parseType(string4));
                if (bl) {
                    this.addFileType(cFileType, resolverChangeEvent);
                } else {
                    this.removeFileType(cFileType, resolverChangeEvent);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                CCorePlugin.log(illegalArgumentException);
            }
            ++n;
        }
    }

    private int parseType(String string) {
        int n = 0;
        if (string.equals(ATTR_VAL_SOURCE)) {
            n = 1;
        } else if (string.equals(ATTR_VAL_HEADER)) {
            n = 2;
        }
        return n;
    }

    private ICFileTypeResolver loadDefaultResolver() {
        ArrayList arrayList = new ArrayList();
        CFileTypeResolver cFileTypeResolver = new CFileTypeResolver();
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(EXTENSION_ASSOC);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        IConfigurationElement[] iConfigurationElementArray = null;
        int n = 0;
        while (n < iExtensionArray.length) {
            iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                ICFileType iCFileType = this.getFileTypeById(iConfigurationElementArray[n2].getAttribute(ATTR_TYPE));
                if (iCFileType != null) {
                    arrayList.addAll(this.getAssocFromPattern(iCFileType, iConfigurationElementArray[n2]));
                    arrayList.addAll(this.getAssocFromFile(iCFileType, iConfigurationElementArray[n2]));
                }
                ++n2;
            }
            ++n;
        }
        cFileTypeResolver.addAssociations(arrayList.toArray(new ICFileTypeAssociation[arrayList.size()]));
        return cFileTypeResolver;
    }

    private List getAssocFromPattern(ICFileType iCFileType, IConfigurationElement iConfigurationElement) {
        ArrayList<ICFileTypeAssociation> arrayList = new ArrayList<ICFileTypeAssociation>();
        String string = iConfigurationElement.getAttribute(ATTR_PATTERN);
        if (string != null) {
            String[] stringArray = string.split(",");
            int n = 0;
            while (n < stringArray.length) {
                try {
                    arrayList.add(this.createAssocation(stringArray[n].trim(), iCFileType));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    CCorePlugin.log(illegalArgumentException);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private List getAssocFromFile(ICFileType iCFileType, IConfigurationElement iConfigurationElement) {
        ArrayList<ICFileTypeAssociation> arrayList = new ArrayList<ICFileTypeAssociation>();
        String string = iConfigurationElement.getAttribute(ATTR_FILE);
        if (string != null) {
            URL uRL = null;
            URL uRL2 = null;
            BufferedReader bufferedReader = null;
            String string2 = null;
            try {
                uRL = Platform.getBundle((String)iConfigurationElement.getDeclaringExtension().getNamespace()).getEntry("/");
                uRL2 = new URL(uRL, string);
                bufferedReader = new BufferedReader(new InputStreamReader(uRL2.openStream()));
                string2 = bufferedReader.readLine();
                while (string2 != null) {
                    try {
                        arrayList.add(this.createAssocation(string2.trim(), iCFileType));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        CCorePlugin.log(illegalArgumentException);
                    }
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                CCorePlugin.log(iOException);
            }
        }
        return arrayList;
    }

    private boolean customWorkspaceResolverExists() {
        return this.getWorkspaceResolverStateFilePath().toFile().exists();
    }

    private IPath getWorkspaceResolverStateFilePath() {
        return CCorePlugin.getDefault().getStateLocation().append(WKSP_STATE_FILE);
    }

    private ICFileTypeResolver loadWorkspaceResolver() {
        ArrayList<ICFileTypeAssociation> arrayList = new ArrayList<ICFileTypeAssociation>();
        CFileTypeResolver cFileTypeResolver = null;
        File file = this.getWorkspaceResolverStateFilePath().toFile();
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            cFileTypeResolver = new CFileTypeResolver();
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    ICFileType iCFileType = this.getFileTypeById(entry.getValue().toString());
                    try {
                        arrayList.add(this.createAssocation(entry.getKey().toString(), iCFileType));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        CCorePlugin.log(illegalArgumentException);
                    }
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                CCorePlugin.log(iOException);
            }
            if (fileInputStream != null) {
                fileInputStream = null;
            }
            cFileTypeResolver.addAssociations(arrayList.toArray(new ICFileTypeAssociation[arrayList.size()]));
        }
        return cFileTypeResolver;
    }

    private void saveWorkspaceResolver(ICFileTypeResolver iCFileTypeResolver) {
        File file = this.getWorkspaceResolverStateFilePath().toFile();
        BufferedWriter bufferedWriter = null;
        try {
            if (iCFileTypeResolver == null) {
                file.delete();
            } else {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                ICFileTypeAssociation[] iCFileTypeAssociationArray = iCFileTypeResolver.getFileTypeAssociations();
                int n = 0;
                while (n < iCFileTypeAssociationArray.length) {
                    bufferedWriter.write(String.valueOf(iCFileTypeAssociationArray[n].getPattern()) + '=' + iCFileTypeAssociationArray[n].getType().getId() + "\n");
                    ++n;
                }
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bufferedWriter != null) {
            bufferedWriter = null;
        }
    }

    private boolean customProjectResolverExists(IProject iProject) {
        Element element = this.getProjectData(iProject, false);
        Node node = element != null ? element.getFirstChild() : null;
        Boolean bl = new Boolean(false);
        while (node != null) {
            if (node.getNodeName().equals(TAG_CUSTOM)) {
                bl = Boolean.valueOf(((Element)node).getAttribute(ATTR_VALUE));
            }
            node = node.getNextSibling();
        }
        return bl;
    }

    private ICDescriptor getProjectDescriptor(IProject iProject, boolean bl) throws CoreException {
        ICDescriptor iCDescriptor = null;
        iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, bl);
        return iCDescriptor;
    }

    private Element getProjectData(IProject iProject, boolean bl) {
        Element element = null;
        try {
            ICDescriptor iCDescriptor = this.getProjectDescriptor(iProject, bl);
            if (iCDescriptor != null) {
                element = iCDescriptor.getProjectData(CDT_RESOLVER);
            }
        }
        catch (CoreException coreException) {}
        return element;
    }

    private ICFileTypeResolver loadProjectResolver(IProject iProject) {
        ArrayList<ICFileTypeAssociation> arrayList = new ArrayList<ICFileTypeAssociation>();
        CFileTypeResolver cFileTypeResolver = new CFileTypeResolver();
        Element element = this.getProjectData(iProject, false);
        Node node = element != null ? element.getFirstChild() : null;
        while (node != null) {
            if (node.getNodeName().equals(TAG_ASSOC)) {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    if (node2.getNodeName().equals(TAG_ENTRY)) {
                        Element element2 = (Element)node2;
                        String string = element2.getAttribute(ATTR_PATTERN);
                        String string2 = element2.getAttribute(ATTR_TYPE);
                        try {
                            arrayList.add(this.createAssocation(string, this.getFileTypeById(string2)));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            CCorePlugin.log(illegalArgumentException);
                        }
                    }
                    node2 = node2.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        cFileTypeResolver.addAssociations(arrayList.toArray(new ICFileTypeAssociation[arrayList.size()]));
        return cFileTypeResolver;
    }

    private void saveProjectResolver(IProject iProject, ICFileTypeResolver iCFileTypeResolver) {
        Element element = this.getProjectData(iProject, true);
        Document document = element.getOwnerDocument();
        Node node = element.getFirstChild();
        Element element2 = null;
        while (node != null) {
            element.removeChild(node);
            node = element.getFirstChild();
        }
        element2 = document.createElement(TAG_CUSTOM);
        element2.setAttribute(ATTR_VALUE, new Boolean(iCFileTypeResolver != null).toString());
        element.appendChild(element2);
        if (iCFileTypeResolver != null) {
            element2 = document.createElement(TAG_ASSOC);
            element.appendChild(element2);
            element = element2;
            ICFileTypeAssociation[] iCFileTypeAssociationArray = iCFileTypeResolver.getFileTypeAssociations();
            int n = 0;
            while (n < iCFileTypeAssociationArray.length) {
                element2 = document.createElement(TAG_ENTRY);
                element2.setAttribute(ATTR_PATTERN, iCFileTypeAssociationArray[n].getPattern());
                element2.setAttribute(ATTR_TYPE, iCFileTypeAssociationArray[n].getType().getId());
                element.appendChild(element2);
                ++n;
            }
        }
        try {
            this.getProjectDescriptor(iProject, true).saveProjectData();
        }
        catch (CoreException coreException) {
            CCorePlugin.log(coreException);
        }
    }
}

