/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.PathEntryContainerInitializer;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.internal.core.model.BatchOperation;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.ContainerEntry;
import org.eclipse.cdt.internal.core.model.IncludeEntry;
import org.eclipse.cdt.internal.core.model.LibraryEntry;
import org.eclipse.cdt.internal.core.model.MacroEntry;
import org.eclipse.cdt.internal.core.model.OutputEntry;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.model.ProjectEntry;
import org.eclipse.cdt.internal.core.model.SourceEntry;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CoreModel {
    private static CoreModel cmodel = null;
    private static CModelManager manager = CModelManager.getDefault();
    private static PathEntryManager pathEntryManager = PathEntryManager.getDefault();
    public static final String CORE_MODEL_ID = "org.eclipse.cdt.core.coremodel";

    public ICElement create(IPath iPath) {
        return manager.create(iPath);
    }

    public ITranslationUnit createTranslationUnitFrom(ICProject iCProject, IPath iPath) {
        return manager.createTranslationUnitFrom(iCProject, iPath);
    }

    public ICElement create(IFile iFile) {
        return manager.create(iFile, null);
    }

    public ICContainer create(IFolder iFolder) {
        return manager.create(iFolder, null);
    }

    public ICProject create(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        CModel cModel = manager.getCModel();
        return cModel.getCProject((IResource)iProject);
    }

    public ICElement create(IResource iResource) {
        return manager.create(iResource, null);
    }

    public static ICModel create(IWorkspaceRoot iWorkspaceRoot) {
        if (iWorkspaceRoot == null) {
            return null;
        }
        return manager.getCModel();
    }

    public ICModel getCModel() {
        return manager.getCModel();
    }

    public boolean isSharedLib(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        if (iCElement instanceof IBinary) {
            return ((IBinary)iCElement).isSharedLib();
        }
        return false;
    }

    public boolean isObject(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        if (iCElement instanceof IBinary) {
            return ((IBinary)iCElement).isObject();
        }
        return false;
    }

    public boolean isExecutable(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        if (iCElement instanceof IBinary) {
            return ((IBinary)iCElement).isExecutable();
        }
        return false;
    }

    public boolean isBinary(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        return iCElement instanceof IBinary;
    }

    public boolean isArchive(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        return iCElement instanceof IArchive;
    }

    public static boolean isTranslationUnit(IFile iFile) {
        IProject iProject;
        if (iFile != null && (CoreModel.hasCNature(iProject = iFile.getProject()) || CoreModel.hasCCNature(iProject))) {
            ICFileType iCFileType = CCorePlugin.getDefault().getFileType(iFile.getProject(), iFile.getName());
            return iCFileType.isTranslationUnit();
        }
        return false;
    }

    public static boolean isValidTranslationUnitName(IProject iProject, String string) {
        ICFileType iCFileType = CCorePlugin.getDefault().getFileType(iProject, string);
        return iCFileType.isTranslationUnit();
    }

    public static boolean isValidHeaderUnitName(IProject iProject, String string) {
        ICFileType iCFileType = CCorePlugin.getDefault().getFileType(iProject, string);
        return iCFileType.isHeader();
    }

    public static boolean isValidSourceUnitName(IProject iProject, String string) {
        ICFileType iCFileType = CCorePlugin.getDefault().getFileType(iProject, string);
        return iCFileType.isSource();
    }

    public static boolean hasCNature(IProject iProject) {
        boolean bl = false;
        try {
            bl = iProject.isOpen() && iProject.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {}
        return bl;
    }

    public static boolean hasCCNature(IProject iProject) {
        boolean bl = false;
        try {
            bl = iProject.isOpen() && iProject.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {}
        return bl;
    }

    public static IProjectEntry newProjectEntry(IPath iPath) {
        return CoreModel.newProjectEntry(iPath, false);
    }

    public static IProjectEntry newProjectEntry(IPath iPath, boolean bl) {
        return new ProjectEntry(iPath, bl);
    }

    public static IContainerEntry newContainerEntry(IPath iPath) {
        return CoreModel.newContainerEntry(iPath, false);
    }

    public static IContainerEntry newContainerEntry(IPath iPath, boolean bl) {
        return new ContainerEntry(iPath, bl);
    }

    public static ILibraryEntry newLibraryRefEntry(IPath iPath, IPath iPath2, IPath iPath3) {
        return new LibraryEntry(iPath, null, iPath2, iPath3, null, null, null, false);
    }

    public static ILibraryEntry newLibraryEntry(IPath iPath, IPath iPath2, IPath iPath3, IPath iPath4, IPath iPath5, IPath iPath6, boolean bl) {
        return new LibraryEntry(iPath, iPath2, null, iPath3, iPath4, iPath5, iPath6, bl);
    }

    public static IOutputEntry newOutputEntry(IPath iPath) {
        return CoreModel.newOutputEntry(iPath, OutputEntry.NO_EXCLUSION_PATTERNS);
    }

    public static IOutputEntry newOutputEntry(IPath iPath, IPath[] iPathArray) {
        return new OutputEntry(iPath, iPathArray, false);
    }

    public static ISourceEntry newSourceEntry(IPath iPath) {
        return CoreModel.newSourceEntry(iPath, SourceEntry.NO_EXCLUSION_PATTERNS);
    }

    public static ISourceEntry newSourceEntry(IPath iPath, IPath[] iPathArray) {
        return new SourceEntry(iPath, iPathArray);
    }

    public static IIncludeEntry newIncludeEntry(IPath iPath, IPath iPath2, IPath iPath3) {
        return CoreModel.newIncludeEntry(iPath, iPath2, iPath3, false);
    }

    public static IIncludeEntry newIncludeEntry(IPath iPath, IPath iPath2, IPath iPath3, boolean bl) {
        return CoreModel.newIncludeEntry(iPath, iPath2, iPath3, bl, IncludeEntry.NO_EXCLUSION_PATTERNS);
    }

    public static IIncludeEntry newIncludeEntry(IPath iPath, IPath iPath2, IPath iPath3, boolean bl, IPath[] iPathArray) {
        return CoreModel.newIncludeEntry(iPath, iPath2, iPath3, bl, iPathArray, false);
    }

    public static IIncludeEntry newIncludeEntry(IPath iPath, IPath iPath2, IPath iPath3, boolean bl, IPath[] iPathArray, boolean bl2) {
        return new IncludeEntry(iPath, iPath2, null, iPath3, bl, iPathArray, bl2);
    }

    public static IIncludeEntry newIncludeRefEntry(IPath iPath, IPath iPath2, IPath iPath3) {
        return new IncludeEntry(iPath, null, iPath2, iPath3, false, null, false);
    }

    public static IMacroEntry newMacroEntry(IPath iPath, String string, String string2) {
        return CoreModel.newMacroEntry(iPath, string, string2, MacroEntry.NO_EXCLUSION_PATTERNS);
    }

    public static IMacroEntry newMacroEntry(IPath iPath, String string, String string2, IPath[] iPathArray) {
        return CoreModel.newMacroEntry(iPath, string, string2, iPathArray, false);
    }

    public static IMacroEntry newMacroEntry(IPath iPath, String string, String string2, IPath[] iPathArray, boolean bl) {
        return new MacroEntry(iPath, null, string, string2, iPathArray, bl);
    }

    public static IMacroEntry newMacroRefEntry(IPath iPath, IPath iPath2, String string) {
        return new MacroEntry(iPath, iPath2, string, null, MacroEntry.NO_EXCLUSION_PATTERNS, false);
    }

    public static IPathEntryContainer getPathEntryContainer(IPath iPath, ICProject iCProject) throws CModelException {
        return pathEntryManager.getPathEntryContainer(iPath, iCProject);
    }

    public void setPathEntryContainer(ICProject[] iCProjectArray, IPathEntryContainer iPathEntryContainer, IProgressMonitor iProgressMonitor) throws CModelException {
        pathEntryManager.setPathEntryContainer(iCProjectArray, iPathEntryContainer, iProgressMonitor);
    }

    public static void setRawPathEntries(ICProject iCProject, IPathEntry[] iPathEntryArray, IProgressMonitor iProgressMonitor) throws CModelException {
        pathEntryManager.setRawPathEntries(iCProject, iPathEntryArray, iProgressMonitor);
    }

    public static IPathEntry[] getRawPathEntries(ICProject iCProject) throws CModelException {
        return pathEntryManager.getRawPathEntries(iCProject);
    }

    public static IPathEntry[] getResolvedPathEntries(ICProject iCProject) throws CModelException {
        return pathEntryManager.getResolvedPathEntries(iCProject);
    }

    public static PathEntryContainerInitializer getPathEntryContainerInitializer(String string) {
        return pathEntryManager.getPathEntryContainerInitializer(string);
    }

    public static IPathEntryStore getPathEntryStore(IProject iProject) throws CoreException {
        return pathEntryManager.getPathEntryStore(iProject, true);
    }

    public static void setPathEntryStore(IProject iProject, IPathEntryStore iPathEntryStore) {
        pathEntryManager.setPathEntryStore(iProject, iPathEntryStore);
    }

    public static ICModelStatus validatePathEntries(ICProject iCProject, IPathEntry[] iPathEntryArray) {
        return pathEntryManager.validatePathEntry(iCProject, iPathEntryArray);
    }

    public static ICModelStatus validatePathEntry(ICProject iCProject, IPathEntry iPathEntry, boolean bl, boolean bl2) {
        return pathEntryManager.validatePathEntry(iCProject, iPathEntry, bl, bl2);
    }

    public static CoreModel getDefault() {
        if (cmodel == null) {
            cmodel = new CoreModel();
        }
        return cmodel;
    }

    public void addElementChangedListener(IElementChangedListener iElementChangedListener) {
        manager.addElementChangedListener(iElementChangedListener);
    }

    public void removeElementChangedListener(IElementChangedListener iElementChangedListener) {
        manager.removeElementChangedListener(iElementChangedListener);
    }

    public void startup() {
        manager.startup();
    }

    public void shutdown() {
        manager.shutdown();
    }

    private CoreModel() {
    }

    public static void run(IWorkspaceRunnable iWorkspaceRunnable, IProgressMonitor iProgressMonitor) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace.isTreeLocked()) {
            new BatchOperation(iWorkspaceRunnable).run(iProgressMonitor);
        } else {
            iWorkspace.run((IWorkspaceRunnable)new BatchOperation(iWorkspaceRunnable), iProgressMonitor);
        }
    }

    public void startIndexing() {
        manager.getIndexManager().reset();
    }

    public IndexManager getIndexManager() {
        return manager.getIndexManager();
    }
}

