/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.extension.ExtensionDialect;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.core.parser.extension.IParserExtensionFactory;
import org.eclipse.cdt.internal.core.parser.CompleteParser;
import org.eclipse.cdt.internal.core.parser.CompletionParser;
import org.eclipse.cdt.internal.core.parser.ParserExtensionFactory;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;
import org.eclipse.cdt.internal.core.parser.QuickParser;
import org.eclipse.cdt.internal.core.parser.SelectionParser;
import org.eclipse.cdt.internal.core.parser.StructuralParseCallback;
import org.eclipse.cdt.internal.core.parser.StructuralParser;
import org.eclipse.cdt.internal.core.parser.ast.complete.CompleteParseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.expression.ExpressionParseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.quick.QuickParseASTFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.Scanner2;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;

public class ParserFactory {
    private static IParserExtensionFactory extensionFactory = new ParserExtensionFactory(ExtensionDialect.GCC);
    private static IParserLogService defaultLogService = new DefaultLogService();

    public static IASTFactory createASTFactory(ParserMode parserMode, ParserLanguage parserLanguage) {
        if (parserMode == ParserMode.QUICK_PARSE) {
            return new QuickParseASTFactory(extensionFactory.createASTExtension(parserMode));
        }
        if (parserMode == ParserMode.EXPRESSION_PARSE) {
            return new ExpressionParseASTFactory(extensionFactory.createASTExtension(parserMode));
        }
        return new CompleteParseASTFactory(parserLanguage, parserMode, extensionFactory.createASTExtension(parserMode));
    }

    public static IParser createParser(IScanner iScanner, ISourceElementRequestor iSourceElementRequestor, ParserMode parserMode, ParserLanguage parserLanguage, IParserLogService iParserLogService) throws ParserFactoryError {
        if (iScanner == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_SCANNER);
        }
        if (parserLanguage == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService iParserLogService2 = iParserLogService == null ? ParserFactory.createDefaultLogService() : iParserLogService;
        ParserMode parserMode2 = parserMode == null ? ParserMode.COMPLETE_PARSE : parserMode;
        ISourceElementRequestor iSourceElementRequestor2 = iSourceElementRequestor == null ? new NullSourceElementRequestor() : iSourceElementRequestor;
        IParserExtension iParserExtension = extensionFactory.createParserExtension();
        if (parserMode2 == ParserMode.COMPLETE_PARSE) {
            return new CompleteParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2, iParserExtension);
        }
        if (parserMode2 == ParserMode.STRUCTURAL_PARSE) {
            return new StructuralParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2, iParserExtension);
        }
        if (parserMode2 == ParserMode.COMPLETION_PARSE) {
            return new CompletionParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2, iParserExtension);
        }
        if (parserMode2 == ParserMode.SELECTION_PARSE) {
            return new SelectionParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2, iParserExtension);
        }
        return new QuickParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2, iParserExtension);
    }

    public static IScanner createScanner(CodeReader codeReader, IScannerInfo iScannerInfo, ParserMode parserMode, ParserLanguage parserLanguage, ISourceElementRequestor iSourceElementRequestor, IParserLogService iParserLogService, List list) throws ParserFactoryError {
        if (iScannerInfo == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_CONFIG);
        }
        if (parserLanguage == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService iParserLogService2 = iParserLogService == null ? ParserFactory.createDefaultLogService() : iParserLogService;
        ParserMode parserMode2 = parserMode == null ? ParserMode.COMPLETE_PARSE : parserMode;
        ISourceElementRequestor iSourceElementRequestor2 = iSourceElementRequestor == null ? new NullSourceElementRequestor() : iSourceElementRequestor;
        return new Scanner2(codeReader, iScannerInfo, iSourceElementRequestor2, parserMode2, parserLanguage, iParserLogService2, extensionFactory.createScannerExtension(), list);
    }

    public static IScanner createScanner(String string, IScannerInfo iScannerInfo, ParserMode parserMode, ParserLanguage parserLanguage, ISourceElementRequestor iSourceElementRequestor, IParserLogService iParserLogService, List list) throws ParserFactoryError, IOException {
        return ParserFactory.createScanner(new CodeReader(string), iScannerInfo, parserMode, parserLanguage, iSourceElementRequestor, iParserLogService, list);
    }

    public static IQuickParseCallback createQuickParseCallback() {
        return new QuickParseCallback();
    }

    public static IQuickParseCallback createStructuralParseCallback() {
        return new StructuralParseCallback();
    }

    public static IParserLogService createDefaultLogService() {
        return defaultLogService;
    }

    public static Set getKeywordSet(KeywordSetKey keywordSetKey, ParserLanguage parserLanguage) {
        return KeywordSets.getKeywords(keywordSetKey, parserLanguage);
    }
}

