/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.ParserLogService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ParserUtil {
    private static IParserLogService parserLogService = new ParserLogService(IDebugLogConstants.PARSER);
    private static IParserLogService scannerLogService = new ParserLogService(IDebugLogConstants.SCANNER);

    public static IParserLogService getParserLogService() {
        return parserLogService;
    }

    public static IParserLogService getScannerLogService() {
        return scannerLogService;
    }

    public static CodeReader createReader(String string, Iterator iterator) {
        block7: {
            try {
                CodeReader codeReader;
                block8: {
                    Object object;
                    IResource iResource = ParserUtil.getResourceForFilename(string);
                    if (iResource == null || iResource.getType() != 1) break block7;
                    if (iterator.hasNext() && (object = ParserUtil.findWorkingCopy(iResource, iterator)) != null) {
                        return new CodeReader(string, (char[])object);
                    }
                    object = null;
                    try {
                        object = ((IFile)iResource).getContents();
                        codeReader = new CodeReader(string, ((IFile)iResource).getCharset(), (InputStream)object);
                        Object var4_5 = null;
                        if (object == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                        throw throwable;
                    }
                    ((InputStream)object).close();
                }
                return codeReader;
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
        return InternalParserUtil.createFileReader(string);
    }

    public static IResource getResourceForFilename(String string) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace == null) {
            return null;
        }
        Path path = new Path(string);
        if (iWorkspace.getRoot().getLocation().isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(iWorkspace.getRoot().getLocation().segmentCount());
        }
        IResource iResource = iWorkspace.getRoot().findMember((IPath)path);
        return iResource;
    }

    protected static char[] findWorkingCopy(IResource iResource, Iterator iterator) {
        if (parserLogService.isTracing()) {
            parserLogService.traceLog("Attempting to find the working copy for " + iResource.getName());
        }
        while (iterator.hasNext()) {
            IWorkingCopy iWorkingCopy;
            Object e = iterator.next();
            if (!(e instanceof IWorkingCopy) || !(iWorkingCopy = (IWorkingCopy)e).getResource().equals((Object)iResource)) continue;
            if (parserLogService.isTracing()) {
                parserLogService.traceLog("Working copy found!!");
            }
            return iWorkingCopy.getContents();
        }
        if (parserLogService.isTracing()) {
            parserLogService.traceLog("Working copy not found.");
        }
        return null;
    }
}

