/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;

public class ASTUtil {
    public static final String EMPTY_STRING = "";
    private static final Map expressionKindStringMap = new HashMap();

    static {
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DYNAMIC_CAST, "dynamic_cast");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_STATIC_CAST, "static_cast");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_REINTERPRET_CAST, "reinterpret_cast");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_CONST_CAST, "const_cast");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_CHAR, "char");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_WCHART, "wchar_t");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_BOOL, "bool");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_SHORT, "short");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_INT, "int");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_LONG, "long");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_SIGNED, "signed");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_UNSIGNED, "unsigned");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_FLOAT, "float");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_DOUBLE, "double");
        expressionKindStringMap.put(IASTExpression.Kind.THROWEXPRESSION, "throw");
        expressionKindStringMap.put(IASTExpression.Kind.ANDEXPRESSION, "&");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_AMPSND_CASTEXPRESSION, "&");
        expressionKindStringMap.put(IASTExpression.Kind.EXPRESSIONLIST, ",");
        expressionKindStringMap.put(IASTExpression.Kind.EXCLUSIVEOREXPRESSION, "^");
        expressionKindStringMap.put(IASTExpression.Kind.PM_DOTSTAR, ".*");
        expressionKindStringMap.put(IASTExpression.Kind.PM_ARROWSTAR, "->*");
        expressionKindStringMap.put(IASTExpression.Kind.LOGICALANDEXPRESSION, "&&");
        expressionKindStringMap.put(IASTExpression.Kind.LOGICALOREXPRESSION, "||");
        expressionKindStringMap.put(IASTExpression.Kind.RELATIONAL_GREATERTHAN, ">");
        expressionKindStringMap.put(IASTExpression.Kind.RELATIONAL_LESSTHAN, "<");
        expressionKindStringMap.put(IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO, "<=");
        expressionKindStringMap.put(IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO, ">=");
        expressionKindStringMap.put(IASTExpression.Kind.EQUALITY_EQUALS, "==");
        expressionKindStringMap.put(IASTExpression.Kind.EQUALITY_NOTEQUALS, "!=");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_STAR_CASTEXPRESSION, "*");
        expressionKindStringMap.put(IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY, "*");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_PLUS_CASTEXPRESSION, "+");
        expressionKindStringMap.put(IASTExpression.Kind.ADDITIVE_PLUS, "+");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_MINUS_CASTEXPRESSION, "-");
        expressionKindStringMap.put(IASTExpression.Kind.ADDITIVE_MINUS, "-");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION, "!");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_TILDE_CASTEXPRESSION, "~");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_DECREMENT, "--");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DECREMENT, "--");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_INCREMENT, "++");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_INCREMENT, "++");
        expressionKindStringMap.put(IASTExpression.Kind.INCLUSIVEOREXPRESSION, "|");
        expressionKindStringMap.put(IASTExpression.Kind.MULTIPLICATIVE_DIVIDE, "/");
        expressionKindStringMap.put(IASTExpression.Kind.MULTIPLICATIVE_MODULUS, "%");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS, ".");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION, ".");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR, ".");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP, "->");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR, "->");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION, "->");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_NORMAL, "=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_MULT, "*=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_DIV, "/=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_MOD, "%=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_PLUS, "+=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_MINUS, "-=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_RSHIFT, ">>=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_LSHIFT, "<<=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_AND, "&=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_XOR, "^=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_OR, "|=");
        expressionKindStringMap.put(IASTExpression.Kind.SHIFT_LEFT, "<<");
        expressionKindStringMap.put(IASTExpression.Kind.SHIFT_RIGHT, ">>");
    }

    public static String[] getTemplateParameters(IASTTemplateDeclaration iASTTemplateDeclaration) {
        Iterator iterator = iASTTemplateDeclaration.getTemplateParameters();
        return ASTUtil.getTemplateParameters(iterator);
    }

    public static String[] getTemplateParameters(Iterator iterator) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = new StringBuffer();
            IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator.next();
            IASTTemplateParameter.ParamKind paramKind = iASTTemplateParameter.getTemplateParameterKind();
            if (paramKind == IASTTemplateParameter.ParamKind.CLASS) {
                if (iASTTemplateParameter.getIdentifier() != null && iASTTemplateParameter.getIdentifier().length() != 0) {
                    stringArray.append(iASTTemplateParameter.getIdentifier().toString());
                } else {
                    stringArray.append("class");
                }
            }
            if (paramKind == IASTTemplateParameter.ParamKind.TYPENAME) {
                if (iASTTemplateParameter.getIdentifier() != null && iASTTemplateParameter.getIdentifier().length() != 0) {
                    stringArray.append(iASTTemplateParameter.getIdentifier().toString());
                } else {
                    stringArray.append("typename");
                }
            }
            if (paramKind == IASTTemplateParameter.ParamKind.TEMPLATE_LIST) {
                stringArray.append("template<");
                String[] stringArray2 = ASTUtil.getTemplateParameters(iASTTemplateParameter.getTemplateParameters());
                int n = 0;
                if (stringArray2.length > 0) {
                    stringArray.append(stringArray2[n++]);
                }
                while (n < stringArray2.length) {
                    stringArray.append(", ");
                    stringArray.append(stringArray2[n++]);
                }
                stringArray.append(">");
            }
            if (paramKind == IASTTemplateParameter.ParamKind.PARAMETER) {
                stringArray.append(ASTUtil.getType(iASTTemplateParameter.getParameterDeclaration()));
            }
            arrayList.add(stringArray.toString());
        }
        stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        return stringArray;
    }

    public static String getType(IASTAbstractDeclaration iASTAbstractDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ASTUtil.getDeclarationType(iASTAbstractDeclaration));
        stringBuffer.append(ASTUtil.getPointerOperation(iASTAbstractDeclaration));
        stringBuffer.append(ASTUtil.getArrayQualifiers(iASTAbstractDeclaration));
        stringBuffer.append(ASTUtil.getPointerToFunctionType(iASTAbstractDeclaration));
        if (iASTAbstractDeclaration instanceof IASTParameterDeclaration) {
            stringBuffer.append(ASTUtil.getInitializerClause((IASTParameterDeclaration)iASTAbstractDeclaration));
        }
        return stringBuffer.toString();
    }

    public static String getInitializerClause(IASTParameterDeclaration iASTParameterDeclaration) {
        String string;
        IASTExpression iASTExpression;
        IASTInitializerClause iASTInitializerClause;
        StringBuffer stringBuffer = new StringBuffer();
        if (iASTParameterDeclaration != null && (iASTInitializerClause = iASTParameterDeclaration.getDefaultValue()) != null && (iASTExpression = iASTInitializerClause.getAssigmentExpression()) != null && (string = ASTUtil.getExpressionString(iASTExpression)).length() > 0) {
            stringBuffer.append("=");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String getPointerToFunctionType(IASTAbstractDeclaration iASTAbstractDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        ASTPointerOperator aSTPointerOperator = iASTAbstractDeclaration.getPointerToFunctionOperator();
        if (aSTPointerOperator != null) {
            stringBuffer.append("(");
            stringBuffer.append(ASTUtil.getPointerOperator(aSTPointerOperator));
            stringBuffer.append(")");
            String[] stringArray = ASTUtil.getParameterTypes(iASTAbstractDeclaration.getParameters(), false);
            stringBuffer.append(ASTUtil.getParametersString(stringArray));
        }
        return stringBuffer.toString();
    }

    public static String getDeclarationType(IASTAbstractDeclaration iASTAbstractDeclaration) {
        IASTTypeSpecifier iASTTypeSpecifier;
        StringBuffer stringBuffer = new StringBuffer();
        if (iASTAbstractDeclaration.isConst()) {
            stringBuffer.append("const ");
        }
        if ((iASTTypeSpecifier = iASTAbstractDeclaration.getTypeSpecifier()) instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTTypeSpecifier;
            stringBuffer.append(ASTUtil.getElaboratedTypeSignature(iASTElaboratedTypeSpecifier));
        } else if (iASTTypeSpecifier instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTTypeSpecifier;
            stringBuffer.append(iASTSimpleTypeSpecifier.getTypename());
        } else if (iASTTypeSpecifier instanceof IASTClassSpecifier) {
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTypeSpecifier;
            stringBuffer.append(iASTClassSpecifier.getName());
        } else if (iASTTypeSpecifier instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iASTTypeSpecifier;
            stringBuffer.append(iASTEnumerationSpecifier.getName());
        }
        return stringBuffer.toString();
    }

    public static String getElaboratedTypeSignature(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        StringBuffer stringBuffer = new StringBuffer();
        ASTClassKind aSTClassKind = iASTElaboratedTypeSpecifier.getClassKind();
        if (aSTClassKind == ASTClassKind.CLASS) {
            stringBuffer.append("class");
        } else if (aSTClassKind == ASTClassKind.STRUCT) {
            stringBuffer.append("struct");
        } else if (aSTClassKind == ASTClassKind.UNION) {
            stringBuffer.append("union");
        } else if (aSTClassKind == ASTClassKind.STRUCT) {
            stringBuffer.append("enum");
        }
        stringBuffer.append(" ");
        stringBuffer.append(iASTElaboratedTypeSpecifier.getName().toString());
        return stringBuffer.toString();
    }

    public static String getPointerOperation(IASTAbstractDeclaration iASTAbstractDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = iASTAbstractDeclaration.getPointerOperators();
        while (iterator.hasNext()) {
            ASTPointerOperator aSTPointerOperator = (ASTPointerOperator)iterator.next();
            stringBuffer.append(ASTUtil.getPointerOperator(aSTPointerOperator));
        }
        return stringBuffer.toString();
    }

    public static String getPointerOperator(ASTPointerOperator aSTPointerOperator) {
        String string = EMPTY_STRING;
        if (aSTPointerOperator == ASTPointerOperator.POINTER) {
            string = "*";
        }
        if (aSTPointerOperator == ASTPointerOperator.REFERENCE) {
            string = "&";
        }
        if (aSTPointerOperator == ASTPointerOperator.CONST_POINTER) {
            string = "* const";
        }
        if (aSTPointerOperator == ASTPointerOperator.VOLATILE_POINTER) {
            string = "* volatile";
        }
        if (aSTPointerOperator == ASTPointerOperator.RESTRICT_POINTER) {
            string = "* restrict";
        }
        return string;
    }

    public static String getArrayQualifiers(IASTAbstractDeclaration iASTAbstractDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = iASTAbstractDeclaration.getArrayModifiers();
        while (iterator.hasNext()) {
            iterator.next();
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public static String[] getFunctionParameterTypes(IASTFunction iASTFunction) {
        Iterator iterator = iASTFunction.getParameters();
        return ASTUtil.getParameterTypes(iterator, iASTFunction.takesVarArgs());
    }

    public static String[] getParameterTypes(Iterator iterator, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator.next();
            arrayList.add(ASTUtil.getType(iASTParameterDeclaration));
        }
        int n = arrayList.size();
        if (bl) {
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            stringArray[n2] = (String)arrayList.get(n2);
            ++n2;
        }
        if (bl) {
            stringArray[n - 1] = "...";
        }
        return stringArray;
    }

    public static String getParametersString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(EMPTY_STRING);
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("(");
            int n = 0;
            stringBuffer.append(stringArray[n++]);
            while (n < stringArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(stringArray[n++]);
            }
            stringBuffer.append(")");
        } else if (stringArray != null) {
            stringBuffer.append("()");
        }
        return stringBuffer.toString();
    }

    public static String getTypeId(IASTTypeId iASTTypeId) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iASTTypeId.isTypename()) {
            stringBuffer.append("typename");
            stringBuffer.append(' ');
        }
        stringBuffer.append(iASTTypeId.getFullSignature());
        return stringBuffer.toString();
    }

    public static String getExpressionString(IASTExpression iASTExpression) {
        if (iASTExpression.getExpressionKind().isExtensionKind()) {
            return iASTExpression.toString();
        }
        String string = iASTExpression.getLiteralString();
        String string2 = iASTExpression.getIdExpression();
        IASTExpression iASTExpression2 = iASTExpression.getLHSExpression();
        IASTExpression iASTExpression3 = iASTExpression.getRHSExpression();
        IASTExpression iASTExpression4 = iASTExpression.getThirdExpression();
        IASTExpression.IASTNewExpressionDescriptor iASTNewExpressionDescriptor = iASTExpression.getNewExpressionDescriptor();
        IASTTypeId iASTTypeId = iASTExpression.getTypeId();
        if (string != null && !string.equals(EMPTY_STRING) && (string2 == null || string2.equals(EMPTY_STRING))) {
            return ASTUtil.getLiteralExpression(iASTExpression);
        }
        if (string2 != null && !string2.equals(EMPTY_STRING) && iASTExpression2 == null) {
            return ASTUtil.getIdExpression(iASTExpression);
        }
        if (iASTExpression4 != null) {
            return ASTUtil.getConditionalExpression(iASTExpression);
        }
        if (iASTNewExpressionDescriptor != null) {
            return ASTUtil.getNewExpression(iASTExpression);
        }
        if (iASTExpression2 != null && iASTExpression3 != null) {
            return ASTUtil.getBinaryExpression(iASTExpression);
        }
        if (iASTExpression2 != null && iASTTypeId != null) {
            return ASTUtil.getUnaryTypeIdExpression(iASTExpression);
        }
        if (iASTExpression2 != null && string2 != null && !string2.equals(EMPTY_STRING)) {
            return ASTUtil.getUnaryIdExpression(iASTExpression);
        }
        if (iASTExpression2 != null) {
            return ASTUtil.getUnaryExpression(iASTExpression);
        }
        if (iASTTypeId != null) {
            return ASTUtil.getTypeIdExpression(iASTExpression);
        }
        return ASTUtil.getEmptyExpression(iASTExpression);
    }

    private static String getEmptyExpression(IASTExpression iASTExpression) {
        if (iASTExpression.getExpressionKind() == IASTExpression.Kind.PRIMARY_THIS) {
            return "this";
        }
        return EMPTY_STRING;
    }

    private static String getLiteralExpression(IASTExpression iASTExpression) {
        IASTExpression.Kind kind = iASTExpression.getExpressionKind();
        if (kind != IASTExpression.Kind.PRIMARY_CHAR_LITERAL && kind != IASTExpression.Kind.PRIMARY_STRING_LITERAL) {
            return iASTExpression.getLiteralString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string = iASTExpression.getLiteralString();
        if (kind == IASTExpression.Kind.PRIMARY_CHAR_LITERAL) {
            boolean bl2 = bl = string.charAt(0) == string.charAt(string.length() - 1) && string.charAt(0) == '\'';
            if (!bl) {
                stringBuffer.append('\'');
            }
            stringBuffer.append(string);
            if (!bl) {
                stringBuffer.append('\'');
            }
        } else if (kind == IASTExpression.Kind.PRIMARY_STRING_LITERAL) {
            boolean bl3 = bl = string.charAt(0) == string.charAt(string.length() - 1) && string.charAt(0) == '\"';
            if (!bl) {
                stringBuffer.append('\"');
            }
            stringBuffer.append(iASTExpression.getLiteralString());
            if (!bl) {
                stringBuffer.append('\"');
            }
        }
        return stringBuffer.toString();
    }

    private static String getIdExpression(IASTExpression iASTExpression) {
        return iASTExpression.getIdExpression();
    }

    private static String getConditionalExpression(IASTExpression iASTExpression) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getLHSExpression()));
        stringBuffer.append(" ? ");
        stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getRHSExpression()));
        stringBuffer.append(" : ");
        stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getThirdExpression()));
        return stringBuffer.toString();
    }

    private static String getNewExpression(IASTExpression iASTExpression) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new");
        stringBuffer.append(' ');
        IASTExpression.IASTNewExpressionDescriptor iASTNewExpressionDescriptor = iASTExpression.getNewExpressionDescriptor();
        Iterator iterator = iASTNewExpressionDescriptor.getNewPlacementExpressions();
        if (iterator.hasNext()) {
            stringBuffer.append('(');
            stringBuffer.append(ASTUtil.getExpressionString((IASTExpression)iterator.next()));
            stringBuffer.append(") ");
        }
        if ((iterator = iASTNewExpressionDescriptor.getNewTypeIdExpressions()).hasNext()) {
            stringBuffer.append(ASTUtil.getExpressionString((IASTExpression)iterator.next()));
            stringBuffer.append(' ');
        }
        if (iASTExpression.getTypeId() != null) {
            stringBuffer.append(ASTUtil.getTypeId(iASTExpression.getTypeId()));
        }
        if ((iterator = iASTNewExpressionDescriptor.getNewInitializerExpressions()).hasNext()) {
            stringBuffer.append('(');
            stringBuffer.append(ASTUtil.getExpressionString((IASTExpression)iterator.next()));
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static String getBinaryExpression(IASTExpression iASTExpression) {
        IASTExpression.Kind kind = iASTExpression.getExpressionKind();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getLHSExpression()));
        boolean bl = false;
        if (kind != IASTExpression.Kind.EXPRESSIONLIST && kind != IASTExpression.Kind.PM_DOTSTAR && kind != IASTExpression.Kind.PM_ARROWSTAR && kind != IASTExpression.Kind.POSTFIX_SUBSCRIPT && kind != IASTExpression.Kind.POSTFIX_FUNCTIONCALL && kind != IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS && kind != IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION && kind != IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR && kind != IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP && kind != IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION && kind != IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR) {
            bl = true;
            stringBuffer.append(' ');
        }
        if (kind == IASTExpression.Kind.ANDEXPRESSION || kind == IASTExpression.Kind.EXPRESSIONLIST || kind == IASTExpression.Kind.EXCLUSIVEOREXPRESSION || kind == IASTExpression.Kind.PM_DOTSTAR || kind == IASTExpression.Kind.PM_ARROWSTAR || kind == IASTExpression.Kind.LOGICALANDEXPRESSION || kind == IASTExpression.Kind.LOGICALOREXPRESSION || kind == IASTExpression.Kind.RELATIONAL_GREATERTHAN || kind == IASTExpression.Kind.RELATIONAL_LESSTHAN || kind == IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO || kind == IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO || kind == IASTExpression.Kind.EQUALITY_EQUALS || kind == IASTExpression.Kind.EQUALITY_NOTEQUALS || kind == IASTExpression.Kind.ADDITIVE_PLUS || kind == IASTExpression.Kind.ADDITIVE_MINUS || kind == IASTExpression.Kind.INCLUSIVEOREXPRESSION || kind == IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY || kind == IASTExpression.Kind.MULTIPLICATIVE_DIVIDE || kind == IASTExpression.Kind.MULTIPLICATIVE_MODULUS || kind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS || kind == IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR || kind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP || kind == IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_NORMAL || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MULT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_DIV || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MOD || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_PLUS || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MINUS || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_RSHIFT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_LSHIFT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_AND || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_XOR || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_OR || kind == IASTExpression.Kind.SHIFT_LEFT || kind == IASTExpression.Kind.SHIFT_RIGHT) {
            stringBuffer.append(ASTUtil.getStringForKind(kind));
        } else if (kind == IASTExpression.Kind.POSTFIX_SUBSCRIPT) {
            stringBuffer.append('[');
        } else if (kind == IASTExpression.Kind.POSTFIX_FUNCTIONCALL) {
            stringBuffer.append('(');
        }
        if (kind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS || kind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP) {
            stringBuffer.append(' ');
            stringBuffer.append("template");
            stringBuffer.append(' ');
        }
        if (bl || kind == IASTExpression.Kind.EXPRESSIONLIST) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getRHSExpression()));
        if (kind == IASTExpression.Kind.POSTFIX_SUBSCRIPT) {
            stringBuffer.append(']');
        } else if (kind == IASTExpression.Kind.POSTFIX_FUNCTIONCALL) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static String getUnaryTypeIdExpression(IASTExpression iASTExpression) {
        StringBuffer stringBuffer = new StringBuffer();
        IASTExpression.Kind kind = iASTExpression.getExpressionKind();
        if (kind == IASTExpression.Kind.CASTEXPRESSION) {
            stringBuffer.append('(');
            stringBuffer.append(ASTUtil.getTypeId(iASTExpression.getTypeId()));
            stringBuffer.append(')');
            stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getLHSExpression()));
        } else if (kind == IASTExpression.Kind.POSTFIX_DYNAMIC_CAST || kind == IASTExpression.Kind.POSTFIX_STATIC_CAST || kind == IASTExpression.Kind.POSTFIX_REINTERPRET_CAST || kind == IASTExpression.Kind.POSTFIX_CONST_CAST) {
            stringBuffer.append(ASTUtil.getStringForKind(kind));
            stringBuffer.append('<');
            stringBuffer.append(ASTUtil.getTypeId(iASTExpression.getTypeId()));
            stringBuffer.append(">(");
            stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getLHSExpression()));
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static String getUnaryIdExpression(IASTExpression iASTExpression) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typename");
        stringBuffer.append(' ');
        if (iASTExpression.getExpressionKind() == IASTExpression.Kind.POSTFIX_TYPENAME_TEMPLATEID) {
            stringBuffer.append("template");
            stringBuffer.append(' ');
        }
        stringBuffer.append(iASTExpression.getIdExpression());
        stringBuffer.append('(');
        stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getLHSExpression()));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static String getUnaryExpression(IASTExpression iASTExpression) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        IASTExpression.Kind kind = iASTExpression.getExpressionKind();
        boolean bl2 = bl = kind == IASTExpression.Kind.PRIMARY_BRACKETED_EXPRESSION;
        if (kind == IASTExpression.Kind.UNARY_SIZEOF_UNARYEXPRESSION) {
            stringBuffer.append("sizeof");
            stringBuffer.append(' ');
        } else if (kind == IASTExpression.Kind.UNARY_STAR_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_AMPSND_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_PLUS_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_MINUS_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_TILDE_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_DECREMENT || kind == IASTExpression.Kind.THROWEXPRESSION) {
            stringBuffer.append(ASTUtil.getStringForKind(kind));
        } else if (kind == IASTExpression.Kind.UNARY_INCREMENT) {
            stringBuffer.append("++");
        } else if (kind == IASTExpression.Kind.DELETE_VECTORCASTEXPRESSION || kind == IASTExpression.Kind.DELETE_CASTEXPRESSION) {
            stringBuffer.append("delete");
            stringBuffer.append(' ');
            if (kind == IASTExpression.Kind.DELETE_VECTORCASTEXPRESSION) {
                stringBuffer.append("[ ] ");
            }
        } else if (kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_CHAR || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_WCHART || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_BOOL || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_SHORT || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_INT || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_LONG || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_SIGNED || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_UNSIGNED || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_FLOAT || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_DOUBLE) {
            stringBuffer.append(ASTUtil.getStringForKind(kind));
            bl = true;
        } else if (kind == IASTExpression.Kind.POSTFIX_TYPEID_EXPRESSION) {
            stringBuffer.append("typeid");
            bl = true;
        }
        if (bl) {
            stringBuffer.append('(');
        }
        stringBuffer.append(ASTUtil.getExpressionString(iASTExpression.getLHSExpression()));
        if (bl) {
            stringBuffer.append(')');
        }
        if (kind == IASTExpression.Kind.POSTFIX_INCREMENT || kind == IASTExpression.Kind.POSTFIX_DECREMENT) {
            stringBuffer.append(ASTUtil.getStringForKind(kind));
        }
        return stringBuffer.toString();
    }

    private static String getTypeIdExpression(IASTExpression iASTExpression) {
        StringBuffer stringBuffer = new StringBuffer();
        IASTExpression.Kind kind = iASTExpression.getExpressionKind();
        boolean bl = false;
        if (kind == IASTExpression.Kind.UNARY_SIZEOF_TYPEID) {
            stringBuffer.append("sizeof");
            stringBuffer.append(' ');
            bl = true;
        } else if (kind == IASTExpression.Kind.POSTFIX_TYPEID_TYPEID) {
            stringBuffer.append("typeid");
            bl = true;
        }
        if (bl) {
            stringBuffer.append('(');
        }
        stringBuffer.append(ASTUtil.getTypeId(iASTExpression.getTypeId()));
        if (bl) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static String getStringForKind(IASTExpression.Kind kind) {
        return (String)expressionKindStringMap.get(kind);
    }
}

