/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.ScannerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ScannerProvider
extends AbstractCExtension
implements IScannerInfoProvider,
IElementChangedListener {
    private static Map listeners;
    private static ScannerProvider fProvider;

    public static synchronized IScannerInfoProvider getInstance() {
        if (fProvider == null) {
            fProvider = new ScannerProvider();
            CoreModel.getDefault().addElementChangedListener(fProvider);
        }
        return fProvider;
    }

    private static Map getListeners() {
        if (listeners == null) {
            listeners = new HashMap();
        }
        return listeners;
    }

    protected static void notifyInfoListeners(IProject iProject, IScannerInfo iScannerInfo) {
        List list = (List)ScannerProvider.getListeners().get(iProject);
        if (list == null) {
            return;
        }
        IScannerInfoChangeListener[] iScannerInfoChangeListenerArray = new IScannerInfoChangeListener[list.size()];
        list.toArray(iScannerInfoChangeListenerArray);
        int n = 0;
        while (n < iScannerInfoChangeListenerArray.length) {
            iScannerInfoChangeListenerArray[n].changeNotification((IResource)iProject, iScannerInfo);
            ++n;
        }
    }

    public IScannerInfo getScannerInformation(IResource iResource) {
        IPath iPath = iResource.getFullPath();
        ICProject iCProject = CoreModel.getDefault().create(iResource.getProject());
        try {
            if (iCProject != null) {
                Object object;
                Object object2;
                IPathEntry[] iPathEntryArray;
                Object object3;
                Object object4;
                Object object5;
                IPathEntry[] iPathEntryArray2 = iCProject.getResolvedPathEntries();
                int n = 0;
                while (n < iPathEntryArray2.length) {
                    switch (iPathEntryArray2[n].getEntryKind()) {
                        case 4: {
                            object5 = (IIncludeEntry)iPathEntryArray2[n];
                            if (!CoreModelUtil.isExcluded(iPath, object5.fullExclusionPatternChars())) break;
                            iPathEntryArray2[n] = null;
                            break;
                        }
                        case 6: {
                            object4 = (IMacroEntry)iPathEntryArray2[n];
                            if (!CoreModelUtil.isExcluded(iPath, object4.fullExclusionPatternChars())) break;
                            iPathEntryArray2[n] = null;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            iPathEntryArray2[n] = null;
                        }
                    }
                    ++n;
                }
                n = iPath.segmentCount();
                object5 = new ArrayList();
                object4 = new HashMap();
                int n2 = 0;
                while (n2 < n) {
                    object3 = iPath.removeLastSegments(n2);
                    int n3 = 0;
                    while (n3 < iPathEntryArray2.length) {
                        if (iPathEntryArray2[n3] != null && object3.equals((Object)(iPathEntryArray = (object2 = iPathEntryArray2[n3]).getPath()))) {
                            IPathEntry iPathEntry;
                            if (object2.getEntryKind() == 4) {
                                iPathEntry = (IIncludeEntry)object2;
                                ((ArrayList)object5).add(iPathEntry.getFullIncludePath().toOSString());
                            } else if (object2.getEntryKind() == 6 && !object4.containsKey(object = (iPathEntry = (IMacroEntry)object2).getMacroName())) {
                                object4.put(object, iPathEntry.getMacroValue());
                            }
                        }
                        ++n3;
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < iPathEntryArray2.length) {
                    IResource iResource2;
                    object3 = iPathEntryArray2[n2];
                    if (object3 != null && object3.getEntryKind() == 2 && (iResource2 = iResource.getWorkspace().getRoot().findMember(object3.getPath())) != null && iResource2.getType() == 4 && (object2 = CoreModel.getDefault().create((IProject)iResource2)) != null) {
                        iPathEntryArray = object2.getResolvedPathEntries();
                        int n4 = 0;
                        while (n4 < iPathEntryArray.length) {
                            object = iPathEntryArray[n4];
                            if (object.isExported()) {
                                String string;
                                IPathEntry iPathEntry;
                                if (object.getEntryKind() == 4) {
                                    iPathEntry = (IIncludeEntry)object;
                                    ((ArrayList)object5).add(iPathEntry.getFullIncludePath().toOSString());
                                } else if (object.getEntryKind() == 6 && !object4.containsKey(string = (iPathEntry = (IMacroEntry)object3).getMacroName())) {
                                    object4.put(string, iPathEntry.getMacroValue());
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                String[] stringArray = new String[((ArrayList)object5).size()];
                ((ArrayList)object5).toArray(stringArray);
                return new ScannerInfo(stringArray, (Map)object4);
            }
        }
        catch (CModelException cModelException) {}
        return new ScannerInfo(null, null);
    }

    public synchronized void subscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        if (iResource == null || iScannerInfoChangeListener == null) {
            return;
        }
        IProject iProject = iResource.getProject();
        Map map = ScannerProvider.getListeners();
        ArrayList<IScannerInfoChangeListener> arrayList = (ArrayList<IScannerInfoChangeListener>)map.get(iProject);
        if (arrayList == null) {
            arrayList = new ArrayList<IScannerInfoChangeListener>();
            map.put(iProject, arrayList);
        }
        if (!arrayList.contains(iScannerInfoChangeListener)) {
            arrayList.add(iScannerInfoChangeListener);
        }
    }

    public synchronized void unsubscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        if (iResource == null || iScannerInfoChangeListener == null) {
            return;
        }
        IProject iProject = iResource.getProject();
        Map map = ScannerProvider.getListeners();
        List list = (List)map.get(iProject);
        if (list != null && !list.isEmpty()) {
            list.remove(iScannerInfoChangeListener);
        }
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (CModelException cModelException) {}
    }

    protected boolean isPathEntryChange(ICElementDelta iCElementDelta) {
        int n = iCElementDelta.getFlags();
        return iCElementDelta.getKind() == 4 && ((n & 0x800) != 0 || (n & 0x400) != 0 || (n & 0x40000) != 0);
    }

    protected void processDelta(ICElementDelta iCElementDelta) throws CModelException {
        IProject iProject;
        ICElement iCElement = iCElementDelta.getElement();
        if (this.isPathEntryChange(iCElementDelta)) {
            iProject = iCElement.getResource();
            IProject iProject2 = iCElement.getCProject().getProject();
            if (iProject == null) {
                iProject = iProject2;
            }
            IScannerInfo iScannerInfo = this.getScannerInformation((IResource)iProject);
            ScannerProvider.notifyInfoListeners(iProject2, iScannerInfo);
        }
        iProject = iCElementDelta.getAffectedChildren();
        int n = 0;
        while (n < ((ICElementDelta[])iProject).length) {
            this.processDelta((ICElementDelta)iProject[n]);
            ++n;
        }
    }
}

