/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class BasicSearchMatch
implements IMatch,
Comparable {
    private static final String HASH_SEPERATOR = ":";
    public String name = null;
    public String parentName = null;
    public String returnType;
    public IResource resource = null;
    public IPath path = null;
    public int startOffset = 0;
    public int endOffset = 0;
    public int type = 0;
    public int visibility = 0;
    boolean isConst = false;
    boolean isVolatile = false;
    boolean isStatic = false;
    private int hashCode = 0;
    public IPath referringElement = null;

    public BasicSearchMatch() {
    }

    public BasicSearchMatch(BasicSearchMatch basicSearchMatch) {
        this.name = basicSearchMatch.name;
        this.parentName = basicSearchMatch.parentName;
        this.returnType = basicSearchMatch.returnType;
        this.resource = basicSearchMatch.resource;
        this.path = basicSearchMatch.path;
        this.startOffset = basicSearchMatch.startOffset;
        this.endOffset = basicSearchMatch.endOffset;
        this.referringElement = basicSearchMatch.referringElement;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            stringBuffer.append(HASH_SEPERATOR);
            stringBuffer.append(this.parentName);
            stringBuffer.append(HASH_SEPERATOR);
            stringBuffer.append(this.returnType);
            if (this.getLocation() != null) {
                stringBuffer.append(HASH_SEPERATOR);
                stringBuffer.append(this.getLocation().toString());
            }
            stringBuffer.append(HASH_SEPERATOR);
            stringBuffer.append(this.startOffset);
            stringBuffer.append(HASH_SEPERATOR);
            stringBuffer.append(this.endOffset);
            stringBuffer.append(HASH_SEPERATOR);
            stringBuffer.append(this.type);
            stringBuffer.append(HASH_SEPERATOR);
            stringBuffer.append(this.visibility);
            this.hashCode = stringBuffer.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicSearchMatch)) {
            return false;
        }
        BasicSearchMatch basicSearchMatch = (BasicSearchMatch)object;
        if (this.startOffset != basicSearchMatch.getStartOffset() || this.endOffset != basicSearchMatch.getEndOffset()) {
            return false;
        }
        if (this.type != basicSearchMatch.getElementType() || this.visibility != basicSearchMatch.getVisibility()) {
            return false;
        }
        if (this.name != null && basicSearchMatch.getName() != null ? !this.name.equals(basicSearchMatch.getName()) : this.name != basicSearchMatch.getName()) {
            return false;
        }
        if (this.parentName != null && basicSearchMatch.getParentName() != null ? !this.parentName.equals(basicSearchMatch.getParentName()) : this.parentName != basicSearchMatch.getParentName()) {
            return false;
        }
        if (this.returnType != null && basicSearchMatch.getReturnType() != null ? !this.returnType.equals(basicSearchMatch.getReturnType()) : this.returnType != basicSearchMatch.getReturnType()) {
            return false;
        }
        IPath iPath = this.getLocation();
        IPath iPath2 = basicSearchMatch.getLocation();
        return !(iPath != null && iPath2 != null ? !iPath.equals((Object)iPath2) : iPath != iPath2);
    }

    public int compareTo(Object object) {
        if (!(object instanceof BasicSearchMatch)) {
            throw new ClassCastException();
        }
        BasicSearchMatch basicSearchMatch = (BasicSearchMatch)object;
        int n = this.getLocation().toString().compareTo(basicSearchMatch.getLocation().toString());
        if (n != 0) {
            return n;
        }
        n = this.getStartOffset() - basicSearchMatch.getStartOffset();
        if (n != 0) {
            return n;
        }
        n = this.getName().compareTo(basicSearchMatch.getName());
        if (n != 0) {
            return n;
        }
        n = this.getParentName().compareTo(basicSearchMatch.getParentName());
        if (n != 0) {
            return n;
        }
        n = this.getReturnType().compareTo(basicSearchMatch.getReturnType());
        return n;
    }

    public int getElementType() {
        return this.type;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IPath getLocation() {
        if (this.resource != null) {
            return this.resource.getLocation();
        }
        if (this.path != null) {
            return this.path;
        }
        return null;
    }

    public IPath getReferenceLocation() {
        return this.referringElement;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int getType() {
        return this.type;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    public void setConst(boolean bl) {
        this.isConst = bl;
    }

    public void setStatic(boolean bl) {
        this.isStatic = bl;
    }

    public void setVolatile(boolean bl) {
        this.isVolatile = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParentName(String string) {
        this.parentName = string;
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setVisibility(int n) {
        this.visibility = n;
    }
}

