/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class BasicSearchResultCollector
implements ICSearchResultCollector {
    IProgressMonitor fProgressMonitor = null;
    private Set results;

    public BasicSearchResultCollector() {
    }

    public BasicSearchResultCollector(IProgressMonitor iProgressMonitor) {
        this.fProgressMonitor = iProgressMonitor;
    }

    public void aboutToStart() {
        this.results = new HashSet();
    }

    public void done() {
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.fProgressMonitor = iProgressMonitor;
    }

    public IMatch createMatch(Object object, int n, int n2, ISourceElementCallbackDelegate iSourceElementCallbackDelegate, IPath iPath) {
        BasicSearchMatch basicSearchMatch = new BasicSearchMatch();
        return this.createMatch(basicSearchMatch, object, n, n2, iSourceElementCallbackDelegate, iPath);
    }

    public IMatch createMatch(BasicSearchMatch basicSearchMatch, Object object, int n, int n2, ISourceElementCallbackDelegate iSourceElementCallbackDelegate, IPath iPath) {
        if (object instanceof IResource) {
            basicSearchMatch.resource = (IResource)object;
        } else if (object instanceof IPath) {
            basicSearchMatch.path = (IPath)object;
        }
        basicSearchMatch.startOffset = n;
        basicSearchMatch.endOffset = n2;
        basicSearchMatch.parentName = "";
        basicSearchMatch.referringElement = iPath;
        IASTOffsetableNamedElement iASTOffsetableNamedElement = null;
        if (iSourceElementCallbackDelegate instanceof IASTReference) {
            iASTOffsetableNamedElement = (IASTOffsetableNamedElement)((Object)((IASTReference)iSourceElementCallbackDelegate).getReferencedElement());
            basicSearchMatch.name = ((IASTReference)iSourceElementCallbackDelegate).getName();
        } else if (iSourceElementCallbackDelegate instanceof IASTOffsetableNamedElement) {
            iASTOffsetableNamedElement = (IASTOffsetableNamedElement)((Object)iSourceElementCallbackDelegate);
            basicSearchMatch.name = iASTOffsetableNamedElement.getName();
        }
        basicSearchMatch.parentName = "";
        String[] stringArray = null;
        if (iASTOffsetableNamedElement instanceof IASTEnumerator) {
            IASTEnumerator iASTEnumerator = (IASTEnumerator)iASTOffsetableNamedElement;
            stringArray = iASTEnumerator.getOwnerEnumerationSpecifier().getFullyQualifiedName();
        } else if (iASTOffsetableNamedElement instanceof IASTQualifiedNameElement) {
            stringArray = ((IASTQualifiedNameElement)((Object)iASTOffsetableNamedElement)).getFullyQualifiedName();
        }
        if (stringArray != null) {
            int n3 = 0;
            while (n3 < stringArray.length - 1) {
                if (n3 > 0) {
                    basicSearchMatch.parentName = String.valueOf(basicSearchMatch.parentName) + "::";
                }
                basicSearchMatch.parentName = String.valueOf(basicSearchMatch.parentName) + stringArray[n3];
                ++n3;
            }
        }
        if (iASTOffsetableNamedElement instanceof IASTVariable) {
            basicSearchMatch.returnType = ASTUtil.getType(((IASTVariable)iASTOffsetableNamedElement).getAbstractDeclaration());
        }
        if (iASTOffsetableNamedElement instanceof IASTFunction) {
            basicSearchMatch.name = String.valueOf(basicSearchMatch.name) + this.getParameterString((IASTFunction)iASTOffsetableNamedElement);
            basicSearchMatch.returnType = ASTUtil.getType(((IASTFunction)iASTOffsetableNamedElement).getReturnType());
        }
        this.setElementInfo(basicSearchMatch, iASTOffsetableNamedElement);
        return basicSearchMatch;
    }

    private String getParameterString(IASTFunction iASTFunction) {
        if (iASTFunction == null) {
            return "";
        }
        String string = "(";
        String[] stringArray = ASTUtil.getFunctionParameterTypes(iASTFunction);
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + stringArray[n];
            ++n;
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public boolean acceptMatch(IMatch iMatch) throws CoreException {
        if (!this.results.contains(iMatch)) {
            this.results.add(iMatch);
            return true;
        }
        return false;
    }

    public Set getSearchResults() {
        return this.results;
    }

    private void setElementInfo(BasicSearchMatch basicSearchMatch, IASTOffsetableElement iASTOffsetableElement) {
        if (iASTOffsetableElement instanceof IASTClassSpecifier || iASTOffsetableElement instanceof IASTElaboratedTypeSpecifier) {
            ASTClassKind aSTClassKind = null;
            aSTClassKind = iASTOffsetableElement instanceof IASTClassSpecifier ? ((IASTClassSpecifier)iASTOffsetableElement).getClassKind() : ((IASTElaboratedTypeSpecifier)iASTOffsetableElement).getClassKind();
            if (aSTClassKind == ASTClassKind.CLASS) {
                basicSearchMatch.type = 64;
            } else if (aSTClassKind == ASTClassKind.STRUCT) {
                basicSearchMatch.type = 65;
            } else if (aSTClassKind == ASTClassKind.UNION) {
                basicSearchMatch.type = 66;
            }
        } else if (iASTOffsetableElement instanceof IASTNamespaceDefinition) {
            basicSearchMatch.type = 61;
        } else if (iASTOffsetableElement instanceof IASTEnumerationSpecifier) {
            basicSearchMatch.type = 63;
        } else if (iASTOffsetableElement instanceof IASTMacro) {
            basicSearchMatch.type = 77;
        } else if (iASTOffsetableElement instanceof IASTField) {
            basicSearchMatch.type = 69;
            IASTField iASTField = (IASTField)iASTOffsetableElement;
            ASTAccessVisibility aSTAccessVisibility = iASTField.getVisiblity();
            if (aSTAccessVisibility == ASTAccessVisibility.PUBLIC) {
                basicSearchMatch.visibility = 8192;
            } else if (aSTAccessVisibility == ASTAccessVisibility.PRIVATE) {
                basicSearchMatch.visibility = 4096;
            }
            basicSearchMatch.isConst = iASTField.getAbstractDeclaration().isConst();
            basicSearchMatch.isStatic = iASTField.isStatic();
        } else if (iASTOffsetableElement instanceof IASTVariable) {
            basicSearchMatch.type = 74;
            IASTVariable iASTVariable = (IASTVariable)iASTOffsetableElement;
            basicSearchMatch.isConst = iASTVariable.getAbstractDeclaration().isConst();
        } else if (iASTOffsetableElement instanceof IASTParameterDeclaration) {
            basicSearchMatch.type = 74;
            basicSearchMatch.isConst = ((IASTParameterDeclaration)iASTOffsetableElement).isConst();
        } else if (iASTOffsetableElement instanceof IASTEnumerator) {
            basicSearchMatch.type = 79;
        } else if (iASTOffsetableElement instanceof IASTMethod) {
            basicSearchMatch.type = 67;
            IASTMethod iASTMethod = (IASTMethod)iASTOffsetableElement;
            ASTAccessVisibility aSTAccessVisibility = iASTMethod.getVisiblity();
            if (aSTAccessVisibility == ASTAccessVisibility.PUBLIC) {
                basicSearchMatch.visibility = 8192;
            } else if (aSTAccessVisibility == ASTAccessVisibility.PRIVATE) {
                basicSearchMatch.visibility = 4096;
            }
            basicSearchMatch.isConst = iASTMethod.isConst();
            basicSearchMatch.isVolatile = iASTMethod.isVolatile();
            basicSearchMatch.isStatic = iASTMethod.isStatic();
        } else if (iASTOffsetableElement instanceof IASTFunction) {
            basicSearchMatch.type = 71;
            IASTFunction iASTFunction = (IASTFunction)iASTOffsetableElement;
            basicSearchMatch.isStatic = iASTFunction.isStatic();
        } else if (iASTOffsetableElement instanceof IASTTypedefDeclaration) {
            basicSearchMatch.type = 78;
        }
    }
}

