/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class CDTLogWriter {
    protected File logFile = null;
    protected Writer log = null;
    protected boolean newSession = true;
    protected static final String SESSION = "*** SESSION";
    protected static final String ENTRY = "ENTRY";
    protected static final String SUBENTRY = "SUBENTRY";
    protected static final String MESSAGE = "MESSAGE";
    protected static final String STACK = "STACK";
    protected static final String LINE_SEPARATOR;
    protected static final String TAB_STRING = "\t";
    protected static final long MAXLOG_SIZE = 10000000L;

    static {
        String string = System.getProperty("line.separator");
        LINE_SEPARATOR = string == null ? "\n" : string;
    }

    public CDTLogWriter(File file) {
        this.logFile = file;
        if (file.length() > 10000000L) {
            file.delete();
            this.logFile = CCorePlugin.getDefault().getStateLocation().append(".log").toFile();
        }
        this.openLogFile();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.log = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.log = null;
            return;
        }
    }

    protected void openLogFile() {
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
            if (this.newSession) {
                this.writeHeader();
                this.newSession = false;
            }
        }
        catch (IOException iOException) {}
    }

    protected void writeHeader() throws IOException {
        this.write(SESSION);
        this.writeSpace();
        String string = this.getDate();
        this.write(string);
        this.writeSpace();
        int n = SESSION.length() + string.length();
        while (n < 78) {
            this.write("-");
            ++n;
        }
        this.writeln();
    }

    protected String getDate() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS");
            return simpleDateFormat.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    protected Writer logForStream(OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    protected void writeln(String string) throws IOException {
        this.write(string);
        this.writeln();
    }

    public synchronized void shutdown() {
        try {
            if (this.logFile != null) {
                this.closeLogFile();
                this.logFile = null;
            } else if (this.log != null) {
                Writer writer = this.log;
                this.log = null;
                writer.flush();
                writer.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void write(Throwable throwable) throws IOException {
        if (throwable == null) {
            return;
        }
        this.write(STACK);
        this.writeSpace();
        boolean bl = throwable instanceof CoreException;
        if (bl) {
            this.writeln("1");
        } else {
            this.writeln("0");
        }
        throwable.printStackTrace(new PrintWriter(this.log));
        if (bl) {
            CoreException coreException = (CoreException)throwable;
            this.write(coreException.getStatus(), 0);
        }
    }

    public synchronized void log(IStatus iStatus) {
        try {
            this.write(iStatus, 0);
        }
        catch (IOException iOException) {}
    }

    protected void write(IStatus iStatus, int n) throws IOException {
        if (n == 0) {
            this.write(ENTRY);
        } else {
            this.write(SUBENTRY);
            this.writeSpace();
            this.write(Integer.toString(n));
        }
        this.writeSpace();
        this.write(iStatus.getPlugin());
        this.writeSpace();
        this.write(Integer.toString(iStatus.getSeverity()));
        this.writeSpace();
        this.write(Integer.toString(iStatus.getCode()));
        this.writeSpace();
        this.write(this.getDate());
        this.writeln();
        this.write(MESSAGE);
        this.writeSpace();
        this.writeln(iStatus.getMessage());
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n2 = 0;
            while (n2 < iStatusArray.length) {
                this.write(iStatusArray[n2], n + 1);
                ++n2;
            }
        }
    }

    protected void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    protected void write(String string) throws IOException {
        if (string != null) {
            this.log.write(string);
        }
    }

    protected void writeSpace() throws IOException {
        this.write(" ");
    }

    public synchronized void flushLog() {
        try {
            this.log.flush();
        }
        catch (IOException iOException) {}
    }
}

