/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.cdt.internal.core.CDescriptorManager;
import org.eclipse.cdt.internal.core.CExtensionInfo;
import org.eclipse.cdt.internal.core.CExtensionReference;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.InternalCExtension;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class CDescriptor
implements ICDescriptor {
    final CDescriptorManager fManager;
    final IProject fProject;
    private COwner fOwner;
    private HashMap extMap = new HashMap(4);
    private HashMap extInfoMap = new HashMap(4);
    private Document dataDoc;
    protected static final String DESCRIPTION_FILE_NAME = ".cdtproject";
    private static final String CEXTENSION_NAME = "cextension";
    private static final String PROJECT_DESCRIPTION = "cdtproject";
    private static final String PROJECT_OWNER_ID = "id";
    private static final String PROJECT_EXTENSION = "extension";
    private static final String PROJECT_EXTENSION_ATTR_POINT = "point";
    private static final String PROJECT_EXTENSION_ATTR_ID = "id";
    private static final String PROJECT_EXTENSION_ATTRIBUTE = "attribute";
    private static final String PROJECT_EXTENSION_ATTRIBUTE_KEY = "key";
    private static final String PROJECT_EXTENSION_ATTRIBUTE_VALUE = "value";
    private static final String PROJECT_DATA = "data";
    private static final String PROJECT_DATA_ITEM = "item";
    private static final String PROJECT_DATA_ID = "id";
    boolean fUpdating;
    boolean isInitializing = true;
    boolean bDirty = false;

    protected CDescriptor(CDescriptorManager cDescriptorManager, IProject iProject, String string) throws CoreException {
        String string2;
        IPath iPath;
        this.fProject = iProject;
        this.fManager = cDescriptorManager;
        IPath iPath2 = iProject.getDescription().getLocation();
        if (iPath2 == null) {
            iPath2 = CDescriptor.getProjectDefaultLocation(iProject);
        }
        if ((iPath = iPath2.append(DESCRIPTION_FILE_NAME)).toFile().exists() && !(string2 = this.readCDTProjectFile(iPath)).equals("")) {
            Status status = string2.equals(string) ? new Status(2, "org.eclipse.cdt.core", 1, CCorePlugin.getResourceString("CDescriptor.exception.projectAlreadyExists"), null) : new Status(4, "org.eclipse.cdt.core", 2, String.valueOf(CCorePlugin.getResourceString("CDescriptor.exception.unmatchedOwnerId")) + "<requested:" + string + "/ In file:" + string2 + ">", null);
            throw new CoreException((IStatus)status);
        }
        this.fOwner = new COwner(cDescriptorManager.getOwnerConfiguration(string));
        this.fOwner.configure(iProject, this);
        this.isInitializing = false;
        this.save();
    }

    protected CDescriptor(CDescriptorManager cDescriptorManager, IProject iProject) throws CoreException {
        IPath iPath;
        this.fProject = iProject;
        this.fManager = cDescriptorManager;
        IPath iPath2 = iProject.getDescription().getLocation();
        if (iPath2 == null) {
            iPath2 = CDescriptor.getProjectDefaultLocation(iProject);
        }
        if (!(iPath = iPath2.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            this.fOwner = new COwner(cDescriptorManager.getOwnerConfiguration(iProject));
            this.fOwner.configure(iProject, this);
            this.fManager.updateDescriptor(this);
        } else {
            String string = this.readCDTProjectFile(iPath);
            this.fOwner = new COwner(cDescriptorManager.getOwnerConfiguration(string));
        }
        this.isInitializing = false;
    }

    protected CDescriptor(CDescriptorManager cDescriptorManager, IProject iProject, COwner cOwner) throws CoreException {
        IPath iPath;
        this.fProject = iProject;
        this.fManager = cDescriptorManager;
        IPath iPath2 = iProject.getDescription().getLocation();
        if (iPath2 == null) {
            iPath2 = CDescriptor.getProjectDefaultLocation(iProject);
        }
        if ((iPath = iPath2.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            this.readCDTProjectFile(iPath);
        }
        this.fOwner = cOwner;
        this.fOwner.configure(iProject, this);
        this.isInitializing = false;
        this.save();
    }

    private String readCDTProjectFile(IPath iPath) throws CoreException {
        String string = "";
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(iPath.toFile());
            NodeList nodeList = document.getElementsByTagName(PROJECT_DESCRIPTION);
            if (nodeList != null && nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                if (node.hasAttributes()) {
                    string = node.getAttributes().getNamedItem("id").getNodeValue();
                }
                this.readProjectDescription(node);
                return string;
            }
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.missingElement"), null);
            throw new CoreException((IStatus)status);
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, exception.toString(), (Throwable)exception);
            throw new CoreException((IStatus)status);
        }
    }

    private static IPath getProjectDefaultLocation(IProject iProject) {
        return Platform.getLocation().append(iProject.getFullPath());
    }

    public ICOwnerInfo getProjectOwner() {
        return this.fOwner;
    }

    public String getPlatform() {
        return this.fOwner.getPlatform();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public synchronized ICExtensionReference[] get(String string) {
        ICExtensionReference[] iCExtensionReferenceArray = (CExtensionReference[])this.extMap.get(string);
        if (iCExtensionReferenceArray == null) {
            return new ICExtensionReference[0];
        }
        return iCExtensionReferenceArray;
    }

    public synchronized ICExtensionReference[] get(String string, boolean bl) {
        ICExtensionReference[] iCExtensionReferenceArray = this.get(string);
        if (iCExtensionReferenceArray.length == 0 && bl) {
            try {
                boolean bl2 = this.isInitializing;
                this.isInitializing = true;
                this.fOwner.update(this.fProject, this, string);
                this.isInitializing = bl2;
                this.updateIfDirty();
                iCExtensionReferenceArray = this.get(string);
            }
            catch (CoreException coreException) {}
        }
        return iCExtensionReferenceArray;
    }

    private CExtensionReference createRef(String string, String string2) {
        CExtensionReference[] cExtensionReferenceArray = (CExtensionReference[])this.extMap.get(string);
        if (cExtensionReferenceArray == null) {
            cExtensionReferenceArray = new CExtensionReference[1];
            this.extMap.put(string, cExtensionReferenceArray);
        } else {
            CExtensionReference[] cExtensionReferenceArray2 = new CExtensionReference[cExtensionReferenceArray.length + 1];
            System.arraycopy(cExtensionReferenceArray, 0, cExtensionReferenceArray2, 0, cExtensionReferenceArray.length);
            cExtensionReferenceArray = cExtensionReferenceArray2;
            this.extMap.put(string, cExtensionReferenceArray);
        }
        cExtensionReferenceArray[cExtensionReferenceArray.length - 1] = new CExtensionReference(this, string, string2);
        return cExtensionReferenceArray[cExtensionReferenceArray.length - 1];
    }

    public synchronized ICExtensionReference create(String string, String string2) throws CoreException {
        CExtensionReference cExtensionReference;
        boolean bl = false;
        CDescriptor cDescriptor = this;
        synchronized (cDescriptor) {
            cExtensionReference = this.createRef(string, string2);
            this.updateOnDisk();
            if (!this.isInitializing) {
                bl = true;
            }
        }
        if (bl) {
            this.fManager.fireEvent(new CDescriptorEvent(this, 1, 32));
        }
        return cExtensionReference;
    }

    public synchronized void remove(ICExtensionReference iCExtensionReference) throws CoreException {
        boolean bl = false;
        CDescriptor cDescriptor = this;
        synchronized (cDescriptor) {
            CExtensionReference[] cExtensionReferenceArray = (CExtensionReference[])this.extMap.get(iCExtensionReference.getExtension());
            int n = 0;
            while (n < cExtensionReferenceArray.length) {
                if (cExtensionReferenceArray[n] == iCExtensionReference) {
                    System.arraycopy(cExtensionReferenceArray, n, cExtensionReferenceArray, n + 1, cExtensionReferenceArray.length - 1 - n);
                    if (cExtensionReferenceArray.length > 1) {
                        CExtensionReference[] cExtensionReferenceArray2 = new CExtensionReference[cExtensionReferenceArray.length - 1];
                        System.arraycopy(cExtensionReferenceArray, 0, cExtensionReferenceArray2, 0, cExtensionReferenceArray2.length);
                        this.extMap.put(iCExtensionReference.getExtension(), cExtensionReferenceArray2);
                    } else {
                        this.extMap.remove(iCExtensionReference.getExtension());
                    }
                    this.updateOnDisk();
                    if (!this.isInitializing) {
                        bl = true;
                    }
                }
                ++n;
            }
        }
        if (bl) {
            this.fManager.fireEvent(new CDescriptorEvent(this, 1, 32));
        }
    }

    public void remove(String string) throws CoreException {
        boolean bl = false;
        CDescriptor cDescriptor = this;
        synchronized (cDescriptor) {
            CExtensionReference[] cExtensionReferenceArray = (CExtensionReference[])this.extMap.get(string);
            if (cExtensionReferenceArray != null) {
                this.extMap.remove(string);
                this.updateOnDisk();
                if (!this.isInitializing) {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.fManager.fireEvent(new CDescriptorEvent(this, 1, 32));
        }
    }

    synchronized CExtensionInfo getInfo(CExtensionReference cExtensionReference) {
        CExtensionInfo cExtensionInfo = (CExtensionInfo)this.extInfoMap.get(cExtensionReference);
        if (cExtensionInfo == null) {
            cExtensionInfo = new CExtensionInfo();
            this.extInfoMap.put(cExtensionReference, cExtensionInfo);
        }
        return cExtensionInfo;
    }

    protected IFile getFile() {
        return this.getProject().getFile(DESCRIPTION_FILE_NAME);
    }

    void save() throws CoreException {
        this.fManager.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                String string;
                CDescriptor.this.bDirty = false;
                if (!CDescriptor.this.fProject.isAccessible()) {
                    return;
                }
                CDescriptor.this.fUpdating = true;
                try {
                    string = CDescriptor.this.getAsXML();
                }
                catch (IOException iOException) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, iOException.getMessage(), (Throwable)iOException);
                    throw new CoreException((IStatus)status);
                }
                catch (TransformerException transformerException) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, transformerException.getMessage(), (Throwable)transformerException);
                    throw new CoreException((IStatus)status);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, parserConfigurationException.getMessage(), (Throwable)parserConfigurationException);
                    throw new CoreException((IStatus)status);
                }
                IFile iFile = CDescriptor.this.getFile();
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
                    if (iFile.exists()) {
                        if (iFile.isReadOnly()) {
                            CDescriptor.this.fManager.getWorkspace().validateEdit(new IFile[]{iFile}, null);
                        }
                        iFile.setContents((InputStream)byteArrayInputStream, 1, null);
                    } else {
                        iFile.create((InputStream)byteArrayInputStream, 1, null);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
                    throw new CoreException((IStatus)status);
                }
                CDescriptor.this.fUpdating = false;
            }
        }, (ISchedulingRule)this.fProject, 1, null);
    }

    boolean isUpdating() {
        return this.fUpdating;
    }

    void updateIfDirty() {
        if (this.bDirty) {
            this.updateOnDisk();
        }
    }

    synchronized void updateOnDisk() {
        if (this.isUpdating()) {
            return;
        }
        if (this.isInitializing) {
            this.bDirty = true;
            return;
        }
        this.fUpdating = true;
        this.fManager.updateDescriptor(this);
    }

    void updateFromDisk() throws CoreException {
        Object[] objectArray;
        HashMap hashMap;
        HashMap hashMap2;
        COwner cOwner;
        Object object;
        Object object2;
        CDescriptor cDescriptor = this;
        synchronized (cDescriptor) {
            object2 = this.fProject.getDescription().getLocation();
            if (object2 == null) {
                object2 = CDescriptor.getProjectDefaultLocation(this.fProject);
            }
            if (!(object = object2.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
                this.updateOnDisk();
                return;
            }
            cOwner = this.fOwner;
            hashMap2 = this.extMap;
            hashMap = this.extInfoMap;
            Document document = this.dataDoc;
            this.extMap = new HashMap(4);
            this.extInfoMap = new HashMap(4);
            this.dataDoc = null;
            try {
                objectArray = this.readCDTProjectFile((IPath)object);
                this.fOwner = new COwner(this.fManager.getOwnerConfiguration((String)objectArray));
            }
            catch (CoreException coreException) {
                CCorePlugin.log(coreException);
                this.fOwner = cOwner;
                this.extMap = hashMap2;
                this.extInfoMap = hashMap;
                this.dataDoc = document;
            }
        }
        if (!this.fOwner.equals(cOwner)) {
            this.fManager.fireEvent(new CDescriptorEvent(this, 1, 16));
        } else {
            boolean bl = true;
            if (this.extMap.size() == hashMap2.size() && this.extInfoMap.size() == hashMap.size()) {
                bl = false;
                object2 = this.extMap.entrySet().iterator();
                while (object2.hasNext()) {
                    Object[] objectArray2;
                    object = (Map.Entry)object2.next();
                    if (!hashMap2.containsKey(object.getKey())) {
                        bl = true;
                        break;
                    }
                    objectArray = (CExtensionReference[])hashMap2.get(object.getKey());
                    if (Arrays.equals(objectArray, objectArray2 = (CExtensionReference[])object.getValue())) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.fManager.fireEvent(new CDescriptorEvent(this, 1, 32));
            } else {
                this.fManager.fireEvent(new CDescriptorEvent(this, 1, 0));
            }
        }
    }

    private void readProjectDescription(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 1) {
                if (node2.getNodeName().equals(PROJECT_EXTENSION)) {
                    try {
                        this.decodeProjectExtension((Element)node2);
                    }
                    catch (CoreException coreException) {
                        CCorePlugin.log(coreException);
                    }
                } else if (node2.getNodeName().equals(PROJECT_DATA)) {
                    try {
                        this.decodeProjectData((Element)node2);
                    }
                    catch (CoreException coreException) {
                        CCorePlugin.log(coreException);
                    }
                }
            }
            ++n;
        }
    }

    private void decodeProjectExtension(Element element) throws CoreException {
        String string = element.getAttribute(PROJECT_EXTENSION_ATTR_POINT);
        String string2 = element.getAttribute("id");
        CExtensionReference cExtensionReference = this.createRef(string, string2);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeName().equals(PROJECT_EXTENSION_ATTRIBUTE)) {
                NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
                this.getInfo(cExtensionReference).setAttribute(namedNodeMap.getNamedItem(PROJECT_EXTENSION_ATTRIBUTE_KEY).getNodeValue(), namedNodeMap.getNamedItem(PROJECT_EXTENSION_ATTRIBUTE_VALUE).getNodeValue());
            }
            ++n;
        }
    }

    private void encodeProjectExtensions(Document document, Element element) {
        Iterator iterator = this.extMap.values().iterator();
        while (iterator.hasNext()) {
            CExtensionReference[] cExtensionReferenceArray = (CExtensionReference[])iterator.next();
            int n = 0;
            while (n < cExtensionReferenceArray.length) {
                Element element2 = document.createElement(PROJECT_EXTENSION);
                element.appendChild(element2);
                element2.setAttribute(PROJECT_EXTENSION_ATTR_POINT, cExtensionReferenceArray[n].getExtension());
                element2.setAttribute("id", cExtensionReferenceArray[n].getID());
                CExtensionInfo cExtensionInfo = (CExtensionInfo)this.extInfoMap.get(cExtensionReferenceArray[n]);
                if (cExtensionInfo != null) {
                    Iterator iterator2 = cExtensionInfo.getAttributes().entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry = iterator2.next();
                        Element element3 = document.createElement(PROJECT_EXTENSION_ATTRIBUTE);
                        element3.setAttribute(PROJECT_EXTENSION_ATTRIBUTE_KEY, (String)entry.getKey());
                        element3.setAttribute(PROJECT_EXTENSION_ATTRIBUTE_VALUE, (String)entry.getValue());
                        element2.appendChild(element3);
                    }
                }
                ++n;
            }
        }
    }

    String getAsXML() throws IOException, TransformerException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        ProcessingInstruction processingInstruction = document.createProcessingInstruction("eclipse-cdt", "version=\"2.0\"");
        document.appendChild(processingInstruction);
        Element element = document.createElement(PROJECT_DESCRIPTION);
        document.appendChild(element);
        if (this.fOwner.getID().length() > 0) {
            element.setAttribute("id", this.fOwner.getID());
        }
        this.encodeProjectExtensions(document, element);
        this.encodeProjectData(document, element);
        return this.serializeDocument(document);
    }

    protected ICExtension createExtensions(ICExtensionReference iCExtensionReference) throws CoreException {
        InternalCExtension internalCExtension = null;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(iCExtensionReference.getExtension());
        IExtension iExtension = iExtensionPoint.getExtension(iCExtensionReference.getID());
        if (iExtension == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, String.valueOf(CCorePlugin.getResourceString("CDescriptor.exception.providerNotFound")) + ":" + iCExtensionReference.getID(), null));
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equalsIgnoreCase(CEXTENSION_NAME)) {
                internalCExtension = (InternalCExtension)((Object)iConfigurationElementArray[n].createExecutableExtension("run"));
                internalCExtension.setExtenionReference(iCExtensionReference);
                internalCExtension.setProject(this.fProject);
                break;
            }
            ++n;
        }
        return (ICExtension)((Object)internalCExtension);
    }

    protected IConfigurationElement[] getConfigurationElement(ICExtensionReference iCExtensionReference) throws CoreException {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(iCExtensionReference.getExtension());
        IExtension iExtension = iExtensionPoint.getExtension(iCExtensionReference.getID());
        if (iExtension == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.providerNotFound"), null));
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equalsIgnoreCase(CEXTENSION_NAME)) {
                return iConfigurationElementArray[n].getChildren();
            }
            ++n;
        }
        return new IConfigurationElement[0];
    }

    public Element getProjectData(String string) throws CoreException {
        NodeList nodeList = this.getProjectDataDoc().getDocumentElement().getElementsByTagName(PROJECT_DATA_ITEM);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            if (element.getAttribute("id").equals(string)) {
                return element;
            }
            ++n;
        }
        Element element = this.dataDoc.createElement(PROJECT_DATA_ITEM);
        element.setAttribute("id", string);
        this.dataDoc.getDocumentElement().appendChild(element);
        return element;
    }

    public void saveProjectData() throws CoreException {
        this.save();
        this.fManager.fireEvent(new CDescriptorEvent(this, 1, 0));
    }

    private synchronized Document getProjectDataDoc() throws CoreException {
        if (this.dataDoc == null) {
            try {
                this.dataDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 4, CCorePlugin.getResourceString("CDescriptor.extension.internalError"), (Throwable)parserConfigurationException));
            }
            Element element = this.dataDoc.createElement(PROJECT_DATA);
            this.dataDoc.appendChild(element);
        }
        return this.dataDoc;
    }

    private void decodeProjectData(Element element) throws CoreException {
        Document document = this.getProjectDataDoc();
        document.replaceChild(document.importNode(element, true), document.getDocumentElement());
    }

    private void encodeProjectData(Document document, Element element) {
        if (this.dataDoc != null) {
            Element element2 = this.dataDoc.getDocumentElement();
            NodeList nodeList = element2.getElementsByTagName(PROJECT_DATA_ITEM);
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element3 = (Element)nodeList.item(n);
                if (!element3.hasChildNodes()) {
                    element2.removeChild(element3);
                    --n;
                }
                ++n;
            }
            element.appendChild(document.importNode(this.dataDoc.getDocumentElement(), true));
        }
    }

    private String serializeDocument(Document document) throws IOException, TransformerException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toString("UTF8");
    }
}

