/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICDescriptorManager;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.internal.core.CDescriptor;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.COwnerConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class CDescriptorManager
implements ICDescriptorManager,
IResourceChangeListener {
    Map fOperationMap = new HashMap(1);
    Map fDescriptorMap = new HashMap();
    Map fOwnerConfigMap = null;
    List listeners = Collections.synchronizedList(new Vector());
    private static final COwnerConfiguration NULLCOwner = new COwnerConfiguration("", CCorePlugin.getResourceString("CDescriptorManager.internal_owner"));

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void shutdown() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void startup() throws CoreException {
        this.getWorkspace().getRoot().accept(new IResourceVisitor(){

            public boolean visit(IResource iResource) {
                if (iResource.getType() == 4) {
                    IProject iProject = (IProject)iResource;
                    try {
                        if (iProject.isAccessible() && iProject.findMember(".cdtproject") != null) {
                            CDescriptorManager.this.getDescriptor(iProject);
                        }
                    }
                    catch (CoreException coreException) {
                        CCorePlugin.log(coreException);
                    }
                    return false;
                }
                return iResource.getType() == 8;
            }
        });
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 14);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getSource() instanceof IWorkspace) {
            IResource iResource = iResourceChangeEvent.getResource();
            switch (iResourceChangeEvent.getType()) {
                case 2: 
                case 4: {
                    CDescriptor cDescriptor;
                    if (iResource.getType() != 4 || (cDescriptor = (CDescriptor)this.fDescriptorMap.remove(iResource)) == null) break;
                    this.fireEvent(new CDescriptorEvent(cDescriptor, 3, 0));
                    break;
                }
                case 8: {
                    IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                    if (iResourceDelta == null) break;
                    try {
                        iResourceDelta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                                IResource iResource = iResourceDelta.getResource();
                                if (iResource.getType() == 4) {
                                    if ((iResourceDelta.getFlags() & 0x4000) != 0) {
                                        IProject iProject = (IProject)iResource;
                                        if (iProject.isAccessible() && iProject.findMember(".cdtproject") != null && CDescriptorManager.this.fDescriptorMap.get(iProject) == null) {
                                            CDescriptorManager.this.getDescriptor(iProject);
                                        } else {
                                            CDescriptor cDescriptor = (CDescriptor)CDescriptorManager.this.fDescriptorMap.remove(iProject);
                                            if (cDescriptor != null) {
                                                CDescriptorManager.this.fireEvent(new CDescriptorEvent(cDescriptor, 3, 0));
                                            }
                                        }
                                        return false;
                                    }
                                    return true;
                                }
                                if (iResource.getType() == 1) {
                                    if (iResource.getName().equals(".cdtproject")) {
                                        CDescriptor cDescriptor = (CDescriptor)CDescriptorManager.this.fDescriptorMap.get(iResource.getProject());
                                        if (cDescriptor != null) {
                                            if ((iResourceDelta.getKind() & 2) != 0) {
                                                cDescriptor.updateOnDisk();
                                            } else if ((iResourceDelta.getFlags() & 0x100) != 0) {
                                                cDescriptor.updateFromDisk();
                                            }
                                        }
                                        return false;
                                    }
                                    return true;
                                }
                                return iResource.getType() == 8;
                            }
                        });
                        break;
                    }
                    catch (CoreException coreException) {
                        CCorePlugin.log(coreException);
                    }
                }
            }
        }
    }

    private void initializeOwnerConfiguration() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "CProject");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        this.fOwnerConfigMap = new HashMap(iExtensionArray.length);
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName().equalsIgnoreCase("cproject")) {
                    this.fOwnerConfigMap.put(iExtensionArray[n].getUniqueIdentifier(), new COwnerConfiguration(iConfigurationElementArray[n2]));
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    COwnerConfiguration getOwnerConfiguration(String string) {
        COwnerConfiguration cOwnerConfiguration;
        if (string.equals(NULLCOwner.getOwnerID())) {
            return NULLCOwner;
        }
        if (this.fOwnerConfigMap == null) {
            this.initializeOwnerConfiguration();
        }
        if ((cOwnerConfiguration = (COwnerConfiguration)this.fOwnerConfigMap.get(string)) == null) {
            cOwnerConfiguration = new COwnerConfiguration(string, CCorePlugin.getResourceString("CDescriptorManager.owner_not_Installed"));
            this.fOwnerConfigMap.put(string, cOwnerConfiguration);
        }
        return cOwnerConfiguration;
    }

    COwnerConfiguration getOwnerConfiguration(IProject iProject) throws CoreException {
        if (this.fOwnerConfigMap == null) {
            this.initializeOwnerConfiguration();
        }
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        Iterator iterator = this.fOwnerConfigMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            COwnerConfiguration cOwnerConfiguration = (COwnerConfiguration)entry.getValue();
            if (cOwnerConfiguration.getNature() == null || Arrays.asList(stringArray).lastIndexOf(cOwnerConfiguration.getNature()) == -1) continue;
            return cOwnerConfiguration;
        }
        return NULLCOwner;
    }

    public synchronized ICDescriptor getDescriptor(IProject iProject) throws CoreException {
        return this.getDescriptor(iProject, true);
    }

    public synchronized ICDescriptor getDescriptor(IProject iProject, boolean bl) throws CoreException {
        CDescriptor cDescriptor = (CDescriptor)this.fDescriptorMap.get(iProject);
        if (cDescriptor == null) {
            if (bl) {
                cDescriptor = new CDescriptor(this, iProject);
                this.fDescriptorMap.put(iProject, cDescriptor);
            } else {
                IPath iPath;
                IPath iPath2 = iProject.getDescription().getLocation();
                if (iPath2 == null) {
                    iPath2 = Platform.getLocation().append(iProject.getFullPath());
                }
                if ((iPath = iPath2.append(".cdtproject")).toFile().exists()) {
                    cDescriptor = new CDescriptor(this, iProject);
                    this.fDescriptorMap.put(iProject, cDescriptor);
                }
            }
        }
        return cDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(IProject iProject, String string) throws CoreException {
        CDescriptor cDescriptor;
        if (string.equals(NULLCOwner.getOwnerID())) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptorManager.exception.invalid_ownerID"), null);
            throw new CoreException((IStatus)status);
        }
        CDescriptorManager cDescriptorManager = this;
        synchronized (cDescriptorManager) {
            block11: {
                cDescriptor = (CDescriptor)this.fDescriptorMap.get(iProject);
                if (cDescriptor != null) {
                    if (cDescriptor.getProjectOwner().getID().equals(NULLCOwner.getOwnerID())) {
                        cDescriptor = new CDescriptor(this, iProject, new COwner(this.getOwnerConfiguration(string)));
                        break block11;
                    } else {
                        if (!cDescriptor.getProjectOwner().getID().equals(string)) {
                            Status status = new Status(4, "org.eclipse.cdt.core", 1, CCorePlugin.getResourceString("CDescriptorManager.exception.alreadyConfigured"), null);
                            throw new CoreException((IStatus)status);
                        }
                        return;
                    }
                }
                try {
                    cDescriptor = new CDescriptor(this, iProject, string);
                }
                catch (CoreException coreException) {
                    IStatus iStatus = coreException.getStatus();
                    if (iStatus.getCode() != 1) {
                        throw coreException;
                    }
                    cDescriptor = new CDescriptor(this, iProject);
                }
            }
            this.fDescriptorMap.put(iProject, cDescriptor);
        }
        this.fireEvent(new CDescriptorEvent(cDescriptor, 2, 0));
    }

    public void convert(IProject iProject, String string) throws CoreException {
        CDescriptor cDescriptor;
        CDescriptorManager cDescriptorManager = this;
        synchronized (cDescriptorManager) {
            cDescriptor = new CDescriptor(this, iProject, new COwner(this.getOwnerConfiguration(string)));
            this.fDescriptorMap.put(iProject, cDescriptor);
        }
        this.fireEvent(new CDescriptorEvent(cDescriptor, 1, 16));
    }

    public void addDescriptorListener(ICDescriptorListener iCDescriptorListener) {
        this.listeners.add(iCDescriptorListener);
    }

    public void removeDescriptorListener(ICDescriptorListener iCDescriptorListener) {
        this.listeners.remove(iCDescriptorListener);
    }

    protected void fireEvent(final CDescriptorEvent cDescriptorEvent) {
        ICDescriptorListener[] iCDescriptorListenerArray;
        if (this.fOperationMap.containsKey(cDescriptorEvent.getDescriptor())) {
            if (cDescriptorEvent.getType() == 2) {
                this.fOperationMap.put(cDescriptorEvent.getDescriptor(), cDescriptorEvent);
            } else if (cDescriptorEvent.getType() == 3) {
                this.fOperationMap.put(cDescriptorEvent.getDescriptor(), cDescriptorEvent);
            } else {
                CDescriptorEvent cDescriptorEvent2 = (CDescriptorEvent)this.fOperationMap.get(cDescriptorEvent.getDescriptor());
                if (cDescriptorEvent2 == null) {
                    this.fOperationMap.put(cDescriptorEvent.getDescriptor(), cDescriptorEvent);
                } else if ((cDescriptorEvent2.getFlags() & cDescriptorEvent.getFlags()) != cDescriptorEvent.getFlags()) {
                    this.fOperationMap.put(cDescriptorEvent.getDescriptor(), new CDescriptorEvent(cDescriptorEvent.getDescriptor(), cDescriptorEvent.getType(), cDescriptorEvent2.getFlags() | cDescriptorEvent.getFlags()));
                }
            }
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            iCDescriptorListenerArray = this.listeners.toArray(new ICDescriptorListener[this.listeners.size()]);
        }
        int n = 0;
        while (n < iCDescriptorListenerArray.length) {
            final int n2 = n++;
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptorManager.exception.listenerError"), throwable);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    iCDescriptorListenerArray[n2].descriptorChanged(cDescriptorEvent);
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runDescriptorOperation(IProject iProject, ICDescriptorOperation iCDescriptorOperation, IProgressMonitor iProgressMonitor) throws CoreException {
        ICDescriptor iCDescriptor = this.getDescriptor(iProject, false);
        if (iCDescriptor == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, "Project does not have descriptor", null));
        }
        CDescriptorEvent cDescriptorEvent = null;
        ICDescriptor iCDescriptor2 = iCDescriptor;
        synchronized (iCDescriptor2) {
            this.beginOperation(iCDescriptor);
            try {
                iCDescriptorOperation.execute(iCDescriptor, iProgressMonitor);
                Object var7_9 = null;
                cDescriptorEvent = this.endOperation(iCDescriptor);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                cDescriptorEvent = this.endOperation(iCDescriptor);
                throw throwable;
            }
        }
        if (cDescriptorEvent != null) {
            this.fireEvent(cDescriptorEvent);
        }
    }

    private void beginOperation(ICDescriptor iCDescriptor) {
        this.fOperationMap.put(iCDescriptor, null);
    }

    private CDescriptorEvent endOperation(ICDescriptor iCDescriptor) {
        return (CDescriptorEvent)this.fOperationMap.remove(iCDescriptor);
    }

    protected void updateDescriptor(CDescriptor cDescriptor) {
        new CDescriptorUpdater(cDescriptor).schedule();
    }

    class CDescriptorUpdater
    extends Job {
        CDescriptor fDescriptor;

        public CDescriptorUpdater(CDescriptor cDescriptor) {
            super(CCorePlugin.getResourceString("CDescriptorManager.async_updater"));
            this.fDescriptor = cDescriptor;
            this.setPriority(10);
            this.setSystem(true);
            this.setRule((ISchedulingRule)cDescriptor.getProject());
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                this.fDescriptor.save();
            }
            catch (CoreException coreException) {
                return coreException.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

