/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.IOException;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob;
import org.eclipse.cdt.internal.core.browser.util.PathUtil;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexerDependenciesJob
extends IndexerJob {
    private ITypeCache fTypeCache;
    private ITypeSearchScope fScope;

    public IndexerDependenciesJob(IndexManager indexManager, ITypeCache iTypeCache, ITypeSearchScope iTypeSearchScope) {
        super(indexManager, iTypeCache.getProject());
        this.fTypeCache = iTypeCache;
        this.fScope = iTypeSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processIndex(IIndex iIndex, IProject iProject, IProgressMonitor iProgressMonitor) throws InterruptedException {
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(iIndex.getIndexFile());
        try {
            try {
                ((IndexInput)blocksIndexInput).open();
                this.flushDependencies(blocksIndexInput, iProgressMonitor);
                Object var5_5 = null;
            }
            catch (IOException iOException) {
                Object var5_6 = null;
                try {
                    ((IndexInput)blocksIndexInput).close();
                    return false;
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (IOException iOException) {
                return false;
            }
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        ((IndexInput)blocksIndexInput).close();
        return true;
    }

    private void flushDependencies(IndexInput indexInput, IProgressMonitor iProgressMonitor) throws InterruptedException, IOException {
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] iEntryResultArray = indexInput.queryEntriesPrefixedBy(IIndexConstants.INCLUDE_REF);
        if (iEntryResultArray != null) {
            int n = 0;
            while (n < iEntryResultArray.length) {
                int[] nArray;
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult iEntryResult = iEntryResultArray[n];
                IPath iPath = this.getIncludePath(iEntryResult);
                if (this.fScope != null && this.fScope.encloses(iPath) && (nArray = iEntryResult.getFileReferences()) != null) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        if (iProgressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        IndexedFile indexedFile = indexInput.getIndexedFile(nArray[n2]);
                        if (indexedFile != null && indexedFile.getPath() != null) {
                            IPath iPath2 = PathUtil.getWorkspaceRelativePath(indexedFile.getPath());
                            this.fTypeCache.flush(iPath2);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    private IPath getIncludePath(IEntryResult iEntryResult) {
        char[] cArray = iEntryResult.getWord();
        int n = CharOperation.indexOf('/', cArray, 0);
        String string = String.valueOf(CharOperation.subarray(cArray, n + 1, -1));
        return PathUtil.getWorkspaceRelativePath(string);
    }
}

