/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class IndexerJob
implements IJob {
    private IndexManager fIndexManager;
    private IProject fProject;
    private IIndex fProjectIndex = null;
    public static final String FAMILY = "BasicTypeIndexerJob";

    public IndexerJob(IndexManager indexManager, IProject iProject) {
        this.fIndexManager = indexManager;
        this.fProject = iProject;
    }

    public boolean belongsTo(String string) {
        return string == FAMILY;
    }

    public void cancel() {
    }

    public boolean isReadyToRun() {
        if (this.fProjectIndex == null) {
            this.getIndexForProject(this.fProject);
        }
        return true;
    }

    public String toString() {
        return FAMILY;
    }

    protected abstract boolean processIndex(IIndex var1, IProject var2, IProgressMonitor var3) throws InterruptedException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        boolean bl;
        block9: {
            block8: {
                boolean bl2 = false;
                try {
                    try {
                        this.fProjectIndex = this.getIndexForProject(this.fProject);
                        if (this.fProjectIndex == null) {
                            Object var3_3 = null;
                            break block8;
                        }
                        if (iProgressMonitor == null) {
                            iProgressMonitor = new NullProgressMonitor();
                        }
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        iProgressMonitor.beginTask("", 1);
                        bl2 = this.prepareIndex(this.fProjectIndex, this.fProject, iProgressMonitor);
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        iProgressMonitor.worked(1);
                        bl = bl2;
                        break block9;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return false;
        }
        Object var3_4 = null;
        iProgressMonitor.done();
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean prepareIndex(IIndex iIndex, IProject iProject, IProgressMonitor iProgressMonitor) throws InterruptedException {
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (iIndex == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = this.fIndexManager.getMonitorFor(iIndex);
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            block11: {
                readWriteMonitor.enterRead();
                if (!iIndex.hasChanged()) break block11;
                try {
                    try {
                        readWriteMonitor.exitRead();
                        readWriteMonitor.enterWrite();
                        this.fIndexManager.saveIndex(iIndex);
                    }
                    catch (IOException iOException) {
                        Object var5_5 = null;
                        readWriteMonitor.exitWriteEnterRead();
                        Object var7_8 = null;
                        readWriteMonitor.exitRead();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    readWriteMonitor.exitWriteEnterRead();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                    readWriteMonitor.exitWriteEnterRead();
                }
            }
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            boolean bl = this.processIndex(iIndex, iProject, iProgressMonitor);
            Object var7_9 = null;
            readWriteMonitor.exitRead();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
    }

    private IIndex getIndexForProject(IProject iProject) {
        IPath iPath;
        IPath iPath2;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!(iWorkspaceRoot.getProject((iPath2 = iProject.getFullPath()).lastSegment()).exists() || iPath2.segmentCount() <= 1 || (iPath = iWorkspaceRoot.getFile(iPath2).getLocation()) != null && new File(iPath.toOSString()).exists() || new File(iPath2.toOSString()).exists())) {
            return null;
        }
        return this.fIndexManager.getIndex(iPath2, true, false);
    }
}

