/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.IOException;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeInfo;
import org.eclipse.cdt.core.browser.TypeReference;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob;
import org.eclipse.cdt.internal.core.browser.util.PathUtil;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexerTypesJob
extends IndexerJob {
    private ITypeCache fTypeCache;

    public IndexerTypesJob(IndexManager indexManager, ITypeCache iTypeCache, ITypeSearchScope iTypeSearchScope) {
        super(indexManager, iTypeCache.getProject());
        this.fTypeCache = iTypeCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processIndex(IIndex iIndex, IProject iProject, IProgressMonitor iProgressMonitor) throws InterruptedException {
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(iIndex.getIndexFile());
        try {
            try {
                ((IndexInput)blocksIndexInput).open();
                this.updateNamespaces(blocksIndexInput, iProject, iProgressMonitor);
                this.updateTypes(blocksIndexInput, iProject, iProgressMonitor);
                Object var5_5 = null;
            }
            catch (IOException iOException) {
                Object var5_6 = null;
                try {
                    ((IndexInput)blocksIndexInput).close();
                    return false;
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (IOException iOException) {
                return false;
            }
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        ((IndexInput)blocksIndexInput).close();
        return true;
    }

    private void updateNamespaces(IndexInput indexInput, IProject iProject, IProgressMonitor iProgressMonitor) throws InterruptedException, IOException {
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] iEntryResultArray = indexInput.queryEntriesPrefixedBy(IIndexConstants.NAMESPACE_DECL);
        if (iEntryResultArray != null) {
            int n = 0;
            while (n < iEntryResultArray.length) {
                int n2;
                int n3;
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult iEntryResult = iEntryResultArray[n];
                char[] cArray = iEntryResult.getWord();
                String string = String.valueOf(CharOperation.subarray(cArray, (n3 = CharOperation.indexOf('/', cArray, 0)) + 1, n2 = CharOperation.indexOf('/', cArray, n3 + 1)));
                if (string.length() != 0) {
                    String[] stringArray = this.getEnclosingNames(cArray, n2);
                    this.addType(indexInput, iProject, iEntryResult, 61, string, stringArray, iProgressMonitor);
                }
                ++n;
            }
        }
    }

    private void updateTypes(IndexInput indexInput, IProject iProject, IProgressMonitor iProgressMonitor) throws InterruptedException, IOException {
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] iEntryResultArray = indexInput.queryEntriesPrefixedBy(IIndexConstants.TYPE_DECL);
        if (iEntryResultArray != null) {
            int n = 0;
            while (n < iEntryResultArray.length) {
                int n2;
                String string;
                int n3;
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult iEntryResult = iEntryResultArray[n];
                char[] cArray = iEntryResult.getWord();
                char c = cArray[(n3 = CharOperation.indexOf('/', cArray, 0)) + 1];
                int n4 = this.getElementType(c);
                if (n4 != 0 && (string = String.valueOf(CharOperation.subarray(cArray, (n3 += 2) + 1, n2 = CharOperation.indexOf('/', cArray, n3 + 1)))).length() != 0) {
                    String[] stringArray = this.getEnclosingNames(cArray, n2);
                    this.addType(indexInput, iProject, iEntryResult, n4, string, stringArray, iProgressMonitor);
                }
                ++n;
            }
        }
    }

    private int getElementType(char c) {
        switch (c) {
            case 'C': {
                return 64;
            }
            case 'S': {
                return 65;
            }
            case 'T': {
                return 78;
            }
            case 'E': {
                return 63;
            }
            case 'U': {
                return 66;
            }
        }
        return 0;
    }

    private String[] getEnclosingNames(char[] cArray, int n) {
        String[] stringArray = null;
        if (n != -1 && n + 1 < cArray.length) {
            char[][] cArray2 = CharOperation.splitOn('/', CharOperation.subarray(cArray, n + 1, -1));
            stringArray = new String[cArray2.length];
            int n2 = 0;
            while (n2 < cArray2.length) {
                stringArray[n2] = String.valueOf(cArray2[cArray2.length - n2 - 1]);
                ++n2;
            }
        }
        return stringArray;
    }

    private void addType(IndexInput indexInput, IProject iProject, IEntryResult iEntryResult, int n, String string, String[] stringArray, IProgressMonitor iProgressMonitor) throws InterruptedException, IOException {
        int[] nArray;
        QualifiedTypeName qualifiedTypeName = new QualifiedTypeName(string, stringArray);
        ITypeInfo iTypeInfo = this.fTypeCache.getType(n, qualifiedTypeName);
        if ((iTypeInfo == null || iTypeInfo.isUndefinedType()) && (nArray = iEntryResult.getFileReferences()) != null && nArray.length > 0) {
            if (iTypeInfo != null) {
                iTypeInfo.setCElementType(n);
            } else {
                iTypeInfo = new TypeInfo(n, qualifiedTypeName);
                this.fTypeCache.insert(iTypeInfo);
            }
            IndexedFile indexedFile = indexInput.getIndexedFile(nArray[0]);
            if (indexedFile != null && indexedFile.getPath() != null) {
                IPath iPath = PathUtil.getWorkspaceRelativePath(indexedFile.getPath());
                iTypeInfo.addReference(new TypeReference(iPath, iProject));
            }
        }
    }
}

