/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeInfoVisitor;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeInfo;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.internal.core.browser.cache.BasicJob;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheDelta;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacherJob;
import org.eclipse.cdt.internal.core.browser.cache.TypeLocatorJob;
import org.eclipse.cdt.internal.core.browser.util.ArrayUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class TypeCache
implements ITypeCache {
    private static final int INITIAL_TYPE_COUNT = 100;
    private final Map fTypeKeyMap = new HashMap(100);
    private final IProject fProject;
    private final IWorkingCopyProvider fWorkingCopyProvider;
    private final Collection fDeltas = new ArrayList();
    private final ITypeInfo fGlobalNamespace;
    private static final int[] ENCLOSING_TYPES;
    private IJobChangeListener fJobChangeListener = new IJobChangeListener(){

        public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
        }

        public void awake(IJobChangeEvent iJobChangeEvent) {
        }

        public void done(IJobChangeEvent iJobChangeEvent) {
            Job job = iJobChangeEvent.getJob();
            if (job instanceof TypeCacherJob) {
                TypeCacherJob typeCacherJob = (TypeCacherJob)job;
                IStatus iStatus = iJobChangeEvent.getResult();
                if (iStatus != null) {
                    boolean bl = iStatus.equals(Status.OK_STATUS);
                    Collection collection = TypeCache.this.fDeltas;
                    synchronized (collection) {
                        Iterator iterator = TypeCache.this.fDeltas.iterator();
                        while (iterator.hasNext()) {
                            TypeCacheDelta typeCacheDelta = (TypeCacheDelta)iterator.next();
                            if (typeCacheDelta.getJob() == null || !((Object)((Object)typeCacheDelta.getJob())).equals((Object)typeCacherJob)) continue;
                            if (bl) {
                                iterator.remove();
                                continue;
                            }
                            typeCacheDelta.assignToJob(null);
                        }
                    }
                }
            }
        }

        public void running(IJobChangeEvent iJobChangeEvent) {
        }

        public void scheduled(IJobChangeEvent iJobChangeEvent) {
        }

        public void sleeping(IJobChangeEvent iJobChangeEvent) {
        }
    };

    static {
        int[] nArray = new int[4];
        nArray[0] = 61;
        nArray[1] = 64;
        nArray[2] = 65;
        ENCLOSING_TYPES = nArray;
    }

    public TypeCache(IProject iProject, IWorkingCopyProvider iWorkingCopyProvider) {
        this.fProject = iProject;
        this.fWorkingCopyProvider = iWorkingCopyProvider;
        this.fDeltas.add(new TypeCacheDelta(this.fProject));
        this.fGlobalNamespace = new TypeInfo(61, new GlobalNamespace());
        this.fGlobalNamespace.setCache(this);
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        ITypeCache iTypeCache;
        if (this == iSchedulingRule) {
            return true;
        }
        return iSchedulingRule instanceof ITypeCache && this.fProject.equals((Object)(iTypeCache = (ITypeCache)iSchedulingRule).getProject());
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        ITypeCache iTypeCache;
        return iSchedulingRule instanceof ITypeCache && this.fProject.equals((Object)(iTypeCache = (ITypeCache)iSchedulingRule).getProject());
    }

    public IProject getProject() {
        return this.fProject;
    }

    public synchronized boolean isEmpty() {
        return this.fTypeKeyMap.isEmpty();
    }

    public synchronized void insert(ITypeInfo iTypeInfo) {
        IQualifiedTypeName iQualifiedTypeName = iTypeInfo.getQualifiedTypeName().getEnclosingTypeName();
        if (iQualifiedTypeName != null) {
            while (!iQualifiedTypeName.isEmpty()) {
                ITypeInfo iTypeInfo2 = null;
                int n = 0;
                while (iTypeInfo2 == null && n < ENCLOSING_TYPES.length) {
                    iTypeInfo2 = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(iQualifiedTypeName, ENCLOSING_TYPES[n]));
                    ++n;
                }
                if (iTypeInfo2 == null) {
                    TypeInfo typeInfo = new TypeInfo(0, iQualifiedTypeName);
                    typeInfo.setCache(this);
                    this.fTypeKeyMap.put(new HashKey(iQualifiedTypeName, 0), typeInfo);
                }
                iQualifiedTypeName = iQualifiedTypeName.removeLastSegments(1);
            }
        }
        this.fTypeKeyMap.put(new HashKey(iTypeInfo.getQualifiedTypeName(), iTypeInfo.getCElementType()), iTypeInfo);
        iTypeInfo.setCache(this);
    }

    public synchronized void remove(ITypeInfo iTypeInfo) {
        this.fTypeKeyMap.remove(new HashKey(iTypeInfo.getQualifiedTypeName(), iTypeInfo.getCElementType()));
        iTypeInfo.setCache(null);
    }

    public synchronized void flush(ITypeSearchScope iTypeSearchScope) {
        if (iTypeSearchScope.encloses(this.fProject)) {
            this.flushAll();
        } else {
            Iterator iterator = this.fTypeKeyMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ITypeInfo iTypeInfo = (ITypeInfo)entry.getValue();
                if (!iTypeInfo.isEnclosed(iTypeSearchScope)) continue;
                iterator.remove();
            }
        }
    }

    public synchronized void flush(IPath iPath) {
        TypeSearchScope typeSearchScope = new TypeSearchScope();
        typeSearchScope.add(iPath, false, null);
        this.flush(typeSearchScope);
    }

    public synchronized void flushAll() {
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo) {
                iTypeInfo.setCache(null);
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        });
        this.fTypeKeyMap.clear();
    }

    public synchronized void accept(ITypeInfoVisitor iTypeInfoVisitor) {
        Iterator iterator = this.fTypeKeyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ITypeInfo iTypeInfo = (ITypeInfo)entry.getValue();
            if (!iTypeInfoVisitor.shouldContinue()) {
                return;
            }
            iTypeInfoVisitor.visit(iTypeInfo);
        }
    }

    public synchronized IPath[] getPaths(final ITypeSearchScope iTypeSearchScope) {
        final HashSet hashSet = new HashSet();
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo) {
                ITypeReference[] iTypeReferenceArray;
                if ((iTypeSearchScope == null || iTypeInfo.isEnclosed(iTypeSearchScope)) && (iTypeReferenceArray = iTypeInfo.getReferences()) != null) {
                    int n = 0;
                    while (n < iTypeReferenceArray.length) {
                        IPath iPath = iTypeReferenceArray[n].getPath();
                        if (iTypeSearchScope == null || iTypeSearchScope.encloses(iPath)) {
                            hashSet.add(iPath);
                        }
                        ++n;
                    }
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        });
        return hashSet.toArray(new IPath[hashSet.size()]);
    }

    public synchronized ITypeInfo[] getTypes(final ITypeSearchScope iTypeSearchScope) {
        final ArrayList arrayList = new ArrayList();
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo) {
                if (iTypeSearchScope == null || iTypeInfo.isEnclosed(iTypeSearchScope)) {
                    arrayList.add(iTypeInfo);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        });
        return arrayList.toArray(new ITypeInfo[arrayList.size()]);
    }

    public synchronized ITypeInfo[] getTypes(IQualifiedTypeName iQualifiedTypeName) {
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        int n = 0;
        while (n < ITypeInfo.KNOWN_TYPES.length) {
            ITypeInfo iTypeInfo = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(iQualifiedTypeName, ITypeInfo.KNOWN_TYPES[n]));
            if (iTypeInfo != null) {
                arrayList.add(iTypeInfo);
            }
            ++n;
        }
        ITypeInfo iTypeInfo = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(iQualifiedTypeName, 0));
        if (iTypeInfo != null) {
            arrayList.add(iTypeInfo);
        }
        return arrayList.toArray(new ITypeInfo[arrayList.size()]);
    }

    public synchronized ITypeInfo getType(int n, IQualifiedTypeName iQualifiedTypeName) {
        ITypeInfo iTypeInfo = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(iQualifiedTypeName, n));
        if (iTypeInfo == null && n != 0) {
            iTypeInfo = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(iQualifiedTypeName, 0));
        }
        return iTypeInfo;
    }

    public synchronized ITypeInfo getEnclosingType(ITypeInfo iTypeInfo, int[] nArray) {
        IQualifiedTypeName iQualifiedTypeName = iTypeInfo.getQualifiedTypeName().getEnclosingTypeName();
        if (iQualifiedTypeName != null) {
            ITypeInfo iTypeInfo2 = null;
            int n = 0;
            while (iTypeInfo2 == null && n < ENCLOSING_TYPES.length) {
                if (ArrayUtil.contains(nArray, ENCLOSING_TYPES[n])) {
                    iTypeInfo2 = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(iQualifiedTypeName, ENCLOSING_TYPES[n]));
                }
                ++n;
            }
            return iTypeInfo2;
        }
        return null;
    }

    public synchronized ITypeInfo getRootNamespace(ITypeInfo iTypeInfo, boolean bl) {
        IQualifiedTypeName iQualifiedTypeName = iTypeInfo.getQualifiedTypeName();
        if (iQualifiedTypeName.isGlobal()) {
            if (iTypeInfo.getCElementType() == 61) {
                return iTypeInfo;
            }
            if (bl) {
                return this.fGlobalNamespace;
            }
            return null;
        }
        IQualifiedTypeName iQualifiedTypeName2 = iQualifiedTypeName.removeLastSegments(iQualifiedTypeName.segmentCount() - 1);
        ITypeInfo iTypeInfo2 = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(iQualifiedTypeName2, 61));
        if (iTypeInfo2 == null) {
            iTypeInfo2 = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(iQualifiedTypeName2, 0));
        }
        return iTypeInfo2;
    }

    public synchronized boolean hasEnclosedTypes(final ITypeInfo iTypeInfo) {
        final IQualifiedTypeName iQualifiedTypeName = iTypeInfo.getQualifiedTypeName();
        final boolean[] blArray = new boolean[1];
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo2) {
                if (iTypeInfo2 != iTypeInfo && iQualifiedTypeName.isPrefixOf(iTypeInfo2.getQualifiedTypeName())) {
                    blArray[0] = true;
                }
                return true;
            }

            public boolean shouldContinue() {
                return !blArray[0];
            }
        });
        return blArray[0];
    }

    public synchronized ITypeInfo[] getEnclosedTypes(final ITypeInfo iTypeInfo, final int[] nArray) {
        final IQualifiedTypeName iQualifiedTypeName = iTypeInfo.getQualifiedTypeName();
        final ArrayList arrayList = new ArrayList();
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo iTypeInfo2) {
                if (ArrayUtil.contains(nArray, iTypeInfo2.getCElementType())) {
                    IQualifiedTypeName iQualifiedTypeName2 = iTypeInfo2.getQualifiedTypeName().getEnclosingTypeName();
                    if (iTypeInfo == TypeCache.this.fGlobalNamespace) {
                        if (iQualifiedTypeName2 == null) {
                            arrayList.add(iTypeInfo2);
                        }
                    } else if (iQualifiedTypeName.equals(iQualifiedTypeName2)) {
                        arrayList.add(iTypeInfo2);
                    }
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        });
        return arrayList.toArray(new ITypeInfo[arrayList.size()]);
    }

    public ITypeInfo getGlobalNamespace() {
        return this.fGlobalNamespace;
    }

    public boolean isUpToDate() {
        Collection collection = this.fDeltas;
        synchronized (collection) {
            return this.fDeltas.isEmpty();
        }
    }

    public void addDelta(TypeCacheDelta typeCacheDelta) {
        Collection collection = this.fDeltas;
        synchronized (collection) {
            this.fDeltas.add(typeCacheDelta);
        }
    }

    public void reconcile(boolean bl, int n, int n2) {
        TypeCacherJob typeCacherJob;
        Object object;
        if (this.deltasRemaining() == 0) {
            return;
        }
        IJobManager iJobManager = Platform.getJobManager();
        Job[] jobArray = iJobManager.find(TypeCacherJob.FAMILY);
        int n3 = 0;
        while (n3 < jobArray.length) {
            object = (TypeCacherJob)jobArray[n3];
            if (object.getCache().equals(this)) {
                object.cancel();
            }
            ++n3;
        }
        if (this.deltasRemaining() == 0) {
            return;
        }
        object = this.fDeltas;
        synchronized (object) {
            TypeCacheDelta[] typeCacheDeltaArray = this.fDeltas.toArray(new TypeCacheDelta[this.fDeltas.size()]);
            typeCacherJob = new TypeCacherJob(this, typeCacheDeltaArray, bl);
            if (typeCacheDeltaArray != null) {
                int n4 = 0;
                while (n4 < typeCacheDeltaArray.length) {
                    typeCacheDeltaArray[n4].assignToJob(typeCacherJob);
                    ++n4;
                }
            }
        }
        typeCacherJob.addJobChangeListener(this.fJobChangeListener);
        typeCacherJob.setPriority(n);
        typeCacherJob.schedule(n2);
    }

    public void reconcileAndWait(boolean bl, int n, IProgressMonitor iProgressMonitor) {
        this.reconcile(bl, n, 0);
        IJobManager iJobManager = Platform.getJobManager();
        Job[] jobArray = iJobManager.find(TypeCacherJob.FAMILY);
        int n2 = 0;
        while (n2 < jobArray.length) {
            TypeCacherJob typeCacherJob = (TypeCacherJob)jobArray[n2];
            if (typeCacherJob.getCache().equals(this)) {
                try {
                    typeCacherJob.join(iProgressMonitor);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++n2;
        }
    }

    private int deltasRemaining() {
        Collection collection = this.fDeltas;
        synchronized (collection) {
            int n = 0;
            Iterator iterator = this.fDeltas.iterator();
            while (iterator.hasNext()) {
                TypeCacheDelta typeCacheDelta = (TypeCacheDelta)iterator.next();
                TypeCacherJob typeCacherJob = typeCacheDelta.getJob();
                if (typeCacherJob != null && typeCacherJob.isRunning()) continue;
                ++n;
            }
            return n;
        }
    }

    public void cancelJobs() {
        BasicJob basicJob;
        IJobManager iJobManager = Platform.getJobManager();
        Job[] jobArray = iJobManager.find(TypeCacherJob.FAMILY);
        int n = 0;
        while (n < jobArray.length) {
            basicJob = (TypeCacherJob)jobArray[n];
            if (((TypeCacherJob)basicJob).getCache().equals(this)) {
                basicJob.cancel();
            }
            ++n;
        }
        jobArray = iJobManager.find(TypeLocatorJob.FAMILY);
        n = 0;
        while (n < jobArray.length) {
            basicJob = (TypeLocatorJob)jobArray[n];
            if (((TypeLocatorJob)basicJob).getType().getEnclosingProject().equals((Object)this.fProject)) {
                basicJob.cancel();
            }
            ++n;
        }
    }

    public void locateType(ITypeInfo iTypeInfo, int n, int n2) {
        ITypeReference iTypeReference = iTypeInfo.getResolvedReference();
        if (iTypeReference != null) {
            return;
        }
        IJobManager iJobManager = Platform.getJobManager();
        Job[] jobArray = iJobManager.find(TypeLocatorJob.FAMILY);
        int n3 = 0;
        while (n3 < jobArray.length) {
            TypeLocatorJob typeLocatorJob = (TypeLocatorJob)jobArray[n3];
            if (typeLocatorJob.getType().equals(iTypeInfo)) {
                typeLocatorJob.cancel();
            }
            ++n3;
        }
        iTypeReference = iTypeInfo.getResolvedReference();
        if (iTypeReference != null) {
            return;
        }
        TypeLocatorJob typeLocatorJob = new TypeLocatorJob(iTypeInfo, this, this.fWorkingCopyProvider);
        typeLocatorJob.setPriority(n);
        typeLocatorJob.schedule(n2);
    }

    public ITypeReference locateTypeAndWait(ITypeInfo iTypeInfo, int n, IProgressMonitor iProgressMonitor) {
        this.locateType(iTypeInfo, n, 0);
        IJobManager iJobManager = Platform.getJobManager();
        Job[] jobArray = iJobManager.find(TypeLocatorJob.FAMILY);
        int n2 = 0;
        while (n2 < jobArray.length) {
            TypeLocatorJob typeLocatorJob = (TypeLocatorJob)jobArray[n2];
            if (typeLocatorJob.getType().equals(iTypeInfo)) {
                try {
                    typeLocatorJob.join(iProgressMonitor);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++n2;
        }
        return iTypeInfo.getResolvedReference();
    }

    private static class GlobalNamespace
    implements IQualifiedTypeName {
        private static final String GLOBAL_NAMESPACE = TypeCacheMessages.getString("TypeCache.globalNamespace");
        private static final String[] segments = new String[]{GLOBAL_NAMESPACE};

        public String getName() {
            return GLOBAL_NAMESPACE;
        }

        public String[] getEnclosingNames() {
            return null;
        }

        public String getFullyQualifiedName() {
            return GLOBAL_NAMESPACE;
        }

        public IQualifiedTypeName getEnclosingTypeName() {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isGlobal() {
            return true;
        }

        public int segmentCount() {
            return 1;
        }

        public String[] segments() {
            return segments;
        }

        public String segment(int n) {
            if (n > 0) {
                return null;
            }
            return GLOBAL_NAMESPACE;
        }

        public String lastSegment() {
            return GLOBAL_NAMESPACE;
        }

        public int matchingFirstSegments(IQualifiedTypeName iQualifiedTypeName) {
            return 1;
        }

        public boolean isPrefixOf(IQualifiedTypeName iQualifiedTypeName) {
            return true;
        }

        public IQualifiedTypeName append(String[] stringArray) {
            return new QualifiedTypeName(stringArray);
        }

        public IQualifiedTypeName append(IQualifiedTypeName iQualifiedTypeName) {
            return new QualifiedTypeName(iQualifiedTypeName);
        }

        public IQualifiedTypeName append(String string) {
            return new QualifiedTypeName(string);
        }

        public IQualifiedTypeName removeFirstSegments(int n) {
            return this;
        }

        public IQualifiedTypeName removeLastSegments(int n) {
            return this;
        }

        public boolean isLowLevel() {
            return false;
        }

        public boolean validate() {
            return true;
        }

        public int hashCode() {
            return GLOBAL_NAMESPACE.hashCode();
        }

        public String toString() {
            return this.getFullyQualifiedName();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof IQualifiedTypeName)) {
                return false;
            }
            IQualifiedTypeName iQualifiedTypeName = (IQualifiedTypeName)object;
            return iQualifiedTypeName instanceof GlobalNamespace;
        }

        public int compareTo(Object object) {
            if (object == this) {
                return 0;
            }
            if (!(object instanceof IQualifiedTypeName)) {
                throw new ClassCastException();
            }
            IQualifiedTypeName iQualifiedTypeName = (IQualifiedTypeName)object;
            return this.getFullyQualifiedName().compareTo(iQualifiedTypeName.getFullyQualifiedName());
        }
    }

    private static class HashKey {
        private IQualifiedTypeName name;
        private int type;

        public HashKey(IQualifiedTypeName iQualifiedTypeName, int n) {
            this.name = iQualifiedTypeName;
            this.type = n;
        }

        public int hashCode() {
            return this.name.hashCode() + this.type;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof HashKey)) {
                return false;
            }
            HashKey hashKey = (HashKey)object;
            return this.type == hashKey.type && this.name.equals(hashKey.name);
        }
    }
}

