/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheDelta;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacherJob;
import org.eclipse.cdt.internal.core.browser.cache.TypeLocatorJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;

public class TypeCacheManager {
    private Map fCacheMap = new HashMap();
    private IWorkingCopyProvider fWorkingCopyProvider;
    private static final int PATH_ENTRY_FLAGS = 265984;

    public TypeCacheManager(IWorkingCopyProvider iWorkingCopyProvider) {
        this.fWorkingCopyProvider = iWorkingCopyProvider;
    }

    public synchronized void updateProject(IProject iProject) {
        TypeCacheDelta typeCacheDelta = new TypeCacheDelta(iProject);
        this.getCache(iProject).addDelta(typeCacheDelta);
    }

    public synchronized void processDelta(ICElementDelta iCElementDelta) {
        ICElementDelta[] iCElementDeltaArray;
        ICElement iCElement = iCElementDelta.getElement();
        boolean bl = iCElementDelta.getKind() == 1;
        boolean bl2 = iCElementDelta.getKind() == 2;
        boolean bl3 = (iCElementDelta.getFlags() & 1) != 0;
        boolean bl4 = (iCElementDelta.getFlags() & 0x40F00) != 0;
        boolean bl5 = (iCElementDelta.getFlags() & 8) != 0;
        switch (iCElement.getElementType()) {
            case 11: 
            case 12: {
                iCElementDeltaArray = iCElement.getCProject();
                IProject iProject = iCElementDeltaArray.getProject();
                if (!bl && !bl2 && !bl4) break;
                Object object = new TypeCacheDelta(iProject, iCElementDelta);
                this.getCache(iProject).addDelta((TypeCacheDelta)object);
                break;
            }
            case 60: {
                iCElementDeltaArray = iCElement.getCProject();
                IProject iProject = iCElementDeltaArray.getProject();
                Object object = (ITranslationUnit)iCElement;
                if (object.isWorkingCopy()) {
                    this.processWorkingCopyDelta(iCElementDelta);
                    return;
                }
                if (!bl && !bl2 && !bl4 && !bl3) break;
                TypeCacheDelta typeCacheDelta = new TypeCacheDelta(iProject, iCElementDelta);
                this.getCache(iProject).addDelta(typeCacheDelta);
                break;
            }
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 72: 
            case 73: 
            case 78: {
                iCElementDeltaArray = iCElement.getCProject();
                IProject iProject = iCElementDeltaArray.getProject();
                if (!bl && !bl2) break;
                Object object = new TypeCacheDelta(iProject, iCElementDelta);
                this.getCache(iProject).addDelta((TypeCacheDelta)object);
            }
        }
        if (bl5 && (iCElementDeltaArray = iCElementDelta.getAffectedChildren()) != null) {
            int n = 0;
            while (n < iCElementDeltaArray.length) {
                this.processDelta(iCElementDeltaArray[n]);
                ++n;
            }
        }
    }

    public synchronized void processWorkingCopyDelta(ICElementDelta iCElementDelta) {
    }

    public synchronized ITypeCache getCache(IProject iProject) {
        Map map = this.fCacheMap;
        synchronized (map) {
            ITypeCache iTypeCache = (ITypeCache)this.fCacheMap.get(iProject);
            if (iTypeCache == null) {
                iTypeCache = new TypeCache(iProject, this.fWorkingCopyProvider);
                this.fCacheMap.put(iProject, iTypeCache);
            }
            return iTypeCache;
        }
    }

    public synchronized void reconcile(boolean bl, int n, int n2) {
        TypeSearchScope typeSearchScope = new TypeSearchScope(true);
        IProject[] iProjectArray = typeSearchScope.getEnclosingProjects();
        int n3 = 0;
        while (n3 < iProjectArray.length) {
            ITypeCache iTypeCache = this.getCache(iProjectArray[n3]);
            iTypeCache.reconcile(bl, n, n2);
            ++n3;
        }
    }

    public synchronized void reconcileAndWait(boolean bl, int n, IProgressMonitor iProgressMonitor) {
        TypeSearchScope typeSearchScope = new TypeSearchScope(true);
        IProject[] iProjectArray = typeSearchScope.getEnclosingProjects();
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            ITypeCache iTypeCache = this.getCache(iProjectArray[n2]);
            iTypeCache.reconcileAndWait(bl, n, iProgressMonitor);
            ++n2;
        }
    }

    public void cancelJobs() {
        IJobManager iJobManager = Platform.getJobManager();
        iJobManager.cancel(TypeCacherJob.FAMILY);
        iJobManager.cancel(TypeLocatorJob.FAMILY);
    }
}

