/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.internal.core.browser.cache.BasicJob;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerDependenciesJob;
import org.eclipse.cdt.internal.core.browser.cache.IndexerTypesJob;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheDelta;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TypeCacherJob
extends BasicJob {
    public static final Object FAMILY = new Object();
    private IndexManager fIndexManager;
    private ITypeCache fTypeCache;
    private TypeCacheDelta[] fDeltas;
    private boolean fEnableIndexing;
    private static final int PATH_ENTRY_FLAGS = 265984;

    public TypeCacherJob(ITypeCache iTypeCache, TypeCacheDelta[] typeCacheDeltaArray, boolean bl) {
        super(TypeCacheMessages.getString("TypeCacherJob.defaultJobName"), FAMILY);
        this.fTypeCache = iTypeCache;
        this.fDeltas = typeCacheDeltaArray;
        this.fEnableIndexing = bl;
        this.fIndexManager = CModelManager.getDefault().getIndexManager();
        this.setPriority(40);
        this.setSystem(true);
        this.setRule(iTypeCache);
        this.setName(TypeCacheMessages.getFormattedString("TypeCacherJob.jobName", this.fTypeCache.getProject().getName()));
    }

    public ITypeCache getCache() {
        return this.fTypeCache;
    }

    public TypeCacheDelta[] getDeltas() {
        return this.fDeltas;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus runWithDelegatedProgress(IProgressMonitor iProgressMonitor) throws InterruptedException {
        boolean bl = false;
        long l = System.currentTimeMillis();
        BasicJob.trace("TypeCacherJob: started");
        try {
            TypeCacheDelta typeCacheDelta;
            int n;
            int n2 = 100;
            iProgressMonitor.beginTask(TypeCacheMessages.getString("TypeCacherJob.taskName"), n2);
            TypeSearchScope typeSearchScope = new TypeSearchScope();
            if (this.fDeltas != null) {
                n = 0;
                while (n < this.fDeltas.length) {
                    typeCacheDelta = this.fDeltas[n];
                    this.prepareToFlush(typeCacheDelta, typeSearchScope);
                    ++n;
                }
            }
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            n = 0;
            if (!typeSearchScope.isEmpty()) {
                n = n2 / 4;
                typeCacheDelta = new SubProgressMonitor(iProgressMonitor, n);
                this.flush(typeSearchScope, (IProgressMonitor)typeCacheDelta);
            }
            typeCacheDelta = new SubProgressMonitor(iProgressMonitor, n2 - n);
            this.update(typeSearchScope, (IProgressMonitor)typeCacheDelta);
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            long l2 = System.currentTimeMillis() - l;
            if (bl) {
                BasicJob.trace("TypeCacherJob: completed (" + l2 + " ms)");
            } else {
                BasicJob.trace("TypeCacherJob: aborted (" + l2 + " ms)");
            }
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var9_10 = null;
        }
        long l3 = System.currentTimeMillis() - l;
        if (bl) {
            BasicJob.trace("TypeCacherJob: completed (" + l3 + " ms)");
        } else {
            BasicJob.trace("TypeCacherJob: aborted (" + l3 + " ms)");
        }
        iProgressMonitor.done();
        return Status.OK_STATUS;
    }

    private void flush(ITypeSearchScope iTypeSearchScope, IProgressMonitor iProgressMonitor) throws InterruptedException {
        boolean bl = true;
        IProject iProject = this.fTypeCache.getProject();
        iProgressMonitor.beginTask("", 100);
        this.fTypeCache.flush(iTypeSearchScope);
        if (!iTypeSearchScope.encloses(iProject) && iProject.exists() && iProject.isOpen()) {
            bl = false;
            if (this.fEnableIndexing) {
                bl = this.fIndexManager.performConcurrentJob(new IndexerDependenciesJob(this.fIndexManager, this.fTypeCache, iTypeSearchScope), 3, iProgressMonitor, null);
            }
        }
        if (!bl || iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        iProgressMonitor.done();
    }

    private void update(ITypeSearchScope iTypeSearchScope, IProgressMonitor iProgressMonitor) throws InterruptedException {
        boolean bl = true;
        IProject iProject = this.fTypeCache.getProject();
        iProgressMonitor.beginTask("", 100);
        if (iProject.exists() && iProject.isOpen()) {
            bl = false;
            if (this.fEnableIndexing) {
                bl = this.fIndexManager.performConcurrentJob(new IndexerTypesJob(this.fIndexManager, this.fTypeCache, iTypeSearchScope), 3, iProgressMonitor, null);
            }
        }
        if (!bl || iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        iProgressMonitor.done();
    }

    private void prepareToFlush(TypeCacheDelta typeCacheDelta, ITypeSearchScope iTypeSearchScope) {
        ICElementDelta iCElementDelta;
        ITypeSearchScope iTypeSearchScope2 = typeCacheDelta.getScope();
        if (iTypeSearchScope2 != null) {
            iTypeSearchScope.add(iTypeSearchScope2);
        }
        if ((iCElementDelta = typeCacheDelta.getCElementDelta()) != null) {
            ICElement iCElement = iCElementDelta.getElement();
            boolean bl = iCElementDelta.getKind() == 1;
            boolean bl2 = iCElementDelta.getKind() == 2;
            boolean bl3 = (iCElementDelta.getFlags() & 1) != 0;
            boolean bl4 = (iCElementDelta.getFlags() & 0x40F00) != 0;
            switch (iCElement.getElementType()) {
                case 10: {
                    if (!bl && !bl2) break;
                    iTypeSearchScope.add(iCElement);
                    break;
                }
                case 11: {
                    if (!bl && !bl2 && !bl4) break;
                    iTypeSearchScope.add(iCElement);
                    break;
                }
                case 12: {
                    if (!bl && !bl2 && !bl4) break;
                    iTypeSearchScope.add(iCElement);
                    break;
                }
                case 60: {
                    if (!bl && !bl2 && !bl4 && !bl3) break;
                    iTypeSearchScope.add(iCElement);
                    break;
                }
                case 61: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 72: 
                case 73: 
                case 78: {
                    if (!bl && !bl2) break;
                    iTypeSearchScope.add(iCElement);
                }
            }
        }
    }
}

