/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.internal.core.browser.cache.BasicJob;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.browser.cache.TypeParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TypeLocatorJob
extends BasicJob {
    public static final Object FAMILY = new Object();
    private ITypeInfo fLocateType;
    private ITypeCache fTypeCache;
    private IWorkingCopyProvider fWorkingCopyProvider;

    public TypeLocatorJob(ITypeInfo iTypeInfo, ITypeCache iTypeCache, IWorkingCopyProvider iWorkingCopyProvider) {
        super(TypeCacheMessages.getString("TypeLocatorJob.jobName"), FAMILY);
        this.fLocateType = iTypeInfo;
        this.fTypeCache = iTypeCache;
        this.fWorkingCopyProvider = iWorkingCopyProvider;
    }

    public ITypeInfo getType() {
        return this.fLocateType;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus runWithDelegatedProgress(IProgressMonitor iProgressMonitor) throws InterruptedException {
        boolean bl = false;
        long l = System.currentTimeMillis();
        BasicJob.trace("TypeLocatorJob: started");
        try {
            iProgressMonitor.beginTask(TypeCacheMessages.getString("TypeLocatorJob.taskName"), 100);
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            TypeParser typeParser = new TypeParser(this.fTypeCache, this.fWorkingCopyProvider);
            bl = typeParser.findType(this.fLocateType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            long l2 = System.currentTimeMillis() - l;
            if (bl) {
                BasicJob.trace("TypeLocatorJob: completed (" + l2 + " ms)");
            } else {
                BasicJob.trace("TypeLocatorJob: aborted (" + l2 + " ms)");
            }
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_7 = null;
        }
        long l3 = System.currentTimeMillis() - l;
        if (bl) {
            BasicJob.trace("TypeLocatorJob: completed (" + l3 + " ms)");
        } else {
            BasicJob.trace("TypeLocatorJob: aborted (" + l3 + " ms)");
        }
        iProgressMonitor.done();
        return Status.OK_STATUS;
    }
}

