/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;

public class DelegatedProgressMonitor
implements IProgressMonitor,
IProgressMonitorWithBlocking {
    private static int INITIAL_DELEGATE_COUNT = 2;
    private final ArrayList fDelegateList = new ArrayList(INITIAL_DELEGATE_COUNT);
    private String fTaskName;
    private String fSubTask;
    private int fTotalWork;
    private double fWorked;
    private boolean fIsBlocked;
    private boolean fIsCanceled;

    public DelegatedProgressMonitor() {
        this.init();
    }

    public DelegatedProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.init();
        this.addDelegate(iProgressMonitor);
    }

    public synchronized void init() {
        this.fTaskName = null;
        this.fSubTask = null;
        this.fTotalWork = -1;
        this.fWorked = 0.0;
        this.fIsBlocked = false;
        this.fIsCanceled = false;
    }

    public synchronized void beginTask(String string, int n) {
        this.fTaskName = string;
        this.fTotalWork = n;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(DelegatedProgressMonitor.this.fTaskName, DelegatedProgressMonitor.this.fTotalWork);
            }
        });
    }

    public synchronized void done() {
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.done();
            }
        });
    }

    public synchronized void setTaskName(String string) {
        this.fTaskName = string;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.setTaskName(DelegatedProgressMonitor.this.fTaskName);
            }
        });
    }

    public synchronized void subTask(String string) {
        this.fSubTask = string;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.subTask(DelegatedProgressMonitor.this.fSubTask);
            }
        });
    }

    public void worked(int n) {
        this.internalWorked(n);
    }

    public synchronized void internalWorked(double d) {
        this.fWorked += d;
        final double d2 = d;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.internalWorked(d2);
            }
        });
    }

    public synchronized boolean isCanceled() {
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                DelegatedProgressMonitor delegatedProgressMonitor = DelegatedProgressMonitor.this;
                delegatedProgressMonitor.fIsCanceled = delegatedProgressMonitor.fIsCanceled | iProgressMonitor.isCanceled();
            }
        });
        return this.fIsCanceled;
    }

    public synchronized void setCanceled(boolean bl) {
        this.fIsCanceled = bl;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.setCanceled(DelegatedProgressMonitor.this.fIsCanceled);
            }
        });
    }

    public synchronized void setBlocked(IStatus iStatus) {
        this.fIsBlocked = true;
        final IStatus iStatus2 = iStatus;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                if (iProgressMonitor instanceof IProgressMonitorWithBlocking) {
                    ((IProgressMonitorWithBlocking)iProgressMonitor).setBlocked(iStatus2);
                }
            }
        });
    }

    public synchronized void clearBlocked() {
        this.fIsBlocked = false;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor iProgressMonitor) {
                if (iProgressMonitor instanceof IProgressMonitorWithBlocking) {
                    ((IProgressMonitorWithBlocking)iProgressMonitor).clearBlocked();
                }
            }
        });
    }

    public synchronized void addDelegate(IProgressMonitor iProgressMonitor) {
        if (this.fDelegateList.indexOf(iProgressMonitor) == -1) {
            if (this.fTaskName != null) {
                this.syncUp(iProgressMonitor);
            }
            this.fDelegateList.add(iProgressMonitor);
        }
    }

    private void syncUp(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(this.fTaskName, this.fTotalWork);
        iProgressMonitor.internalWorked(this.fWorked);
        if (this.fSubTask != null && this.fSubTask.length() > 0) {
            iProgressMonitor.subTask(this.fSubTask);
        }
        if (this.fIsBlocked && iProgressMonitor instanceof IProgressMonitorWithBlocking) {
            ((IProgressMonitorWithBlocking)iProgressMonitor).setBlocked(null);
        }
    }

    public synchronized void removeDelegate(IProgressMonitor iProgressMonitor) {
        int n = this.fDelegateList.indexOf(iProgressMonitor);
        if (n != -1) {
            this.fDelegateList.remove(n);
        }
    }

    public synchronized void removeAllDelegates() {
        this.fDelegateList.clear();
    }

    public synchronized IProgressMonitor[] getDelegates() {
        return (IProgressMonitor[])this.fDelegateList.toArray();
    }

    private void visitDelegates(IDelegateVisitor iDelegateVisitor) {
        ArrayList arrayList = (ArrayList)this.fDelegateList.clone();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IProgressMonitor iProgressMonitor = (IProgressMonitor)iterator.next();
            iDelegateVisitor.visit(iProgressMonitor);
        }
    }

    private static interface IDelegateVisitor {
        public void visit(IProgressMonitor var1);
    }
}

