/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathUtil {
    private static boolean fGotOS = false;
    private static boolean fIsWindows = false;

    public static boolean isWindowsSystem() {
        if (!fGotOS) {
            String string = System.getProperty("os.name");
            if (string != null && string.startsWith("Win")) {
                fIsWindows = true;
            }
            fGotOS = true;
        }
        return fIsWindows;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace != null) {
            return iWorkspace.getRoot();
        }
        return null;
    }

    public static IPath getCanonicalPath(String string) {
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            return new Path(string2);
        }
        catch (IOException iOException) {
            return new Path(string);
        }
    }

    public static IPath getCanonicalPath(IPath iPath) {
        return PathUtil.getCanonicalPath(iPath.toString());
    }

    public static IPath getWorkspaceRelativePath(IPath iPath) {
        IPath iPath2;
        IWorkspaceRoot iWorkspaceRoot = PathUtil.getWorkspaceRoot();
        if (iWorkspaceRoot != null && (iPath2 = iWorkspaceRoot.getLocation()) != null && iPath2.isPrefixOf(iPath)) {
            int n = iPath.matchingFirstSegments(iPath2);
            IPath iPath3 = iPath.setDevice(null).removeFirstSegments(n);
            return new Path("").addTrailingSeparator().append(iPath3);
        }
        return iPath;
    }

    public static IPath getProjectRelativePath(IPath iPath, IProject iProject) {
        IPath iPath2 = iProject.getFullPath();
        if (iPath2.isPrefixOf(iPath)) {
            return iPath.removeFirstSegments(iPath2.segmentCount());
        }
        iPath2 = iProject.getLocation();
        if (iPath2.isPrefixOf(iPath)) {
            return iPath.removeFirstSegments(iPath2.segmentCount());
        }
        return PathUtil.getWorkspaceRelativePath(iPath);
    }

    public static IPath getWorkspaceRelativePath(String string) {
        return PathUtil.getWorkspaceRelativePath((IPath)new Path(string));
    }

    public static IPath getProjectRelativePath(String string, IProject iProject) {
        return PathUtil.getProjectRelativePath((IPath)new Path(string), iProject);
    }

    public static IPath getRawLocation(IPath iPath) {
        IPath iPath2;
        IWorkspaceRoot iWorkspaceRoot = PathUtil.getWorkspaceRoot();
        if (iWorkspaceRoot != null && iPath != null && (iPath2 = iWorkspaceRoot.getLocation()) != null && !iPath2.isPrefixOf(iPath)) {
            return iPath2.append(iPath);
        }
        return iPath;
    }
}

