/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.util;

import java.util.ArrayList;

public class SimpleStack {
    private static int INITIAL_STACK_SIZE = 10;
    private ArrayList items;
    private static boolean VERBOSE = false;

    public SimpleStack() {
        this.items = new ArrayList(INITIAL_STACK_SIZE);
    }

    public SimpleStack(int n) {
        this.items = new ArrayList(n);
    }

    public void clear() {
        this.items.clear();
    }

    public Object push(Object object) {
        this.items.add(object);
        if (VERBOSE) {
            SimpleStack.trace("push on stack: " + object);
        }
        return object;
    }

    public Object pop() {
        int n = this.items.size() - 1;
        if (n < 0) {
            return null;
        }
        Object e = this.items.get(n);
        this.items.remove(n);
        if (VERBOSE) {
            SimpleStack.trace("pop from stack: " + e);
        }
        return e;
    }

    public Object top() {
        int n = this.items.size() - 1;
        if (n < 0) {
            return null;
        }
        return this.items.get(n);
    }

    public Object bottom() {
        if (this.items.size() == 0) {
            return null;
        }
        return this.items.get(0);
    }

    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.items.toArray(objectArray);
    }

    private static void trace(String string) {
        System.out.println("(" + Thread.currentThread() + ") " + string);
    }
}

