/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.Block;
import org.eclipse.cdt.internal.core.index.impl.EntryResult;
import org.eclipse.cdt.internal.core.index.impl.FileListBlock;
import org.eclipse.cdt.internal.core.index.impl.GammaCompressedIndexBlock;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexBlock;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexSummary;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.SafeRandomAccessFile;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;
import org.eclipse.cdt.internal.core.search.HashtableOfInt;
import org.eclipse.cdt.internal.core.util.LRUCache;

public class BlocksIndexInput
extends IndexInput {
    public static final int CACHE_SIZE = 16;
    protected FileListBlock currentFileListBlock;
    protected int currentFileListBlockNum;
    protected int currentIndexBlockNum;
    protected int currentIncludeBlockNum;
    protected IndexBlock currentIndexBlock;
    protected IndexBlock currentIncludeIndexBlock;
    private RandomAccessFile raf;
    protected File indexFile;
    protected LRUCache blockCache;
    protected boolean opened = false;
    protected IndexSummary summary;

    public BlocksIndexInput(File file) {
        this.indexFile = file;
        this.blockCache = new LRUCache(16);
    }

    public void clearCache() {
        this.blockCache = new LRUCache(16);
    }

    public void close() throws IOException {
        if (this.opened) {
            this.summary = null;
            this.opened = false;
            if (this.raf != null) {
                this.raf.close();
            }
        }
    }

    public IndexedFile getCurrentFile() throws IOException {
        if (!this.hasMoreFiles()) {
            return null;
        }
        IndexedFile indexedFile = null;
        indexedFile = this.currentFileListBlock.getFile(this.filePosition);
        if (indexedFile == null) {
            this.currentFileListBlockNum = this.summary.getBlockNumForFileNum(this.filePosition);
            this.currentFileListBlock = this.getFileListBlock(this.currentFileListBlockNum);
            indexedFile = this.currentFileListBlock.getFile(this.filePosition);
        }
        return indexedFile;
    }

    protected WordEntry getEntry(char[] cArray) throws IOException {
        int n = this.summary.getBlockNumForWord(cArray);
        if (n == -1) {
            return null;
        }
        IndexBlock indexBlock = this.getIndexBlock(n);
        return indexBlock.findExactEntry(cArray);
    }

    protected FileListBlock getFileListBlock(int n) throws IOException {
        Integer n2 = new Integer(n);
        Block block = (Block)this.blockCache.get(n2);
        if (block != null && block instanceof FileListBlock) {
            return (FileListBlock)block;
        }
        FileListBlock fileListBlock = new FileListBlock(8192);
        fileListBlock.read(this.raf, n);
        this.blockCache.put(n2, fileListBlock);
        return fileListBlock;
    }

    protected IndexBlock getIndexBlock(int n) throws IOException {
        Integer n2 = new Integer(n);
        Block block = (Block)this.blockCache.get(n2);
        if (block != null && block instanceof IndexBlock) {
            return (IndexBlock)block;
        }
        GammaCompressedIndexBlock gammaCompressedIndexBlock = new GammaCompressedIndexBlock(8192);
        gammaCompressedIndexBlock.read(this.raf, n);
        this.blockCache.put(n2, gammaCompressedIndexBlock);
        return gammaCompressedIndexBlock;
    }

    public IndexedFile getIndexedFile(int n) throws IOException {
        int n2 = this.summary.getBlockNumForFileNum(n);
        if (n2 == -1) {
            return null;
        }
        FileListBlock fileListBlock = this.getFileListBlock(n2);
        return fileListBlock.getFile(n);
    }

    public IndexedFile getIndexedFile(IDocument iDocument) throws IOException {
        this.setFirstFile();
        String string = iDocument.getName();
        while (this.hasMoreFiles()) {
            IndexedFile indexedFile = this.getCurrentFile();
            String string2 = indexedFile.getPath();
            if (string2.equals(string)) {
                return indexedFile;
            }
            this.moveToNextFile();
        }
        return null;
    }

    protected int[] getMatchingFileNumbers(char[] cArray) throws IOException {
        int n = this.summary.getBlockNumForWord(cArray);
        if (n == -1) {
            return new int[0];
        }
        IndexBlock indexBlock = this.getIndexBlock(n);
        WordEntry wordEntry = indexBlock.findExactEntry(cArray);
        return wordEntry == null ? new int[]{} : wordEntry.getRefs();
    }

    public int getNumFiles() {
        return this.summary.getNumFiles();
    }

    public int getNumWords() {
        return this.summary.getNumWords();
    }

    public int getNumIncludes() {
        return this.summary.getNumIncludes();
    }

    public Object getSource() {
        return this.indexFile;
    }

    protected void init() throws IOException {
        this.clearCache();
        this.setFirstFile();
        this.setFirstWord();
        this.setFirstInclude();
    }

    public void moveToNextFile() throws IOException {
        ++this.filePosition;
    }

    public void moveToNextWordEntry() throws IOException {
        boolean bl;
        ++this.wordPosition;
        if (!this.hasMoreWords()) {
            return;
        }
        boolean bl2 = bl = !this.currentIndexBlock.nextEntry(this.currentWordEntry);
        if (bl) {
            this.currentIndexBlock = this.getIndexBlock(++this.currentIndexBlockNum);
            this.currentIndexBlock.nextEntry(this.currentWordEntry);
        }
    }

    public void open() throws IOException {
        if (!this.opened) {
            this.raf = new SafeRandomAccessFile(this.indexFile, "r");
            String string = this.raf.readUTF();
            if (!string.equals("INDEX FILE 0.014")) {
                throw new IOException(Util.bind("exception.wrongFormat"));
            }
            int n = this.raf.readInt();
            this.raf.seek((long)n * 8192L);
            this.summary = new IndexSummary();
            this.summary.read(this.raf);
            this.init();
            this.opened = true;
        }
    }

    public IQueryResult[] query(String string) throws IOException {
        this.open();
        int[] nArray = this.getMatchingFileNumbers(string.toCharArray());
        int n = nArray.length;
        IQueryResult[] iQueryResultArray = new IQueryResult[n];
        int n2 = 0;
        while (n2 < n) {
            iQueryResultArray[n2] = this.getIndexedFile(nArray[n2]);
            ++n2;
        }
        return iQueryResultArray;
    }

    public IEntryResult[] queryEntriesMatching(char[] cArray) throws IOException {
        this.open();
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        int[] nArray = null;
        int n = CharOperation.indexOf('*', cArray);
        switch (n) {
            case -1: {
                WordEntry wordEntry = this.getEntry(cArray);
                if (wordEntry == null) {
                    return null;
                }
                return new IEntryResult[]{new EntryResult(wordEntry.getWord(), wordEntry.getRefs())};
            }
            case 0: {
                nArray = this.summary.getAllBlockNums();
                break;
            }
            default: {
                char[] cArray2 = CharOperation.subarray(cArray, 0, n);
                nArray = this.summary.getBlockNumsForPrefix(cArray2);
            }
        }
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        IEntryResult[] iEntryResultArray = new IEntryResult[5];
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray.length;
        while (n3 < n4) {
            IndexBlock indexBlock = this.getIndexBlock(nArray[n3]);
            indexBlock.reset();
            boolean bl = false;
            WordEntry wordEntry = new WordEntry();
            while (indexBlock.nextEntry(wordEntry)) {
                if (CharOperation.match(wordEntry.getWord(), cArray, true)) {
                    if (n2 == iEntryResultArray.length) {
                        IEntryResult[] iEntryResultArray2 = iEntryResultArray;
                        iEntryResultArray = new IEntryResult[n2 * 2];
                        System.arraycopy(iEntryResultArray2, 0, iEntryResultArray, 0, n2);
                    }
                    iEntryResultArray[n2++] = new EntryResult(wordEntry.getWord(), wordEntry.getRefs());
                    bl = true;
                    continue;
                }
                if (bl) break;
            }
            ++n3;
        }
        if (n2 != iEntryResultArray.length) {
            IEntryResult[] iEntryResultArray3 = iEntryResultArray;
            iEntryResultArray = new IEntryResult[n2];
            System.arraycopy(iEntryResultArray3, 0, iEntryResultArray, 0, n2);
        }
        return iEntryResultArray;
    }

    public IEntryResult[] queryEntriesPrefixedBy(char[] cArray) throws IOException {
        this.open();
        int n = this.summary.getFirstBlockLocationForPrefix(cArray);
        if (n < 0) {
            return null;
        }
        IEntryResult[] iEntryResultArray = new IEntryResult[5];
        int n2 = 0;
        while (n >= 0) {
            IndexBlock indexBlock = this.getIndexBlock(this.summary.getBlockNum(n));
            indexBlock.reset();
            boolean bl = false;
            WordEntry wordEntry = new WordEntry();
            while (indexBlock.nextEntry(wordEntry)) {
                if (CharOperation.prefixEquals(cArray, wordEntry.getWord())) {
                    if (n2 == iEntryResultArray.length) {
                        IEntryResult[] iEntryResultArray2 = iEntryResultArray;
                        iEntryResultArray = new IEntryResult[n2 * 2];
                        System.arraycopy(iEntryResultArray2, 0, iEntryResultArray, 0, n2);
                    }
                    iEntryResultArray[n2++] = new EntryResult(wordEntry.getWord(), wordEntry.getRefs());
                    bl = true;
                    continue;
                }
                if (bl) break;
            }
            n = this.summary.getNextBlockLocationForPrefix(cArray, n);
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 != iEntryResultArray.length) {
            IEntryResult[] iEntryResultArray3 = iEntryResultArray;
            iEntryResultArray = new IEntryResult[n2];
            System.arraycopy(iEntryResultArray3, 0, iEntryResultArray, 0, n2);
        }
        return iEntryResultArray;
    }

    public IQueryResult[] queryFilesReferringToPrefix(char[] cArray) throws IOException {
        int n;
        Object object;
        this.open();
        int n2 = this.summary.getFirstBlockLocationForPrefix(cArray);
        if (n2 < 0) {
            return null;
        }
        HashtableOfInt hashtableOfInt = new HashtableOfInt(20);
        int n3 = 0;
        while (n2 >= 0) {
            object = this.getIndexBlock(this.summary.getBlockNum(n2));
            ((IndexBlock)object).reset();
            boolean bl = false;
            WordEntry wordEntry = new WordEntry();
            while (((IndexBlock)object).nextEntry(wordEntry)) {
                if (CharOperation.prefixEquals(cArray, wordEntry.getWord())) {
                    int[] nArray = wordEntry.getRefs();
                    n = 0;
                    int n4 = nArray.length;
                    while (n < n4) {
                        int n5 = nArray[n];
                        if (!hashtableOfInt.containsKey(n5)) {
                            ++n3;
                            hashtableOfInt.put(n5, this.getIndexedFile(n5));
                        }
                        ++n;
                    }
                    bl = true;
                    continue;
                }
                if (bl) break;
            }
            n2 = this.summary.getNextBlockLocationForPrefix(cArray, n2);
        }
        object = new IQueryResult[n3];
        Object[] objectArray = hashtableOfInt.valueTable;
        int n6 = 0;
        int n7 = 0;
        n = objectArray.length;
        while (n6 < n) {
            IndexedFile indexedFile = (IndexedFile)objectArray[n6];
            if (indexedFile != null) {
                object[n7++] = indexedFile;
            }
            ++n6;
        }
        return object;
    }

    public IQueryResult[] queryInDocumentNames(String string) throws IOException {
        IQueryResult[] iQueryResultArray;
        this.open();
        ArrayList<IQueryResult[]> arrayList = new ArrayList<IQueryResult[]>();
        this.setFirstFile();
        while (this.hasMoreFiles()) {
            iQueryResultArray = this.getCurrentFile();
            if (iQueryResultArray.getPath().indexOf(string) != -1) {
                arrayList.add(iQueryResultArray);
            }
            this.moveToNextFile();
        }
        iQueryResultArray = new IQueryResult[arrayList.size()];
        arrayList.toArray(iQueryResultArray);
        return iQueryResultArray;
    }

    protected void setFirstFile() throws IOException {
        this.filePosition = 1;
        if (this.getNumFiles() > 0) {
            this.currentFileListBlockNum = this.summary.getBlockNumForFileNum(1);
            this.currentFileListBlock = this.getFileListBlock(this.currentFileListBlockNum);
        }
    }

    protected void setFirstWord() throws IOException {
        this.wordPosition = 1;
        if (this.getNumWords() > 0) {
            this.currentIndexBlockNum = this.summary.getFirstWordBlockNum();
            this.currentIndexBlock = this.getIndexBlock(this.currentIndexBlockNum);
            this.currentWordEntry = new WordEntry();
            this.currentIndexBlock.reset();
            this.currentIndexBlock.nextEntry(this.currentWordEntry);
        }
    }

    public void moveToNextIncludeEntry() throws IOException {
        boolean bl;
        ++this.includePosition;
        if (!this.hasMoreIncludes()) {
            return;
        }
        boolean bl2 = bl = !this.currentIncludeIndexBlock.nextEntry(this.currentIncludeEntry);
        if (bl) {
            this.currentIncludeIndexBlock = this.getIndexBlock(++this.currentIncludeBlockNum);
            this.currentIncludeIndexBlock.nextEntry(this.currentWordEntry);
        }
    }

    protected void setFirstInclude() throws IOException {
        this.includePosition = 1;
        if (this.getNumIncludes() > 0) {
            this.currentIncludeBlockNum = this.summary.getFirstIncludeBlockNum();
            this.currentIncludeIndexBlock = this.getIndexBlock(this.currentIncludeBlockNum);
            this.currentIncludeEntry = new IncludeEntry(0);
            this.currentIncludeIndexBlock.reset();
            this.currentIncludeIndexBlock.nextEntry(this.currentIncludeEntry);
        }
    }

    public IncludeEntry[] queryIncludeEntries() {
        return null;
    }

    public IncludeEntry[] queryIncludeEntries(int n) throws IOException {
        this.open();
        if (n < 0) {
            return null;
        }
        int[] nArray = null;
        nArray = this.summary.getBlockNumsForIncludes();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        IncludeEntry[] includeEntryArray = new IncludeEntry[5];
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray.length;
        while (n3 < n4) {
            IndexBlock indexBlock = this.getIndexBlock(nArray[n3]);
            indexBlock.reset();
            IncludeEntry includeEntry = new IncludeEntry(0);
            block1: while (indexBlock.nextEntry(includeEntry)) {
                if (n2 == includeEntryArray.length) {
                    IncludeEntry[] includeEntryArray2 = includeEntryArray;
                    includeEntryArray = new IncludeEntry[n2 * 2];
                    System.arraycopy(includeEntryArray2, 0, includeEntryArray, 0, n2);
                }
                int n5 = 0;
                while (n5 < includeEntry.getNumRefs()) {
                    if (includeEntry.getRef(n5) == n) {
                        includeEntryArray[n2++] = new IncludeEntry(includeEntry.getFile(), includeEntry.getID());
                        continue block1;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 != includeEntryArray.length) {
            IncludeEntry[] includeEntryArray3 = includeEntryArray;
            includeEntryArray = new IncludeEntry[n2];
            System.arraycopy(includeEntryArray3, 0, includeEntryArray, 0, n2);
        }
        return includeEntryArray;
    }
}

