/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.UTFDataFormatException;

public class CodeByteStream {
    protected byte[] bytes;
    protected int byteOffset = 0;
    protected int bitOffset = 0;
    protected int markByteOffset = -1;
    protected int markBitOffset = -1;

    public CodeByteStream() {
        this(16);
    }

    public CodeByteStream(byte[] byArray) {
        this.bytes = byArray;
    }

    public CodeByteStream(int n) {
        this.bytes = new byte[n];
    }

    public int byteLength() {
        return (this.bitOffset + 7) / 8 + this.byteOffset;
    }

    public byte[] getBytes(int n, int n2) {
        int n3 = this.byteLength();
        if (n > n3 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        byte[] byArray = new byte[n4];
        System.arraycopy(this.bytes, n, byArray, 0, n4);
        if (n2 == n3 && this.bitOffset != 0) {
            int n5 = (1 << this.bitOffset) - 1;
            int n6 = n4 - 1;
            byArray[n6] = (byte)(byArray[n6] & n5 << 8 - this.bitOffset);
        }
        return byArray;
    }

    protected void grow() {
        byte[] byArray = new byte[this.bytes.length * 2 + 1];
        System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
        this.bytes = byArray;
    }

    public void mark() {
        this.markByteOffset = this.byteOffset;
        this.markBitOffset = this.bitOffset;
    }

    public int readBit() {
        int n = this.bytes[this.byteOffset] >> 7 - this.bitOffset & 1;
        if (++this.bitOffset >= 8) {
            this.bitOffset = 0;
            ++this.byteOffset;
        }
        return n;
    }

    public int readBits(int n) {
        int n2 = 0;
        while (n > 0) {
            int n3 = 8 - this.bitOffset;
            if (n3 > n) {
                n3 = n;
            }
            int n4 = (1 << n3) - 1;
            n2 |= (this.bytes[this.byteOffset] >> 8 - this.bitOffset - n3 & n4) << n - n3;
            n -= n3;
            this.bitOffset += n3;
            if (this.bitOffset < 8) continue;
            this.bitOffset -= 8;
            ++this.byteOffset;
        }
        return n2;
    }

    public final int readByte() {
        if (this.bitOffset == 0) {
            return this.bytes[this.byteOffset++] & 0xFF;
        }
        int n = 0;
        int n2 = 8;
        while (n2 > 0) {
            int n3 = 8 - this.bitOffset;
            if (n3 > n2) {
                n3 = n2;
            }
            int n4 = (1 << n3) - 1;
            n |= (this.bytes[this.byteOffset] >> 8 - this.bitOffset - n3 & n4) << n2 - n3;
            n2 -= n3;
            this.bitOffset += n3;
            if (this.bitOffset < 8) continue;
            this.bitOffset -= 8;
            ++this.byteOffset;
        }
        return n;
    }

    public int readGamma() {
        int n = this.readUnary();
        return this.readBits(n - 1) | 1 << n - 1;
    }

    public char[] readUTF() throws UTFDataFormatException {
        int n;
        int n2 = this.readByte();
        if (n2 == 255) {
            int n3 = this.readByte();
            n = this.readByte();
            n2 = (n3 << 8) + n;
        }
        char[] cArray = new char[n2];
        n = 0;
        int n4 = 0;
        while (n < n2) {
            int n5 = this.readByte();
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n;
                    cArray[n4++] = (char)n5;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n += 2) > n2) {
                        throw new UTFDataFormatException();
                    }
                    int n6 = this.readByte();
                    if ((n6 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n4++] = (char)((n5 & 0x1F) << 6 | n6 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n += 3) > n2) {
                        throw new UTFDataFormatException();
                    }
                    int n6 = this.readByte();
                    int n7 = this.readByte();
                    if ((n6 & 0xC0) != 128 || (n7 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n4++] = (char)((n5 & 0xF) << 12 | (n6 & 0x3F) << 6 | (n7 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        if (n4 < n2) {
            char[] cArray2 = cArray;
            cArray = new char[n4];
            System.arraycopy(cArray2, 0, cArray, 0, n4);
        }
        return cArray;
    }

    public int readUnary() {
        int n = 1;
        int n2 = 1 << 7 - this.bitOffset;
        while ((this.bytes[this.byteOffset] & n2) != 0) {
            ++n;
            if (++this.bitOffset >= 8) {
                this.bitOffset = 0;
                ++this.byteOffset;
                n2 = 128;
                continue;
            }
            n2 >>>= 1;
        }
        if (++this.bitOffset >= 8) {
            this.bitOffset = 0;
            ++this.byteOffset;
        }
        return n;
    }

    public void reset() {
        this.bitOffset = 0;
        this.byteOffset = 0;
        this.markBitOffset = -1;
        this.markByteOffset = -1;
    }

    public void reset(byte[] byArray) {
        this.bytes = byArray;
        this.reset();
    }

    public void reset(byte[] byArray, int n) {
        this.reset(byArray);
        this.byteOffset = n;
    }

    public boolean resetToMark() {
        if (this.markByteOffset == -1) {
            return false;
        }
        this.byteOffset = this.markByteOffset;
        this.bitOffset = this.markBitOffset;
        this.markBitOffset = -1;
        this.markByteOffset = -1;
        return true;
    }

    public void skipBits(int n) {
        int n2 = this.byteOffset * 8 + this.bitOffset + n;
        if (n2 < 0 || (n2 + 7) / 8 >= this.bytes.length) {
            throw new IllegalArgumentException();
        }
        this.byteOffset = n2 / 8;
        this.bitOffset = n2 % 8;
    }

    public byte[] toByteArray() {
        return this.getBytes(0, this.byteLength());
    }

    public void writeBit(int n) {
        int n2 = this.byteOffset++;
        this.bytes[n2] = (byte)(this.bytes[n2] | (n & 1) << 7 - this.bitOffset);
        if (++this.bitOffset >= 8) {
            this.bitOffset = 0;
            if (this.byteOffset >= this.bytes.length) {
                this.grow();
            }
        }
    }

    public void writeBits(int n, int n2) {
        while (n2 > 0) {
            int n3 = 8 - this.bitOffset;
            if (n3 > n2) {
                n3 = n2;
            }
            int n4 = 8 - this.bitOffset - n3;
            int n5 = (1 << n3) - 1 << n4;
            this.bytes[this.byteOffset] = (byte)(this.bytes[this.byteOffset] & ~n5 | n >>> n2 - n3 << n4 & n5);
            n2 -= n3;
            this.bitOffset += n3;
            if (this.bitOffset < 8) continue;
            this.bitOffset -= 8;
            if (++this.byteOffset < this.bytes.length) continue;
            this.grow();
        }
    }

    public void writeByte(int n) {
        this.writeBits(n, 8);
    }

    public void writeGamma(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        int n2 = n;
        int n3 = 0;
        while (n2 != 0) {
            n2 >>>= 1;
            ++n3;
        }
        this.writeUnary(n3);
        this.writeBits(n, n3 - 1);
    }

    public void writeUTF(char[] cArray, int n, int n2) {
        char c;
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            c = cArray[n4];
            n3 = c >= '\u0001' && c <= '\u007f' ? ++n3 : (c > '\u07ff' ? (n3 += 3) : (n3 += 2));
            ++n4;
        }
        if (n3 < 255) {
            this.writeByte(n3 & 0xFF);
        } else {
            if (n3 > 65535) {
                throw new IllegalArgumentException();
            }
            this.writeByte(255);
            this.writeByte(n3 >>> 8 & 0xFF);
            this.writeByte(n3 >>> 0 & 0xFF);
        }
        n4 = n;
        while (n4 < n2) {
            c = cArray[n4];
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte(c);
            } else if (c > '\u07ff') {
                this.writeByte(0xE0 | c >> 12 & 0xF);
                this.writeByte(0x80 | c >> 6 & 0x3F);
                this.writeByte(0x80 | c >> 0 & 0x3F);
            } else {
                this.writeByte(0xC0 | c >> 6 & 0x1F);
                this.writeByte(0x80 | c >> 0 & 0x3F);
            }
            ++n4;
        }
    }

    public void writeUnary(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        int n2 = 1 << 7 - this.bitOffset;
        while (--n > 0) {
            int n3 = this.byteOffset++;
            this.bytes[n3] = (byte)(this.bytes[n3] | n2);
            if (++this.bitOffset >= 8) {
                this.bitOffset = 0;
                if (this.byteOffset >= this.bytes.length) {
                    this.grow();
                }
                n2 = 128;
                continue;
            }
            n2 >>>= 1;
        }
        int n4 = this.byteOffset++;
        this.bytes[n4] = (byte)(this.bytes[n4] & ~n2);
        if (++this.bitOffset >= 8) {
            this.bitOffset = 0;
            if (this.byteOffset >= this.bytes.length) {
                this.grow();
            }
        }
    }
}

