/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.UTFDataFormatException;

public class Field {
    protected byte[] buffer;
    protected int offset;
    protected int length;

    public Field(byte[] byArray) {
        this.buffer = byArray;
        this.offset = 0;
        this.length = byArray.length;
    }

    public Field(byte[] byArray, int n) {
        this.buffer = byArray;
        this.offset = 0;
        this.length = n;
    }

    public Field(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.offset = n;
        this.length = n2;
    }

    public Field(int n) {
        this.buffer = new byte[n];
        this.offset = 0;
        this.length = n;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public Field buffer(byte[] byArray) {
        this.buffer = byArray;
        return this;
    }

    public Field clear() {
        Field.clear(this.buffer, this.offset, this.length);
        return this;
    }

    protected static void clear(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            byArray[n3] = 0;
            ++n3;
            ++n4;
        }
    }

    public Field clear(int n) {
        Field.clear(this.buffer, this.offset, n);
        return this;
    }

    public Field clear(int n, int n2) {
        Field.clear(this.buffer, this.offset + n, n2);
        return this;
    }

    protected static int compare(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = Math.min(n2, n4);
        int n6 = 0;
        while (n6 < n5) {
            int n7 = byArray[n + n6] & 0xFF;
            int n8 = byArray2[n3 + n6] & 0xFF;
            if (n7 > n8) {
                return 1;
            }
            if (n7 < n8) {
                return -1;
            }
            ++n6;
        }
        if (n2 > n5) {
            n6 = n5;
            while (n6 < n2) {
                if (byArray[n + n6] != 0) {
                    return 1;
                }
                ++n6;
            }
            return 0;
        }
        n6 = n5;
        while (n6 < n4) {
            if (byArray2[n3 + n6] != 0) {
                return -1;
            }
            ++n6;
        }
        return 0;
    }

    public static int compare(Field field, Field field2) {
        return Field.compare(field.buffer, field.offset, field.length, field2.buffer, field2.offset, field2.length);
    }

    public Field copy(int n, int n2, int n3) {
        System.arraycopy(this.buffer, this.offset + n, this.buffer, this.offset + n2, n3);
        return this;
    }

    public Field dec(int n) {
        this.offset -= n;
        return this;
    }

    public byte[] get() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.buffer, this.offset, byArray, 0, this.length);
        return byArray;
    }

    public byte[] get(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buffer, this.offset + n, byArray, 0, n2);
        return byArray;
    }

    public Field getField(int n, int n2) {
        return new Field(this.buffer, this.offset + n, n2);
    }

    public int getInt1() {
        return this.buffer[this.offset];
    }

    public int getInt1(int n) {
        return this.buffer[this.offset + n];
    }

    public int getInt2() {
        int n = this.offset;
        int n2 = this.buffer[n++];
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        return n2;
    }

    public int getInt2(int n) {
        int n2 = this.offset + n;
        int n3 = this.buffer[n2++];
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        return n3;
    }

    public int getInt3() {
        int n = this.offset;
        int n2 = this.buffer[n++];
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        return n2;
    }

    public int getInt3(int n) {
        int n2 = this.offset + n;
        int n3 = this.buffer[n2++];
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        return n3;
    }

    public int getInt4() {
        int n = this.offset;
        int n2 = this.buffer[n++];
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        return n2;
    }

    public int getInt4(int n) {
        int n2 = this.offset + n;
        int n3 = this.buffer[n2++];
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        return n3;
    }

    public int getUInt1() {
        return this.buffer[this.offset] & 0xFF;
    }

    public int getUInt1(int n) {
        return this.buffer[this.offset + n] & 0xFF;
    }

    public int getUInt2() {
        int n = this.offset;
        int n2 = this.buffer[n++] & 0xFF;
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        return n2;
    }

    public int getUInt2(int n) {
        int n2 = this.offset + n;
        int n3 = this.buffer[n2++] & 0xFF;
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        return n3;
    }

    public int getUInt3() {
        int n = this.offset;
        int n2 = this.buffer[n++] & 0xFF;
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        n2 = n2 << 8 | this.buffer[n++] & 0xFF;
        return n2;
    }

    public int getUInt3(int n) {
        int n2 = this.offset + n;
        int n3 = this.buffer[n2++] & 0xFF;
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        n3 = n3 << 8 | this.buffer[n2++] & 0xFF;
        return n3;
    }

    public char[] getUTF(int n) throws UTFDataFormatException {
        int n2 = this.offset + n;
        int n3 = this.getUInt2(n2);
        n2 += 2;
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = this.buffer[n2++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n4;
                    cArray[n5++] = (char)n6;
                    break;
                }
                case 12: 
                case 13: {
                    int n7;
                    if ((n4 += 2) > n3) {
                        throw new UTFDataFormatException();
                    }
                    if (((n7 = this.buffer[n2++] & 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n5++] = (char)((n6 & 0x1F) << 6 | n7 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n4 += 3) > n3) {
                        throw new UTFDataFormatException();
                    }
                    int n7 = this.buffer[n2++] & 0xFF;
                    int n8 = this.buffer[n2++] & 0xFF;
                    if ((n7 & 0xC0) != 128 || (n8 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n5++] = (char)((n6 & 0xF) << 12 | (n7 & 0x3F) << 6 | (n8 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        if (n5 < n3) {
            char[] cArray2 = cArray;
            cArray = new char[n5];
            System.arraycopy(cArray2, 0, cArray, 0, n5);
        }
        return cArray;
    }

    public Field inc(int n) {
        this.offset += n;
        return this;
    }

    public int length() {
        return this.length;
    }

    public Field length(int n) {
        this.length = n;
        return this;
    }

    public int offset() {
        return this.offset;
    }

    public Field offset(int n) {
        this.offset = n;
        return this;
    }

    public Field pointTo(int n) {
        return new Field(this.buffer, this.offset + n, 0);
    }

    public Field put(byte[] byArray) {
        return this.put(0, byArray);
    }

    public Field put(int n, byte[] byArray) {
        System.arraycopy(byArray, 0, this.buffer, this.offset + n, byArray.length);
        return this;
    }

    public Field put(int n, Field field) {
        System.arraycopy(field.buffer, field.offset, this.buffer, this.offset + n, field.length);
        return this;
    }

    public Field put(Field field) {
        System.arraycopy(field.buffer, field.offset, this.buffer, this.offset, field.length);
        return this;
    }

    public Field putInt1(int n) {
        this.buffer[this.offset] = (byte)n;
        return this;
    }

    public Field putInt1(int n, int n2) {
        this.buffer[this.offset + n] = (byte)n2;
        return this;
    }

    public Field putInt2(int n) {
        int n2 = this.offset;
        this.buffer[n2++] = (byte)(n >> 8);
        this.buffer[n2++] = (byte)(n >> 0);
        return this;
    }

    public Field putInt2(int n, int n2) {
        int n3 = this.offset + n;
        this.buffer[n3++] = (byte)(n2 >> 8);
        this.buffer[n3++] = (byte)(n2 >> 0);
        return this;
    }

    public Field putInt3(int n) {
        int n2 = this.offset;
        this.buffer[n2++] = (byte)(n >> 16);
        this.buffer[n2++] = (byte)(n >> 8);
        this.buffer[n2++] = (byte)(n >> 0);
        return this;
    }

    public Field putInt3(int n, int n2) {
        int n3 = this.offset + n;
        this.buffer[n3++] = (byte)(n2 >> 16);
        this.buffer[n3++] = (byte)(n2 >> 8);
        this.buffer[n3++] = (byte)(n2 >> 0);
        return this;
    }

    public Field putInt4(int n) {
        int n2 = this.offset;
        this.buffer[n2++] = (byte)(n >> 24);
        this.buffer[n2++] = (byte)(n >> 16);
        this.buffer[n2++] = (byte)(n >> 8);
        this.buffer[n2++] = (byte)(n >> 0);
        return this;
    }

    public Field putInt4(int n, int n2) {
        int n3 = this.offset + n;
        this.buffer[n3++] = (byte)(n2 >> 24);
        this.buffer[n3++] = (byte)(n2 >> 16);
        this.buffer[n3++] = (byte)(n2 >> 8);
        this.buffer[n3++] = (byte)(n2 >> 0);
        return this;
    }

    public int putUTF(int n, char[] cArray) {
        int n2;
        int n3 = cArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n2 = cArray[n5];
            n4 = n2 >= 1 && n2 <= 127 ? ++n4 : (n2 > 2047 ? (n4 += 3) : (n4 += 2));
            ++n5;
        }
        if (n4 > 65535) {
            throw new IllegalArgumentException();
        }
        n5 = this.offset + n;
        this.buffer[n5++] = (byte)(n4 >>> 8 & 0xFF);
        this.buffer[n5++] = (byte)(n4 >>> 0 & 0xFF);
        n2 = 0;
        while (n2 < n3) {
            char c = cArray[n2];
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer[n5++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buffer[n5++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[n5++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[n5++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.buffer[n5++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buffer[n5++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n2;
        }
        return 2 + n4;
    }
}

