/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IIndexer;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.cdt.internal.core.index.impl.IFileDocument;
import org.eclipse.cdt.internal.core.index.impl.InMemoryIndex;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.IndexerOutput;
import org.eclipse.cdt.internal.core.index.impl.Int;
import org.eclipse.cdt.internal.core.index.impl.MergeFactory;
import org.eclipse.cdt.internal.core.index.impl.SimpleIndexInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class Index
implements IIndex {
    public static final int MAX_FOOTPRINT = 10000000;
    protected InMemoryIndex addsIndex;
    protected IndexInput addsIndexInput;
    protected int state = 1;
    protected Map removedInAdds;
    protected Map removedInOld;
    protected static final int CAN_MERGE = 0;
    protected static final int MERGED = 1;
    private File indexFile;
    public String toString;

    public Index(File file, boolean bl) throws IOException {
        this(file, ".index", bl);
    }

    public Index(File file, String string, boolean bl) throws IOException {
        this.indexFile = new File(file, string);
        this.initialize(bl);
    }

    public Index(String string, boolean bl) throws IOException {
        this(string, null, bl);
    }

    public Index(String string, String string2, boolean bl) throws IOException {
        this.indexFile = new File(string);
        this.toString = string2;
        this.initialize(bl);
    }

    public void add(IDocument iDocument, IIndexer iIndexer) throws IOException {
        IndexedFile indexedFile;
        if (this.timeToMerge()) {
            this.merge();
        }
        if ((indexedFile = this.addsIndex.getIndexedFile(iDocument.getName())) != null) {
            this.remove(indexedFile, 0);
        }
        IndexerOutput indexerOutput = new IndexerOutput(this.addsIndex);
        iIndexer.index(iDocument, indexerOutput);
        this.state = 0;
    }

    protected boolean canMerge() {
        return this.state == 0;
    }

    public void empty() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            InMemoryIndex inMemoryIndex = new InMemoryIndex();
            BlocksIndexOutput blocksIndexOutput = new BlocksIndexOutput(this.indexFile);
            if (!this.indexFile.exists()) {
                inMemoryIndex.save(blocksIndexOutput);
            }
        }
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public int getNumDocuments() throws IOException {
        int n;
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)blocksIndexInput).open();
            n = ((IndexInput)blocksIndexInput).getNumFiles();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        ((IndexInput)blocksIndexInput).close();
        return n;
    }

    public int getNumWords() throws IOException {
        int n;
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)blocksIndexInput).open();
            n = ((IndexInput)blocksIndexInput).getNumWords();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        ((IndexInput)blocksIndexInput).close();
        return n;
    }

    public int getNumIncludes() throws IOException {
        int n;
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)blocksIndexInput).open();
            n = ((IndexInput)blocksIndexInput).getNumIncludes();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        ((IndexInput)blocksIndexInput).close();
        return n;
    }

    public String getPath(int n) throws IOException {
        IndexedFile indexedFile;
        BlocksIndexInput blocksIndexInput;
        block3: {
            String string;
            blocksIndexInput = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)blocksIndexInput).open();
                indexedFile = ((IndexInput)blocksIndexInput).getIndexedFile(n);
                if (indexedFile != null) break block3;
                string = null;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                ((IndexInput)blocksIndexInput).close();
                throw throwable;
            }
            ((IndexInput)blocksIndexInput).close();
            return string;
        }
        String string = indexedFile.getPath();
        Object var4_7 = null;
        ((IndexInput)blocksIndexInput).close();
        return string;
    }

    public boolean hasChanged() {
        return this.canMerge();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(boolean bl) throws IOException {
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
        if (bl && this.indexFile.exists()) {
            BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)blocksIndexInput).open();
            }
            catch (IOException iOException) {
                BlocksIndexInput blocksIndexInput2 = blocksIndexInput;
                try {
                    blocksIndexInput2.opened = true;
                    blocksIndexInput2.close();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    blocksIndexInput2.opened = false;
                    throw throwable;
                }
                {
                    Object var5_9 = null;
                    blocksIndexInput2.opened = false;
                    this.indexFile.delete();
                }
                blocksIndexInput = null;
                throw iOException;
            }
            ((IndexInput)blocksIndexInput).close();
            return;
        }
        InMemoryIndex inMemoryIndex = new InMemoryIndex();
        BlocksIndexOutput blocksIndexOutput = new BlocksIndexOutput(this.indexFile);
        inMemoryIndex.save(blocksIndexOutput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void merge() throws IOException {
        File file = new File(String.valueOf(this.indexFile.getAbsolutePath()) + "TempVA");
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        BlocksIndexOutput blocksIndexOutput = new BlocksIndexOutput(file);
        try {
            new MergeFactory(blocksIndexInput, this.addsIndexInput, blocksIndexOutput, this.removedInOld, this.removedInAdds).merge();
            File file2 = (File)((IndexInput)blocksIndexInput).getSource();
            File file3 = (File)blocksIndexOutput.getDestination();
            file2.delete();
            file3.renameTo(file2);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
            CCorePlugin.getDefault().cdtLog.flushLog();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
            CCorePlugin.getDefault().cdtLog.flushLog();
            return;
        }
    }

    public IQueryResult[] query(String string) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)blocksIndexInput).query(string);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        ((IndexInput)blocksIndexInput).close();
        return iQueryResultArray;
    }

    public IEntryResult[] queryEntries(char[] cArray) throws IOException {
        IEntryResult[] iEntryResultArray;
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        try {
            iEntryResultArray = ((IndexInput)blocksIndexInput).queryEntriesPrefixedBy(cArray);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        ((IndexInput)blocksIndexInput).close();
        return iEntryResultArray;
    }

    public IQueryResult[] queryInDocumentNames(String string) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)blocksIndexInput).queryInDocumentNames(string);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        ((IndexInput)blocksIndexInput).close();
        return iQueryResultArray;
    }

    public IQueryResult[] queryPrefix(char[] cArray) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)blocksIndexInput).queryFilesReferringToPrefix(cArray);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        ((IndexInput)blocksIndexInput).close();
        return iQueryResultArray;
    }

    public String[] getFileDependencies(IPath iPath) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getFileDependencies(IFile iFile) throws IOException {
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(this.indexFile);
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            IFileDocument iFileDocument = new IFileDocument(iFile);
            ((IndexInput)blocksIndexInput).open();
            IndexedFile indexedFile = ((IndexInput)blocksIndexInput).getIndexedFile(iFileDocument);
            n = indexedFile.getFileNumber();
            IncludeEntry[] includeEntryArray = ((IndexInput)blocksIndexInput).queryIncludeEntries(n);
            int n2 = 0;
            while (n2 < includeEntryArray.length) {
                char[] cArray = includeEntryArray[n2].getFile();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(cArray);
                arrayList.add(stringBuffer.toString());
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        ((IndexInput)blocksIndexInput).close();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void remove(String string) throws IOException {
        IndexedFile indexedFile = this.addsIndex.getIndexedFile(string);
        if (indexedFile != null) {
            Int intVal = (Int)this.removedInAdds.get(string);
            if (intVal != null) {
                int n = indexedFile.getFileNumber();
                if (intVal.value < n) {
                    intVal.value = n;
                }
            } else {
                this.removedInAdds.put(string, new Int(indexedFile.getFileNumber()));
            }
        } else {
            this.removedInOld.put(string, new Int(1));
        }
        this.state = 0;
    }

    protected void remove(IndexedFile indexedFile, int n) throws IOException {
        String string = indexedFile.getPath();
        if (n == 0) {
            Int intVal = (Int)this.removedInAdds.get(string);
            if (intVal != null) {
                if (intVal.value < indexedFile.getFileNumber()) {
                    intVal.value = indexedFile.getFileNumber();
                }
            } else {
                this.removedInAdds.put(string, new Int(indexedFile.getFileNumber()));
            }
        } else if (n == 1) {
            this.removedInOld.put(string, new Int(1));
        } else {
            throw new Error();
        }
        this.state = 0;
    }

    public void save() throws IOException {
        if (this.canMerge()) {
            this.merge();
        }
    }

    protected boolean timeToMerge() {
        return this.addsIndex.getFootprint() >= 10000000L;
    }

    public String toString() {
        String string = this.toString;
        if (string == null) {
            string = super.toString();
        }
        string = String.valueOf(string) + "(length: " + this.getIndexFile().length() + ")";
        return string;
    }
}

