/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;

public class Util {
    private Util() {
    }

    public static int compare(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        int n2 = cArray2.length;
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = cArray[n4];
            if (c2 == (c = cArray2[n4++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static int prefixLength(char[] cArray, char[] cArray2) {
        int n = 0;
        int n2 = Math.min(cArray.length, cArray2.length);
        int n3 = 0;
        while (n3 < n2 && cArray[n3] == cArray2[n3]) {
            ++n;
            ++n3;
        }
        return n;
    }

    public static int prefixLength(String string, String string2) {
        int n = 0;
        int n2 = Math.min(string.length(), string2.length());
        int n3 = 0;
        while (n3 < n2 && string.charAt(n3) == string2.charAt(n3)) {
            ++n;
            ++n3;
        }
        return n;
    }

    private static void quickSort(char[][] cArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        char[] cArray2 = cArray[(n + n2) / 2];
        while (true) {
            if (Util.compare(cArray[n], cArray2) < 0) {
                ++n;
                continue;
            }
            while (Util.compare(cArray2, cArray[n2]) < 0) {
                --n2;
            }
            if (n <= n2) {
                char[] cArray3 = cArray[n];
                cArray[n] = cArray[n2];
                cArray[n2] = cArray3;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(cArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(cArray, n, n4);
        }
    }

    private static void quickSort(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = nArray[(n + n2) / 2];
        while (true) {
            if (nArray[n] < n5) {
                ++n;
                continue;
            }
            while (n5 < nArray[n2]) {
                --n2;
            }
            if (n <= n2) {
                int n6 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n6;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(nArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(nArray, n, n4);
        }
    }

    private static void quickSort(String[] stringArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        String string = stringArray[(n + n2) / 2];
        while (true) {
            if (stringArray[n].compareTo(string) < 0) {
                ++n;
                continue;
            }
            while (string.compareTo(stringArray[n2]) < 0) {
                --n2;
            }
            if (n <= n2) {
                String string2 = stringArray[n];
                stringArray[n] = stringArray[n2];
                stringArray[n2] = string2;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(stringArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(stringArray, n, n4);
        }
    }

    private static void quickSort(IndexedFile[] indexedFileArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        String string = indexedFileArray[(n + n2) / 2].path;
        while (true) {
            if (indexedFileArray[n].path.compareTo(string) < 0) {
                ++n;
                continue;
            }
            while (string.compareTo(indexedFileArray[n2].path) < 0) {
                --n2;
            }
            if (n <= n2) {
                IndexedFile indexedFile = indexedFileArray[n];
                indexedFileArray[n] = indexedFileArray[n2];
                indexedFileArray[n2] = indexedFile;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(indexedFileArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(indexedFileArray, n, n4);
        }
    }

    private static void quickSort(WordEntry[] wordEntryArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        char[] cArray = wordEntryArray[(n + n2) / 2].fWord;
        while (true) {
            if (Util.compare(wordEntryArray[n].fWord, cArray) < 0) {
                ++n;
                continue;
            }
            while (Util.compare(cArray, wordEntryArray[n2].fWord) < 0) {
                --n2;
            }
            if (n <= n2) {
                WordEntry wordEntry = wordEntryArray[n];
                wordEntryArray[n] = wordEntryArray[n2];
                wordEntryArray[n2] = wordEntry;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(wordEntryArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(wordEntryArray, n, n4);
        }
    }

    private static void quickSort(IncludeEntry[] includeEntryArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        char[] cArray = includeEntryArray[(n + n2) / 2].fFile;
        while (true) {
            if (Util.compare(includeEntryArray[n].fFile, cArray) < 0) {
                ++n;
                continue;
            }
            while (Util.compare(cArray, includeEntryArray[n2].fFile) < 0) {
                --n2;
            }
            if (n <= n2) {
                IncludeEntry includeEntry = includeEntryArray[n];
                includeEntryArray[n] = includeEntryArray[n2];
                includeEntryArray[n2] = includeEntry;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(includeEntryArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(includeEntryArray, n, n4);
        }
    }

    public static final char[] readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = dataInput.readUnsignedByte();
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = dataInput.readUnsignedByte();
                    if ((n5 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = dataInput.readUnsignedByte();
                    int n6 = dataInput.readUnsignedByte();
                    if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | (n6 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        if (n3 < n) {
            char[] cArray2 = cArray;
            cArray = new char[n3];
            System.arraycopy(cArray2, 0, cArray, 0, n3);
        }
        return cArray;
    }

    public static void sort(char[][] cArray) {
        if (cArray.length > 1) {
            Util.quickSort(cArray, 0, cArray.length - 1);
        }
    }

    public static void sort(int[] nArray) {
        if (nArray.length > 1) {
            Util.quickSort(nArray, 0, nArray.length - 1);
        }
    }

    public static void sort(String[] stringArray) {
        if (stringArray.length > 1) {
            Util.quickSort(stringArray, 0, stringArray.length - 1);
        }
    }

    public static void sort(IndexedFile[] indexedFileArray) {
        if (indexedFileArray.length > 1) {
            Util.quickSort(indexedFileArray, 0, indexedFileArray.length - 1);
        }
    }

    public static void sort(WordEntry[] wordEntryArray) {
        if (wordEntryArray.length > 1) {
            Util.quickSort(wordEntryArray, 0, wordEntryArray.length - 1);
        }
    }

    public static void sort(IncludeEntry[] includeEntryArray) {
        if (includeEntryArray.length > 1) {
            Util.quickSort(includeEntryArray, 0, includeEntryArray.length - 1);
        }
    }

    public static void writeUTF(OutputStream outputStream, char[] cArray) throws IOException {
        char c;
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            c = cArray[n3];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        outputStream.write(n2 >>> 8 & 0xFF);
        outputStream.write(n2 >>> 0 & 0xFF);
        n3 = 0;
        while (n3 < n) {
            c = cArray[n3];
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
            } else if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
            } else {
                outputStream.write(0xC0 | c >> 6 & 0x1F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
            }
            ++n3;
        }
    }
}

