/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.impl.Util;

public class WordEntry {
    protected char[] fWord;
    protected int fNumRefs;
    protected int[] fRefs;

    public WordEntry() {
        this(CharOperation.NO_CHAR);
    }

    public WordEntry(char[] cArray) {
        this.fWord = cArray;
        this.fNumRefs = 0;
        this.fRefs = new int[1];
    }

    public int addRef(int n) {
        if (this.fNumRefs > 0 && this.fRefs[this.fNumRefs - 1] == n) {
            return 0;
        }
        if (this.fNumRefs < this.fRefs.length) {
            this.fRefs[this.fNumRefs++] = n;
            return 0;
        }
        int n2 = this.fNumRefs < 4 ? 4 : this.fNumRefs * 2;
        this.fRefs = new int[n2];
        System.arraycopy(this.fRefs, 0, this.fRefs, 0, this.fNumRefs);
        this.fRefs[this.fNumRefs++] = n;
        return (n2 - this.fNumRefs + 1) * 4;
    }

    public void addRefs(int[] nArray) {
        int[] nArray2 = new int[this.fNumRefs + nArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n < this.fNumRefs || n2 < nArray.length) {
            int n6;
            if (n >= this.fNumRefs) {
                n5 = nArray[n2];
                n6 = -1;
            } else if (n2 >= nArray.length) {
                n6 = 1;
                n4 = this.fRefs[n];
            } else {
                n4 = this.fRefs[n];
                n5 = nArray[n2];
                n6 = n5 - n4;
            }
            if (n6 > 0) {
                nArray2[n3] = n4;
                ++n3;
                ++n;
                continue;
            }
            if (n5 != 0) {
                nArray2[n3] = n5;
                ++n3;
            }
            ++n2;
        }
        this.fRefs = nArray2;
        this.fNumRefs = n3;
    }

    public int footprint() {
        return 20 + (8 + this.fWord.length * 2) + (8 + this.fRefs.length * 4);
    }

    public int getNumRefs() {
        return this.fNumRefs;
    }

    public int getRef(int n) {
        if (n < this.fNumRefs) {
            return this.fRefs[n];
        }
        throw new IndexOutOfBoundsException();
    }

    public int[] getRefs() {
        int[] nArray = new int[this.fNumRefs];
        System.arraycopy(this.fRefs, 0, nArray, 0, this.fNumRefs);
        return nArray;
    }

    public char[] getWord() {
        return this.fWord;
    }

    public void mapRefs(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fNumRefs) {
            int n3 = -1;
            if (this.fRefs[n2] >= 0 && this.fRefs[n2] < nArray.length) {
                n3 = nArray[this.fRefs[n2]];
            }
            if (n3 != -1 && n3 != 0) {
                this.fRefs[n++] = n3;
            }
            ++n2;
        }
        this.fNumRefs = n;
        this.fRefs = new int[this.fNumRefs];
        System.arraycopy(this.fRefs, 0, this.fRefs, 0, this.fNumRefs);
        Util.sort(this.fRefs);
    }

    public void reset(char[] cArray) {
        int n = this.fNumRefs;
        while (n-- > 0) {
            this.fRefs[n] = 0;
        }
        this.fNumRefs = 0;
        this.fWord = cArray;
    }

    public String toString() {
        return new String(this.fWord);
    }
}

