/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class APathEntry
extends PathEntry {
    public static IPath[] NO_EXCLUSION_PATTERNS = new IPath[0];
    IPath[] exclusionPatterns;
    IPath basePath;
    IPath baseRef;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    char[][] fullCharExclusionPatterns = UNINIT_PATTERNS;

    public APathEntry(int n, IPath iPath, IPath iPath2, IPath iPath3, IPath[] iPathArray, boolean bl) {
        super(n, iPath3, bl);
        this.basePath = iPath == null ? Path.EMPTY : iPath;
        this.baseRef = iPath2 == null ? Path.EMPTY : iPath2;
        this.exclusionPatterns = iPathArray == null ? NO_EXCLUSION_PATTERNS : iPathArray;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IPath getBasePath() {
        return this.basePath;
    }

    public IPath getBaseReference() {
        return this.baseRef;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullCharExclusionPatterns == UNINIT_PATTERNS) {
            int n = this.exclusionPatterns.length;
            this.fullCharExclusionPatterns = new char[n][];
            IPath iPath = this.path.removeTrailingSeparator();
            int n2 = 0;
            while (n2 < n) {
                this.fullCharExclusionPatterns[n2] = iPath.append(this.exclusionPatterns[n2]).toString().toCharArray();
                ++n2;
            }
        }
        return this.fullCharExclusionPatterns;
    }

    public boolean equals(Object object) {
        if (object instanceof APathEntry) {
            APathEntry aPathEntry = (APathEntry)object;
            if (!super.equals(aPathEntry)) {
                return false;
            }
            IPath[] iPathArray = aPathEntry.getExclusionPatterns();
            if (this.exclusionPatterns != iPathArray) {
                int n;
                int n2 = n = this.exclusionPatterns == null ? 0 : this.exclusionPatterns.length;
                if (iPathArray.length != n) {
                    return false;
                }
                int n3 = 0;
                while (n3 < n) {
                    String string = this.exclusionPatterns[n3].toString();
                    if (!string.equals(iPathArray[n3].toString())) {
                        return false;
                    }
                    ++n3;
                }
            }
            IPath iPath = aPathEntry.getBasePath();
            if (this.basePath != null && iPath != null && !this.basePath.equals((Object)iPath)) {
                return false;
            }
            IPath iPath2 = aPathEntry.getBaseReference();
            return this.baseRef == null || iPath2 == null || this.baseRef.equals((Object)iPath2);
        }
        return super.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.basePath != null && !this.basePath.isEmpty()) {
            stringBuffer.append(" base-path:").append(this.basePath.toString());
        }
        if (this.baseRef != null && !this.baseRef.isEmpty()) {
            stringBuffer.append(" base-ref:").append(this.baseRef.toString());
        }
        return stringBuffer.toString();
    }
}

