/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ArchiveInfo;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Archive
extends Openable
implements IArchive {
    IBinaryParser.IBinaryArchive binaryArchive;

    public Archive(ICElement iCElement, IFile iFile, IBinaryParser.IBinaryArchive iBinaryArchive) {
        this(iCElement, iFile.getLocation(), iBinaryArchive);
    }

    public Archive(ICElement iCElement, IPath iPath, IBinaryParser.IBinaryArchive iBinaryArchive) {
        super(iCElement, iPath, 18);
        this.binaryArchive = iBinaryArchive;
    }

    public IBinary[] getBinaries() throws CModelException {
        ICElement[] iCElementArray = this.getChildren();
        IBinary[] iBinaryArray = new IBinary[iCElementArray.length];
        System.arraycopy(iCElementArray, 0, iBinaryArray, 0, iCElementArray.length);
        return iBinaryArray;
    }

    public boolean isReadOnly() {
        return true;
    }

    public CElementInfo createElementInfo() {
        return new ArchiveInfo(this);
    }

    protected ArchiveInfo getArchiveInfo() throws CModelException {
        return (ArchiveInfo)this.getElementInfo();
    }

    protected boolean buildStructure(OpenableInfo openableInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) throws CModelException {
        return this.computeChildren(openableInfo, iResource);
    }

    public boolean computeChildren(OpenableInfo openableInfo, IResource iResource) {
        IBinaryParser.IBinaryArchive iBinaryArchive = this.getBinaryArchive();
        if (iBinaryArchive != null) {
            IBinaryParser.IBinaryObject[] iBinaryObjectArray = iBinaryArchive.getObjects();
            int n = 0;
            while (n < iBinaryObjectArray.length) {
                IBinaryParser.IBinaryObject iBinaryObject = iBinaryObjectArray[n];
                Binary binary = new Binary((ICElement)this, iBinaryArchive.getPath().append(iBinaryObject.getName()), iBinaryObject);
                openableInfo.addChild(binary);
                ++n;
            }
        } else {
            return false;
        }
        return true;
    }

    IBinaryParser.IBinaryArchive getBinaryArchive() {
        return this.binaryArchive;
    }

    public boolean exists() {
        return this.getResource() != null;
    }

    protected void closing(Object object) throws CModelException {
        ICProject iCProject = this.getCProject();
        CProjectInfo cProjectInfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(iCProject);
        if (cProjectInfo != null && cProjectInfo.vLib != null) {
            cProjectInfo.vLib.removeChild(this);
        }
        super.closing(object);
    }
}

