/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.BinaryFunction;
import org.eclipse.cdt.internal.core.model.BinaryInfo;
import org.eclipse.cdt.internal.core.model.BinaryModule;
import org.eclipse.cdt.internal.core.model.BinaryVariable;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Binary
extends Openable
implements IBinary {
    private int fBinType;
    private String hasDebug;
    private String cpu;
    private String[] needed;
    private long longData;
    private long longText;
    private long longBSS;
    private String endian;
    private String soname;
    private long fLastModification;
    IBinaryParser.IBinaryObject binaryObject;

    public Binary(ICElement iCElement, IFile iFile, IBinaryParser.IBinaryObject iBinaryObject) {
        super(iCElement, (IResource)iFile, 14);
        this.binaryObject = iBinaryObject;
    }

    public Binary(ICElement iCElement, IPath iPath, IBinaryParser.IBinaryObject iBinaryObject) {
        super(iCElement, iPath, 14);
        this.binaryObject = iBinaryObject;
    }

    public boolean isSharedLib() {
        return this.getType() == 4;
    }

    public boolean isExecutable() {
        return this.getType() == 2;
    }

    public boolean isObject() {
        return this.getType() == 1;
    }

    public boolean isCore() {
        return this.getType() == 16;
    }

    public boolean hasDebug() {
        IBinaryParser.IBinaryObject iBinaryObject;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.hasDebug == null || this.hasChanged()) && (iBinaryObject = this.getBinaryObject()) != null) {
            this.hasDebug = new Boolean(iBinaryObject.hasDebug()).toString();
        }
        return Boolean.valueOf(this.hasDebug);
    }

    public String getCPU() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) && (this.cpu == null || this.hasChanged())) {
            IBinaryParser.IBinaryObject iBinaryObject = this.getBinaryObject();
            this.cpu = iBinaryObject.getCPU();
        }
        return this.cpu == null ? "" : this.cpu;
    }

    public String[] getNeededSharedLibs() {
        IBinaryParser.IBinaryObject iBinaryObject;
        if ((this.isExecutable() || this.isSharedLib()) && (this.needed == null || this.hasChanged()) && (iBinaryObject = this.getBinaryObject()) instanceof IBinaryParser.IBinaryExecutable) {
            this.needed = ((IBinaryParser.IBinaryExecutable)iBinaryObject).getNeededSharedLibs();
        }
        return this.needed == null ? new String[]{} : this.needed;
    }

    public long getText() {
        IBinaryParser.IBinaryObject iBinaryObject;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longText == -1L || this.hasChanged()) && (iBinaryObject = this.getBinaryObject()) != null) {
            this.longText = iBinaryObject.getText();
        }
        return this.longText;
    }

    public long getData() {
        IBinaryParser.IBinaryObject iBinaryObject;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longData == -1L || this.hasChanged()) && (iBinaryObject = this.getBinaryObject()) != null) {
            this.longData = iBinaryObject.getData();
        }
        return this.longData;
    }

    public long getBSS() {
        IBinaryParser.IBinaryObject iBinaryObject;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longBSS == -1L || this.hasChanged()) && (iBinaryObject = this.getBinaryObject()) != null) {
            this.longBSS = iBinaryObject.getBSS();
        }
        return this.longBSS;
    }

    public String getSoname() {
        IBinaryParser.IBinaryObject iBinaryObject;
        if (this.isSharedLib() && (this.soname == null || this.hasChanged()) && (iBinaryObject = this.getBinaryObject()) instanceof IBinaryParser.IBinaryShared) {
            this.soname = ((IBinaryParser.IBinaryShared)iBinaryObject).getSoName();
        }
        return this.soname == null ? "" : this.soname;
    }

    public boolean isLittleEndian() {
        IBinaryParser.IBinaryObject iBinaryObject;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) && (this.endian == null || this.hasChanged()) && (iBinaryObject = this.getBinaryObject()) != null) {
            this.endian = new Boolean(iBinaryObject.isLittleEndian()).toString();
        }
        return Boolean.valueOf(this.endian);
    }

    protected IBinaryParser.IBinaryObject getBinaryObject() {
        return this.binaryObject;
    }

    protected int getType() {
        IBinaryParser.IBinaryObject iBinaryObject = this.getBinaryObject();
        if (iBinaryObject != null && (this.fBinType == 0 || this.hasChanged())) {
            this.fBinType = iBinaryObject.getType();
        }
        return this.fBinType;
    }

    protected boolean hasChanged() {
        long l = this.getModificationStamp();
        boolean bl = l != this.fLastModification;
        this.fLastModification = l;
        if (bl) {
            this.hasDebug = null;
            this.needed = null;
            this.cpu = null;
            this.endian = null;
            this.longBSS = -1L;
            this.longData = -1L;
            this.longText = -1L;
            this.soname = null;
        }
        return bl;
    }

    protected long getModificationStamp() {
        IResource iResource = this.getResource();
        if (iResource != null) {
            return iResource.getModificationStamp();
        }
        return 0L;
    }

    public boolean isReadOnly() {
        return true;
    }

    public CElementInfo createElementInfo() {
        return new BinaryInfo(this);
    }

    protected boolean buildStructure(OpenableInfo openableInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) throws CModelException {
        return this.computeChildren(openableInfo, iResource);
    }

    boolean computeChildren(OpenableInfo openableInfo, IResource iResource) throws CModelException {
        boolean bl = false;
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            HashMap hashMap = new HashMap();
            IBinaryParser.IBinaryObject iBinaryObject = this.getBinaryObject();
            if (iBinaryObject != null) {
                IBinaryParser.ISymbol[] iSymbolArray = iBinaryObject.getSymbols();
                int n = 0;
                while (n < iSymbolArray.length) {
                    switch (iSymbolArray[n].getType()) {
                        case 1: {
                            this.addFunction(openableInfo, iSymbolArray[n], hashMap);
                            break;
                        }
                        case 2: {
                            this.addVariable(openableInfo, iSymbolArray[n], hashMap);
                        }
                    }
                    ++n;
                }
                bl = true;
            }
        }
        return bl;
    }

    private void addFunction(OpenableInfo openableInfo, IBinaryParser.ISymbol iSymbol, Map map) throws CModelException {
        IPath iPath = iSymbol.getFilename();
        BinaryFunction binaryFunction = null;
        if (iPath != null) {
            BinaryModule binaryModule = null;
            if (map.containsKey(iPath)) {
                binaryModule = (BinaryModule)map.get(iPath);
            } else {
                binaryModule = new BinaryModule(this, iPath);
                map.put(iPath, binaryModule);
                openableInfo.addChild(binaryModule);
            }
            binaryFunction = new BinaryFunction((ICElement)binaryModule, iSymbol.getName(), iSymbol.getAddress());
            binaryFunction.setLines(iSymbol.getStartLine(), iSymbol.getEndLine());
            binaryModule.addChild(binaryFunction);
        } else {
            binaryFunction = new BinaryFunction((ICElement)this, iSymbol.getName(), iSymbol.getAddress());
            binaryFunction.setLines(iSymbol.getStartLine(), iSymbol.getEndLine());
            openableInfo.addChild(binaryFunction);
        }
    }

    private void addVariable(OpenableInfo openableInfo, IBinaryParser.ISymbol iSymbol, Map map) throws CModelException {
        IPath iPath = iSymbol.getFilename();
        BinaryVariable binaryVariable = null;
        if (iPath != null) {
            BinaryModule binaryModule = null;
            if (map.containsKey(iPath)) {
                binaryModule = (BinaryModule)map.get(iPath);
            } else {
                binaryModule = new BinaryModule(this, iPath);
                map.put(iPath, binaryModule);
                openableInfo.addChild(binaryModule);
            }
            binaryVariable = new BinaryVariable((ICElement)binaryModule, iSymbol.getName(), iSymbol.getAddress());
            binaryVariable.setLines(iSymbol.getStartLine(), iSymbol.getEndLine());
            binaryModule.addChild(binaryVariable);
        } else {
            binaryVariable = new BinaryVariable((ICElement)this, iSymbol.getName(), iSymbol.getAddress());
            binaryVariable.setLines(iSymbol.getStartLine(), iSymbol.getEndLine());
            openableInfo.addChild(binaryVariable);
        }
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) throws CModelException {
        BufferManager bufferManager = this.getBufferManager();
        IBuffer iBuffer = this.getBufferFactory().createBuffer(this);
        if (iBuffer == null) {
            return null;
        }
        if (iBuffer.getCharacters() == null) {
            IBinaryParser.IBinaryObject iBinaryObject = this.getBinaryObject();
            if (iBinaryObject != null) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    int n;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iBinaryObject.getContents()));
                    char[] cArray = new char[512];
                    while ((n = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
                        stringBuffer.append(cArray, 0, n);
                    }
                }
                catch (IOException iOException) {}
                iBuffer.setContents(stringBuffer.toString());
            } else {
                IResource iResource = this.getResource();
                if (iResource != null && iResource.getType() == 1) {
                    iBuffer.setContents(Util.getResourceContentsAsCharArray((IFile)iResource));
                }
            }
        }
        bufferManager.addBuffer(iBuffer);
        return iBuffer;
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean exists() {
        return this.getResource() != null;
    }

    protected void closing(Object object) throws CModelException {
        ICProject iCProject = this.getCProject();
        CProjectInfo cProjectInfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(iCProject);
        if (cProjectInfo != null && cProjectInfo.vBin != null) {
            cProjectInfo.vBin.removeChild(this);
        }
        super.closing(object);
    }
}

