/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class BinaryRunner {
    ICProject cproject;
    Job runner;

    public BinaryRunner(IProject iProject) {
        this.cproject = CModelManager.getDefault().create(iProject);
    }

    public void start() {
        String string = CCorePlugin.getResourceString("CoreModel.BinaryRunner.Binary_Search_Thread");
        this.runner = new Job(string){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (BinaryRunner.this.cproject == null || iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    BinaryContainer binaryContainer = (BinaryContainer)BinaryRunner.this.cproject.getBinaryContainer();
                    ArchiveContainer archiveContainer = (ArchiveContainer)BinaryRunner.this.cproject.getArchiveContainer();
                    archiveContainer.removeChildren();
                    binaryContainer.removeChildren();
                    BinaryRunner.this.cproject.getProject().accept((IResourceVisitor)new Visitor(BinaryRunner.this, iProgressMonitor));
                    BinaryRunner.this.fireEvents(BinaryRunner.this.cproject, binaryContainer);
                    BinaryRunner.this.fireEvents(BinaryRunner.this.cproject, archiveContainer);
                }
                catch (CoreException coreException) {
                    return coreException.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        this.runner.schedule();
    }

    public void waitIfRunning() {
        if (this.runner != null) {
            try {
                this.runner.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        if (this.runner != null && this.runner.getState() == 4) {
            this.runner.cancel();
        }
    }

    void fireEvents(ICProject iCProject, Parent parent) {
        try {
            ICElement[] iCElementArray = parent.getChildren();
            if (iCElementArray.length > 0) {
                CModelManager cModelManager = CModelManager.getDefault();
                CModel cModel = cModelManager.getCModel();
                CElementDelta cElementDelta = new CElementDelta(cModel);
                cElementDelta.added(iCProject);
                cElementDelta.added(parent);
                int n = 0;
                while (n < iCElementArray.length) {
                    cElementDelta.added(iCElementArray[n]);
                    ++n;
                }
                cModelManager.registerCModelDelta(cElementDelta);
                cModelManager.fire(1);
            }
        }
        catch (CModelException cModelException) {}
    }

    void addChildIfBinary(IFile iFile) {
        IBinaryParser.IBinaryFile iBinaryFile;
        CModelManager cModelManager = CModelManager.getDefault();
        if (!CoreModel.isTranslationUnit(iFile) && (iBinaryFile = cModelManager.createBinaryFile(iFile)) != null) {
            cModelManager.create(iFile, iBinaryFile, null);
        }
    }

    class Visitor
    implements IResourceVisitor {
        private BinaryRunner vRunner;
        private IProgressMonitor vMonitor;

        public Visitor(BinaryRunner binaryRunner2, IProgressMonitor iProgressMonitor) {
            this.vRunner = binaryRunner2;
            this.vMonitor = iProgressMonitor;
        }

        public boolean visit(IResource iResource) throws CoreException {
            if (this.vMonitor.isCanceled()) {
                return false;
            }
            if (BinaryRunner.this.cproject.isOnOutputEntry(iResource) && iResource instanceof IFile) {
                if (this.vRunner != null) {
                    this.vRunner.addChildIfBinary((IFile)iResource);
                }
                return false;
            }
            return true;
        }
    }
}

