/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Enumeration;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.core.model.Buffer;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.util.LRUCache;
import org.eclipse.cdt.internal.core.util.OverflowingLRUCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class BufferManager
implements IBufferFactory {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected OverflowingLRUCache openBuffers = new BufferCache(60);

    protected void addBuffer(IBuffer iBuffer) {
        this.openBuffers.put(iBuffer.getOwner(), iBuffer);
    }

    public IBuffer createBuffer(IOpenable iOpenable) {
        ICElement iCElement = (ICElement)((Object)iOpenable);
        IResource iResource = iCElement.getResource();
        return new Buffer(iResource instanceof IFile ? (IFile)iResource : null, iOpenable, iCElement.isReadOnly());
    }

    public IBuffer getBuffer(IOpenable iOpenable) {
        return (IBuffer)this.openBuffers.get(iOpenable);
    }

    public IBufferFactory getDefaultBufferFactory() {
        return this;
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    public Enumeration getOpenBuffers() {
        OverflowingLRUCache overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            this.openBuffers.shrink();
            return this.openBuffers.elements();
        }
    }

    protected void removeBuffer(IBuffer iBuffer) {
        this.openBuffers.remove(iBuffer.getOwner());
    }

    public class BufferCache
    extends OverflowingLRUCache {
        public BufferCache(int n) {
            super(n);
        }

        public BufferCache(int n, int n2) {
            super(n, n2);
        }

        protected boolean close(LRUCache.LRUCacheEntry lRUCacheEntry) {
            IBuffer iBuffer = (IBuffer)lRUCacheEntry._fValue;
            if (iBuffer.hasUnsavedChanges()) {
                return false;
            }
            iBuffer.close();
            return true;
        }

        protected LRUCache newInstance(int n, int n2) {
            return new BufferCache(n, n2);
        }
    }
}

