/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CElement
extends PlatformObject
implements ICElement {
    protected static final CElement[] NO_ELEMENTS = new CElement[0];
    protected int fType;
    protected ICElement fParent;
    protected String fName;
    protected int fStartPos;
    protected int fLength;
    protected int fIdStartPos;
    protected int fIdLength;
    protected int fStartLine;
    protected int fEndLine;

    protected CElement(ICElement iCElement, String string, int n) {
        this.fParent = iCElement;
        this.fName = string;
        this.fType = n;
    }

    public void setElementType(int n) {
        this.fType = n;
    }

    public void setElementName(String string) {
        this.fName = string;
    }

    public void setParent(ICElement iCElement) {
        this.fParent = iCElement;
    }

    public int getElementType() {
        return this.fType;
    }

    public String getElementName() {
        return this.fName;
    }

    public ICElement getParent() {
        return this.fParent;
    }

    public IPath getPath() {
        IResource iResource = this.getUnderlyingResource();
        if (iResource != null) {
            return iResource.getFullPath();
        }
        return new Path(this.getElementName());
    }

    public boolean exists() {
        try {
            return this.getElementInfo() != null;
        }
        catch (CModelException cModelException) {
            return false;
        }
    }

    protected ICElement getSourceElementAtOffset(int n) throws CModelException {
        if (this instanceof ISourceReference && this instanceof Parent) {
            ICElement[] iCElementArray = ((Parent)this).getChildren();
            int n2 = 0;
            while (n2 < iCElementArray.length) {
                ISourceReference iSourceReference;
                ISourceRange iSourceRange;
                int n3;
                int n4;
                ICElement iCElement = iCElementArray[n2];
                if (iCElement instanceof ISourceReference && n < (n4 = (n3 = (iSourceRange = (iSourceReference = (ISourceReference)((Object)iCElementArray[n2])).getSourceRange()).getStartPos()) + iSourceRange.getLength()) && n >= n3) {
                    if (iSourceReference instanceof Parent) {
                        return ((Parent)((Object)iSourceReference)).getSourceElementAtOffset(n);
                    }
                    return (ICElement)((Object)iSourceReference);
                }
                ++n2;
            }
        }
        return this;
    }

    protected ICElement[] getSourceElementsAtOffset(int n) throws CModelException {
        if (this instanceof ISourceReference && this instanceof Parent) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ICElement[] iCElementArray = ((Parent)this).getChildren();
            int n2 = 0;
            while (n2 < iCElementArray.length) {
                ISourceReference iSourceReference;
                ISourceRange iSourceRange;
                int n3;
                int n4;
                ICElement iCElement = iCElementArray[n2];
                if (iCElement instanceof ISourceReference && n < (n4 = (n3 = (iSourceRange = (iSourceReference = (ISourceReference)((Object)iCElementArray[n2])).getSourceRange()).getStartPos()) + iSourceRange.getLength()) && n >= n3) {
                    if (iSourceReference instanceof Parent) {
                        ICElement[] iCElementArray2 = ((Parent)((Object)iSourceReference)).getSourceElementsAtOffset(n);
                        arrayList.addAll(Arrays.asList(iCElementArray2));
                    }
                    arrayList.add(iSourceReference);
                }
                ++n2;
            }
            iCElementArray = new ICElement[arrayList.size()];
            arrayList.toArray(iCElementArray);
            return iCElementArray;
        }
        return new ICElement[]{this};
    }

    public boolean isReadOnly() {
        IResource iResource = this.getUnderlyingResource();
        if (iResource != null) {
            return iResource.isReadOnly();
        }
        return false;
    }

    public boolean isStructureKnown() throws CModelException {
        return this.getElementInfo().isStructureKnown();
    }

    public ICModel getCModel() {
        ICElement iCElement = this;
        do {
            if (!(iCElement instanceof ICModel)) continue;
            return (ICModel)iCElement;
        } while ((iCElement = iCElement.getParent()) != null);
        return null;
    }

    public ICProject getCProject() {
        ICElement iCElement = this;
        do {
            if (!(iCElement instanceof ICProject)) continue;
            return (ICProject)iCElement;
        } while ((iCElement = iCElement.getParent()) != null);
        return null;
    }

    protected void addChild(ICElement iCElement) throws CModelException {
    }

    public void setPos(int n, int n2) {
        this.fStartPos = n;
        this.fLength = n2;
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setIdPos(int n, int n2) {
        this.fIdStartPos = n;
        this.fIdLength = n2;
    }

    public int getIdStartPos() {
        return this.fIdStartPos;
    }

    public int getIdLength() {
        return this.fIdLength;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public void setLines(int n, int n2) {
        this.fStartLine = n;
        this.fEndLine = n2;
    }

    public IResource getUnderlyingResource() {
        ICElement iCElement;
        IResource iResource = this.getResource();
        if (iResource == null && (iCElement = this.getParent()) != null) {
            iResource = iCElement.getUnderlyingResource();
        }
        return iResource;
    }

    public abstract IResource getResource();

    protected abstract CElementInfo createElementInfo();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CElement) {
            CElement cElement = (CElement)object;
            if (this.fName == null || cElement.fName == null) {
                return false;
            }
            if (this.fName.length() == 0 || cElement.fName.length() == 0) {
                return false;
            }
            if (this.fType != cElement.fType) {
                return false;
            }
            if (this.fName.equals(cElement.fName)) {
                if (this.fParent != null && this.fParent.equals(cElement.fParent)) {
                    return true;
                }
                if (this.fParent == null && cElement.fParent == null) {
                    return true;
                }
            }
        }
        return false;
    }

    public CElementInfo getElementInfo() throws CModelException {
        return this.getElementInfo(null);
    }

    public CElementInfo getElementInfo(IProgressMonitor iProgressMonitor) throws CModelException {
        CModelManager cModelManager = CModelManager.getDefault();
        CElementInfo cElementInfo = (CElementInfo)cModelManager.getInfo(this);
        if (cElementInfo != null) {
            return cElementInfo;
        }
        cElementInfo = this.createElementInfo();
        this.openWhenClosed(cElementInfo, iProgressMonitor);
        return cElementInfo;
    }

    public String toString() {
        return this.getElementName();
    }

    public String toDebugString() {
        return String.valueOf(this.getElementName()) + " " + CElement.getTypeString(this.getElementType());
    }

    public static String getTypeString(int n) {
        switch (n) {
            case 10: {
                return "CMODEL";
            }
            case 11: {
                return "CPROJECT";
            }
            case 12: {
                return "CCONTAINER";
            }
            case 60: {
                return "TRANSLATION_UNIT";
            }
            case 71: {
                return "C_FUNCTION";
            }
            case 70: {
                return "C_FUNCTION_DECLARATION";
            }
            case 74: {
                return "C_VARIABLE";
            }
            case 75: {
                return "C_VARIABLE_DECLARATION";
            }
            case 72: {
                return "C_INCLUDE";
            }
            case 77: {
                return "C_MACRO";
            }
            case 65: {
                return "C_STRUCT";
            }
            case 64: {
                return "C_CLASS";
            }
            case 66: {
                return "C_UNION";
            }
            case 69: {
                return "C_FIELD";
            }
            case 67: {
                return "C_METHOD";
            }
        }
        return "UNKNOWN";
    }

    protected void runOperation(CModelOperation cModelOperation, IProgressMonitor iProgressMonitor) throws CModelException {
        CModelManager.getDefault().runOperation(cModelOperation, iProgressMonitor);
    }

    public void close() throws CModelException {
        CModelManager.getDefault().releaseCElement(this);
    }

    protected void closing(Object object) throws CModelException {
    }

    protected void opening(Object object) {
    }

    public IOpenable getOpenableParent() {
        if (this.fParent instanceof IOpenable) {
            return (IOpenable)((Object)this.fParent);
        }
        return null;
    }

    protected abstract void generateInfos(Object var1, Map var2, IProgressMonitor var3) throws CModelException;

    /*
     * Exception decompiling
     */
    protected void openWhenClosed(CElementInfo var1_1, IProgressMonitor var2_2) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 136->140)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ICElement getAncestor(int n) {
        ICElement iCElement = this;
        while (iCElement != null) {
            if (iCElement.getElementType() == n) {
                return iCElement;
            }
            iCElement = iCElement.getParent();
        }
        return null;
    }

    protected boolean isAncestorOf(ICElement iCElement) {
        ICElement iCElement2 = iCElement.getParent();
        while (iCElement2 != null && !iCElement2.equals(this)) {
            iCElement2 = iCElement2.getParent();
        }
        return iCElement2 != null;
    }

    protected CModelException newNotPresentException() {
        return new CModelException(new CModelStatus(969, this));
    }

    public int hashCode() {
        if (this.fParent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.fName.hashCode(), this.fParent.hashCode());
    }

    public boolean isIdentical(CElement cElement) {
        return this.equals(cElement);
    }

    public void accept(ICElementVisitor iCElementVisitor) throws CoreException {
        if (!iCElementVisitor.visit(this)) {
            return;
        }
        if (this instanceof IParent) {
            ICElement[] iCElementArray = ((IParent)((Object)this)).getChildren();
            int n = 0;
            while (n < iCElementArray.length) {
                iCElementArray[n].accept(iCElementVisitor);
                ++n;
            }
        }
    }
}

