/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.core.resources.IResourceDelta;

public class CElementDelta
implements ICElementDelta {
    protected ICElement fChangedElement;
    private int fKind = 0;
    private int fChangeFlags = 0;
    protected ICElement fMovedFromHandle = null;
    protected ICElement fMovedToHandle = null;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected static ICElementDelta[] fgEmptyDelta = new ICElementDelta[0];
    protected ICElementDelta[] fAffectedChildren = fgEmptyDelta;

    public CElementDelta(ICElement iCElement) {
        this.fChangedElement = iCElement;
    }

    protected void addAffectedChild(CElementDelta cElementDelta) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 8;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 8;
            }
        }
        if (this.fChangedElement.getElementType() < 60) {
            this.fineGrained();
        }
        if (this.fAffectedChildren.length == 0) {
            this.fAffectedChildren = new ICElementDelta[]{cElementDelta};
            return;
        }
        ICElementDelta iCElementDelta = null;
        int n = -1;
        int n2 = 0;
        while (n2 < this.fAffectedChildren.length) {
            if (this.equalsAndSameParent(this.fAffectedChildren[n2].getElement(), cElementDelta.getElement())) {
                iCElementDelta = this.fAffectedChildren[n2];
                n = n2;
                break;
            }
            ++n2;
        }
        if (iCElementDelta == null) {
            this.fAffectedChildren = this.growAndAddToArray(this.fAffectedChildren, cElementDelta);
        } else {
            switch (iCElementDelta.getKind()) {
                case 1: {
                    switch (cElementDelta.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, n);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (cElementDelta.getKind()) {
                        case 1: {
                            cElementDelta.fKind = 4;
                            this.fAffectedChildren[n] = cElementDelta;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (cElementDelta.getKind()) {
                        case 1: 
                        case 2: {
                            this.fAffectedChildren[n] = cElementDelta;
                            return;
                        }
                        case 4: {
                            ICElementDelta[] iCElementDeltaArray = cElementDelta.getAffectedChildren();
                            int n3 = 0;
                            while (n3 < iCElementDeltaArray.length) {
                                CElementDelta cElementDelta2 = (CElementDelta)iCElementDeltaArray[n3];
                                ((CElementDelta)iCElementDelta).addAffectedChild(cElementDelta2);
                                ++n3;
                            }
                            IResourceDelta[] iResourceDeltaArray = cElementDelta.getResourceDeltas();
                            if (iResourceDeltaArray != null) {
                                ((CElementDelta)iCElementDelta).resourceDeltas = iResourceDeltaArray;
                                ((CElementDelta)iCElementDelta).resourceDeltasCounter = cElementDelta.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    n2 = iCElementDelta.getFlags();
                    this.fAffectedChildren[n] = cElementDelta;
                    cElementDelta.fChangeFlags |= n2;
                }
            }
        }
    }

    public void added(ICElement iCElement) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 1;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    protected void addResourceDelta(IResourceDelta iResourceDelta) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 1;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = iResourceDelta;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = iResourceDelta;
    }

    public void changed(ICElement iCElement, int n) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 4;
        cElementDelta.fChangeFlags |= n;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    public void closed(ICElement iCElement) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 4;
        cElementDelta.fChangeFlags |= 0x80;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    protected boolean equalsAndSameParent(ICElement iCElement, ICElement iCElement2) {
        ICElement iCElement3;
        return iCElement.equals(iCElement2) && (iCElement3 = iCElement.getParent()) != null && iCElement3.equals(iCElement2.getParent());
    }

    protected CElementDelta createDeltaTree(ICElement iCElement, CElementDelta cElementDelta) {
        CElementDelta cElementDelta2 = cElementDelta;
        ArrayList arrayList = this.getAncestors(iCElement);
        if (arrayList == null) {
            if (this.equalsAndSameParent(cElementDelta.getElement(), this.getElement())) {
                this.fKind = cElementDelta.fKind;
                this.fChangeFlags = cElementDelta.fChangeFlags;
                this.fMovedToHandle = cElementDelta.fMovedToHandle;
                this.fMovedFromHandle = cElementDelta.fMovedFromHandle;
            }
        } else {
            int n = 0;
            int n2 = arrayList.size();
            while (n < n2) {
                ICElement iCElement2 = (ICElement)arrayList.get(n);
                CElementDelta cElementDelta3 = new CElementDelta(iCElement2);
                cElementDelta3.addAffectedChild(cElementDelta2);
                cElementDelta2 = cElementDelta3;
                ++n;
            }
        }
        return cElementDelta2;
    }

    protected CElementDelta find(ICElement iCElement) {
        if (this.equalsAndSameParent(this.fChangedElement, iCElement)) {
            return this;
        }
        int n = 0;
        while (n < this.fAffectedChildren.length) {
            CElementDelta cElementDelta = ((CElementDelta)this.fAffectedChildren[n]).find(iCElement);
            if (cElementDelta != null) {
                return cElementDelta;
            }
            ++n;
        }
        return null;
    }

    public void fineGrained() {
        this.fChangeFlags |= 0x400000;
    }

    public ICElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    public ICElementDelta[] getAffectedChildren() {
        return this.fAffectedChildren;
    }

    private ArrayList getAncestors(ICElement iCElement) {
        ICElement iCElement2 = iCElement.getParent();
        if (iCElement2 == null) {
            return null;
        }
        ArrayList<ICElement> arrayList = new ArrayList<ICElement>();
        while (!iCElement2.equals(this.fChangedElement)) {
            arrayList.add(iCElement2);
            iCElement2 = iCElement2.getParent();
            if (iCElement2 != null) continue;
            return null;
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public ICElementDelta[] getChangedChildren() {
        return this.getChildrenOfType(4);
    }

    protected ICElementDelta[] getChildrenOfType(int n) {
        int n2 = this.fAffectedChildren.length;
        if (n2 == 0) {
            return new ICElementDelta[0];
        }
        ArrayList<ICElementDelta> arrayList = new ArrayList<ICElementDelta>(n2);
        int n3 = 0;
        while (n3 < n2) {
            if (this.fAffectedChildren[n3].getKind() == n) {
                arrayList.add(this.fAffectedChildren[n3]);
            }
            ++n3;
        }
        ICElementDelta[] iCElementDeltaArray = new ICElementDelta[arrayList.size()];
        arrayList.toArray(iCElementDeltaArray);
        return iCElementDeltaArray;
    }

    protected CElementDelta getDeltaFor(ICElement iCElement) {
        if (this.equalsAndSameParent(this.getElement(), iCElement)) {
            return this;
        }
        if (this.fAffectedChildren.length == 0) {
            return null;
        }
        int n = this.fAffectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            CElementDelta cElementDelta = (CElementDelta)this.fAffectedChildren[n2];
            if (this.equalsAndSameParent(cElementDelta.getElement(), iCElement)) {
                return cElementDelta;
            }
            if ((cElementDelta = cElementDelta.getDeltaFor(iCElement)) != null) {
                return cElementDelta;
            }
            ++n2;
        }
        return null;
    }

    public ICElement getElement() {
        return this.fChangedElement;
    }

    public int getFlags() {
        return this.fChangeFlags;
    }

    public int getKind() {
        return this.fKind;
    }

    public ICElement getMovedFromElement() {
        return this.fMovedFromHandle;
    }

    public ICElement getMovedToElement() {
        return this.fMovedToHandle;
    }

    public ICElementDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected ICElementDelta[] growAndAddToArray(ICElementDelta[] iCElementDeltaArray, ICElementDelta iCElementDelta) {
        ICElementDelta[] iCElementDeltaArray2 = iCElementDeltaArray;
        iCElementDeltaArray = new ICElementDelta[iCElementDeltaArray2.length + 1];
        System.arraycopy(iCElementDeltaArray2, 0, iCElementDeltaArray, 0, iCElementDeltaArray2.length);
        iCElementDeltaArray[iCElementDeltaArray2.length] = iCElementDelta;
        return iCElementDeltaArray;
    }

    protected void insertDeltaTree(ICElement iCElement, CElementDelta cElementDelta) {
        CElementDelta cElementDelta2 = this.createDeltaTree(iCElement, cElementDelta);
        if (!this.equalsAndSameParent(iCElement, this.getElement())) {
            this.addAffectedChild(cElementDelta2);
        }
    }

    public void movedFrom(ICElement iCElement, ICElement iCElement2) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 2;
        cElementDelta.fChangeFlags |= 0x20;
        cElementDelta.fMovedToHandle = iCElement2;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    public void movedTo(ICElement iCElement, ICElement iCElement2) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 1;
        cElementDelta.fChangeFlags |= 0x10;
        cElementDelta.fMovedFromHandle = iCElement2;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    public void opened(ICElement iCElement) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 4;
        cElementDelta.fChangeFlags |= 0x40;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    protected void removeAffectedChild(CElementDelta cElementDelta) {
        int n = -1;
        if (this.fAffectedChildren != null) {
            int n2 = 0;
            while (n2 < this.fAffectedChildren.length) {
                if (this.equalsAndSameParent(this.fAffectedChildren[n2].getElement(), cElementDelta.getElement())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (n >= 0) {
            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, n);
        }
    }

    protected ICElementDelta[] removeAndShrinkArray(ICElementDelta[] iCElementDeltaArray, int n) {
        int n2;
        ICElementDelta[] iCElementDeltaArray2 = new ICElementDelta[iCElementDeltaArray.length - 1];
        if (n > 0) {
            System.arraycopy(iCElementDeltaArray, 0, iCElementDeltaArray2, 0, n);
        }
        if ((n2 = iCElementDeltaArray.length - n - 1) > 0) {
            System.arraycopy(iCElementDeltaArray, n + 1, iCElementDeltaArray2, n, n2);
        }
        return iCElementDeltaArray2;
    }

    public void removed(ICElement iCElement) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        this.insertDeltaTree(iCElement, cElementDelta);
        CElementDelta cElementDelta2 = this.getDeltaFor(iCElement);
        if (cElementDelta2 != null) {
            cElementDelta2.fKind = 2;
            cElementDelta2.fChangeFlags = 0;
            cElementDelta2.fAffectedChildren = fgEmptyDelta;
        }
    }

    public void binaryParserChanged(ICElement iCElement) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 4;
        cElementDelta.fChangeFlags |= 0x800000;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    public void sourceAttached(ICElement iCElement) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 4;
        cElementDelta.fChangeFlags |= 0x100000;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    public void sourceDetached(ICElement iCElement) {
        CElementDelta cElementDelta = new CElementDelta(iCElement);
        cElementDelta.fKind = 4;
        cElementDelta.fChangeFlags |= 0x200000;
        this.insertDeltaTree(iCElement, cElementDelta);
    }

    public String toDebugString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append('\t');
            ++n3;
        }
        stringBuffer.append(((CElement)this.getElement()).toDebugString());
        stringBuffer.append(" [");
        switch (this.getKind()) {
            case 1: {
                stringBuffer.append('+');
                break;
            }
            case 2: {
                stringBuffer.append('-');
                break;
            }
            case 4: {
                stringBuffer.append('*');
                break;
            }
            default: {
                stringBuffer.append('?');
            }
        }
        stringBuffer.append("]: {");
        n3 = this.getFlags();
        boolean bl = false;
        if ((n3 & 8) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CHILDREN");
            bl = true;
        }
        if ((n3 & 1) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CONTENT");
            bl = true;
        }
        if ((n3 & 0x10) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            bl = true;
        }
        if ((n3 & 0x20) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            bl = true;
        }
        if ((n3 & 2) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("MODIFIERS CHANGED");
            bl = true;
        }
        if ((n3 & 0x800) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CHANGED TO PATHENTRY INCLUDE");
            bl = true;
        }
        if ((n3 & 0x400) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CHANGED TO PATHENTRY MACRO");
            bl = true;
        }
        if ((n3 & 0x1000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("ADDED TO PATHENTRY LIBRARY");
            bl = true;
        }
        if ((n3 & 0x2000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("ADDED TO PATHENTRY LIBRARY");
            bl = true;
        }
        if ((n3 & 0x40000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("PATHENTRY REORDER");
            bl = true;
        }
        if ((n3 & 0x400000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("FINE GRAINED");
            bl = true;
        }
        stringBuffer.append("}");
        ICElementDelta[] iCElementDeltaArray = this.getAffectedChildren();
        if (iCElementDeltaArray != null) {
            n2 = 0;
            while (n2 < iCElementDeltaArray.length) {
                stringBuffer.append("\n");
                stringBuffer.append(((CElementDelta)iCElementDeltaArray[n2]).toDebugString(n + 1));
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.resourceDeltasCounter) {
            stringBuffer.append("\n");
            int n4 = 0;
            while (n4 < n + 1) {
                stringBuffer.append('\t');
                ++n4;
            }
            IResourceDelta iResourceDelta = this.resourceDeltas[n2];
            stringBuffer.append(iResourceDelta.toString());
            stringBuffer.append("[");
            switch (iResourceDelta.getKind()) {
                case 1: {
                    stringBuffer.append('+');
                    break;
                }
                case 2: {
                    stringBuffer.append('-');
                    break;
                }
                case 4: {
                    stringBuffer.append('*');
                    break;
                }
                default: {
                    stringBuffer.append('?');
                }
            }
            stringBuffer.append("]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toDebugString(0);
    }
}

