/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.core.resources.IResource;

class CElementInfo {
    static Object[] NO_NON_C_RESOURCES = new Object[0];
    protected CElement element;
    private List fChildren;
    protected boolean fIsStructureKnown = false;
    protected long modificationStamp = 0L;

    protected CElementInfo(CElement cElement) {
        this.element = cElement;
        this.fChildren = new Vector(0);
    }

    protected CElement getElement() {
        return this.element;
    }

    protected void addChild(ICElement iCElement) {
        this.fChildren.add(iCElement);
    }

    protected ICElement[] getChildren() {
        List list = this.fChildren;
        synchronized (list) {
            ICElement[] iCElementArray = new ICElement[this.fChildren.size()];
            return this.fChildren.toArray(iCElementArray);
        }
    }

    protected boolean includesChild(ICElement iCElement) {
        return this.fChildren.contains(iCElement);
    }

    protected boolean isStructureKnown() {
        return this.fIsStructureKnown;
    }

    protected void removeChild(ICElement iCElement) {
        this.fChildren.remove(iCElement);
    }

    protected void removeChildren() {
        this.fChildren.clear();
    }

    protected void setChildren(List list) {
        this.fChildren.addAll(list);
    }

    protected boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    protected void setChanged() {
        this.modificationStamp = 0L;
    }

    protected boolean hasChanged() {
        IResource iResource = null;
        boolean bl = false;
        iResource = this.getElement().getUnderlyingResource();
        if (iResource != null && iResource.exists()) {
            long l = 0L;
            switch (iResource.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    File file = iResource.getLocation().toFile();
                    l = file.lastModified();
                    break;
                }
                case 1: {
                    l = iResource.getModificationStamp();
                }
            }
            bl = l != this.modificationStamp;
            this.modificationStamp = l;
        }
        return bl;
    }

    protected void setIsStructureKnown(boolean bl) {
        this.fIsStructureKnown = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }
}

